/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.ActionMouseCursor;
import org.netbeans.modules.mobility.svgcore.composer.ComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.GraphicUtils;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.openide.util.ImageUtilities;

public final class RotateActionFactory
extends AbstractComposerActionFactory {
    private static final int ROTATE_PIVOT_SIZE = 4;
    private static final Color COLOR_ROTATE_PIVOT_BODY = Color.BLACK;
    private static final Color COLOR_ROTATE_PIVOT_OUTLINE = Color.WHITE;
    private static final ActionMouseCursor ROTATE_MOUSE_CURSOR = new ActionMouseCursor(Toolkit.getDefaultToolkit().createCustomCursor(ImageUtilities.loadImage((String)"org/netbeans/modules/mobility/svgcore/resources/rotate_cursor.png"), new Point(8, 8), "rotateCursor"), 3);

    public RotateActionFactory(SceneManager sceneManager) {
        super(sceneManager);
    }

    public synchronized ComposerAction startAction(AWTEvent aWTEvent, boolean bl) {
        MouseEvent mouseEvent;
        SVGObject sVGObject;
        if (!bl && !this.m_sceneMgr.isReadOnly() && aWTEvent.getID() == 501 && (sVGObject = this.getObjectToRotateAt(mouseEvent = (MouseEvent)aWTEvent)) != null) {
            return new RotateAction(sVGObject, mouseEvent);
        }
        return null;
    }

    public ActionMouseCursor getMouseCursor(MouseEvent mouseEvent, boolean bl) {
        if (!bl && this.getObjectToRotateAt(mouseEvent) != null) {
            return ROTATE_MOUSE_CURSOR;
        }
        return null;
    }

    private SVGObject getObjectToRotateAt(MouseEvent mouseEvent) {
        SVGObject sVGObject;
        SVGObject[] sVGObjectArray = this.m_sceneMgr.getSelected();
        if (sVGObjectArray != null && sVGObjectArray.length > 0 && (sVGObject = sVGObjectArray[0]).getOutline().isAtRotateHandlePoint(mouseEvent.getX(), mouseEvent.getY())) {
            return sVGObject;
        }
        return null;
    }

    private class RotateAction
    extends AbstractComposerAction {
        private final SVGObject m_rotated;
        private final float m_initialAngle;

        public RotateAction(SVGObject sVGObject, MouseEvent mouseEvent) {
            super(RotateActionFactory.this);
            this.m_rotated = sVGObject;
            this.repaintRotatePivot();
            this.m_initialAngle = this.calculateRotate(mouseEvent.getX(), mouseEvent.getY());
        }

        public boolean consumeEvent(AWTEvent aWTEvent, boolean bl) {
            if (!bl && aWTEvent.getID() == 506) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                Rectangle rectangle = this.m_rotated.getScreenBBox();
                float f = this.calculateRotate(mouseEvent.getX(), mouseEvent.getY()) - this.m_initialAngle;
                if (f < 0.0f) {
                    f += 360.0f;
                }
                this.m_rotated.rotate(f);
                rectangle.add(this.m_rotated.getScreenBBox());
                this.m_factory.getSceneManager().getScreenManager().repaint(rectangle, 5);
            } else if (aWTEvent.getID() == 502) {
                this.actionCompleted();
                this.m_rotated.commitChanges();
            }
            return false;
        }

        public void paint(Graphics graphics, int n, int n2, boolean bl) {
            if (!bl) {
                float[] fArray = this.m_rotated.getOutline().getRotatePivotPoint();
                GraphicUtils.drawRoundSelectorCorner(graphics, COLOR_ROTATE_PIVOT_OUTLINE, COLOR_ROTATE_PIVOT_BODY, (int)(fArray[0] + (float)n), (int)(fArray[1] + (float)n2), 4);
            }
        }

        public ActionMouseCursor getMouseCursor(boolean bl) {
            return bl ? null : ROTATE_MOUSE_CURSOR;
        }

        public void actionCompleted() {
            this.m_rotated.repaint(5);
            this.repaintRotatePivot();
            this.m_rotated.applyTextChanges();
            this.m_rotated.commitChanges();
            if (this.getScreenManager().getShowAllArea()) {
                this.getScreenManager().refresh();
            }
            super.actionCompleted();
        }

        private void repaintRotatePivot() {
            float[] fArray = this.m_rotated.getOutline().getRotatePivotPoint();
            this.m_rotated.repaint((int)fArray[0] - 4 - 1, (int)fArray[1] - 4 - 1, 11, 11);
        }

        protected float calculateRotate(int n, int n2) {
            float[] fArray = this.m_rotated.getOutline().getRotatePivotPoint();
            return GraphicUtils.calcAngle(fArray[0], fArray[1], n, n2);
        }
    }
}

