/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.debug;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.builtin.IRubyObject;

final class Util {
    private static final Logger LOGGER = Logger.getLogger(Util.class.getName());
    private static final CharSequence JRUBY_BUILTIN_PATH_PART = "builtin" + File.separator + "javasupport";
    private static final CharSequence JRUBY_JAR_PART = "lib" + File.separator + "jruby.jar!" + File.separator;

    private Util() {
    }

    static RubyBoolean toRBoolean(IRubyObject ro, boolean value) {
        return RubyBoolean.newBoolean((Ruby)ro.getRuntime(), (boolean)value);
    }

    static IRubyObject nil(IRubyObject ro) {
        return ro.getRuntime().getNil();
    }

    static String relativizeToPWD(String path) {
        return Util.relativizeFile(System.getProperty("user.dir"), path);
    }

    static String relativizeFile(String base, String filepath) {
        String result = filepath;
        if (filepath.startsWith(base)) {
            result = filepath.substring(base.length() + 1);
        }
        return result;
    }

    static boolean areSameFiles(String first, String second) {
        try {
            String firstF = new File(first).getCanonicalPath();
            String secondF = new File(second).getCanonicalPath();
            return firstF.equals(secondF);
        }
        catch (IOException ioe) {
            LOGGER.fine("Cannot resolve cannocical path (falling back to String comparison):\n  first: " + first + "\n  second: " + second + "\n  ioe:" + ioe);
            return first.equals(second);
        }
    }

    static void logEvent(RubyEvent event, String file, int line, String methodName, IRubyObject klass) {
        System.err.printf("%s:%s [%s] %s#%s\n", file, line, event, klass, methodName);
    }

    static boolean isJRubyCore(String file) {
        return file.contains(JRUBY_BUILTIN_PATH_PART) || file.contains(JRUBY_JAR_PART);
    }

    static boolean isLineEvent(String event) {
        return RubyEvent.LINE.getName().equals(event);
    }

    static RubyEvent typeForEvent(String event) {
        if ("line".equals(event)) {
            return RubyEvent.LINE;
        }
        if ("class".equals(event)) {
            return RubyEvent.CLASS;
        }
        if ("end".equals(event)) {
            return RubyEvent.END;
        }
        if ("call".equals(event)) {
            return RubyEvent.CALL;
        }
        if ("return".equals(event)) {
            return RubyEvent.RETURN;
        }
        if ("c-call".equals(event)) {
            return RubyEvent.C_CALL;
        }
        if ("c-return".equals(event)) {
            return RubyEvent.C_RETURN;
        }
        if ("raise".equals(event)) {
            return RubyEvent.RAISE;
        }
        throw new IllegalArgumentException("unknown event type: " + event);
    }
}

