/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractAction;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.spi.tasklist.Task;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.EditCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class OpenTaskAction
extends AbstractAction {
    private Task task;

    public OpenTaskAction(Task task) {
        super(NbBundle.getMessage(OpenTaskAction.class, (String)"LBL_ShowSource"));
        assert (null != task);
        this.task = task;
        this.setEnabled(this.canOpenTask());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        DataObject dataObject;
        if (!this.canOpenTask()) {
            return;
        }
        ActionListener actionListener = Accessor.getDefaultAction(this.task);
        if (null != actionListener) {
            actionListener.actionPerformed(actionEvent);
            return;
        }
        URL uRL = Accessor.getURL(this.task);
        if (null != uRL) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
            return;
        }
        int n = Accessor.getLine(this.task) - 1;
        FileObject fileObject = Accessor.getFile(this.task);
        if (null == fileObject) {
            return;
        }
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return;
        }
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (null != lineCookie && this.openAt(lineCookie, n)) {
            return;
        }
        EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
        if (null != editCookie) {
            editCookie.edit();
            return;
        }
        OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
        if (null != openCookie) {
            openCookie.open();
            return;
        }
        ViewCookie viewCookie = (ViewCookie)dataObject.getCookie(ViewCookie.class);
        if (null != viewCookie) {
            viewCookie.view();
            return;
        }
    }

    private boolean openAt(LineCookie lineCookie, int n) {
        Line.Set set = lineCookie.getLineSet();
        try {
            Line line = set.getCurrent(n);
            if (null == line) {
                line = set.getCurrent(0);
            }
            if (null != line) {
                line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                return true;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    private boolean canOpenTask() {
        if (null != Accessor.getDefaultAction(this.task)) {
            return true;
        }
        URL uRL = Accessor.getURL(this.task);
        if (null != uRL) {
            return true;
        }
        FileObject fileObject = Accessor.getFile(this.task);
        if (null == fileObject) {
            return false;
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return false;
        }
        if (Accessor.getLine(this.task) > 0) {
            return null != dataObject.getCookie(LineCookie.class);
        }
        return null != dataObject.getCookie(OpenCookie.class) || null != dataObject.getCookie(EditCookie.class) || null != dataObject.getCookie(ViewCookie.class);
    }
}

