/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.php.dbgp.BackendLauncher;
import org.netbeans.modules.php.dbgp.ConversionUtils;
import org.netbeans.modules.php.dbgp.DbgpEngineProvider;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.DebuggerOptions;
import org.netbeans.modules.php.dbgp.ServerThread;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.openide.util.Cancellable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionManager {
    static String ID = "netbeans-PHP-DBGP-DebugInfo";
    private Set<DebugSession> debugSessions = new CopyOnWriteArraySet<DebugSession>();
    private ServerThread serverThread = new ServerThread(this);
    private static final SessionManager INSTANCE = new SessionManager();

    public static SessionManager getInstance() {
        return INSTANCE;
    }

    SessionManager() {
    }

    public synchronized void startSession(SessionId sessionId, DebuggerOptions debuggerOptions, Callable<Cancellable> callable) {
        Session[] sessionArray;
        DebugSession debugSession = new DebugSession(debuggerOptions, new BackendLauncher(callable));
        DebuggerInfo debuggerInfo = DebuggerInfo.create((String)ID, (Object[])new Object[]{sessionId, debugSession});
        DebuggerInfo.create((String)ID, (Object[])new Object[]{sessionId, debugSession});
        DebuggerEngine[] debuggerEngineArray = DebuggerManager.getDebuggerManager().startDebugging(debuggerInfo);
        for (Session session : sessionArray = DebuggerManager.getDebuggerManager().getSessions()) {
            DebugSession debugSession2 = (DebugSession)session.lookupFirst(null, DebugSession.class);
            if (debugSession2 == null || debugSession2 != debugSession) continue;
            debugSession.setSession(session);
        }
        this.serverThread.invokeLater();
    }

    synchronized DebugSession add(DebugSession debugSession) {
        this.debugSessions.add(debugSession);
        return debugSession;
    }

    synchronized DebugSession remove(DebugSession debugSession) {
        this.debugSessions.remove(debugSession);
        return debugSession;
    }

    public synchronized List<DebugSession> findSessionsById(SessionId sessionId) {
        LinkedList<DebugSession> linkedList = new LinkedList<DebugSession>();
        for (DebugSession debugSession : this.debugSessions) {
            SessionId sessionId2 = debugSession.getSessionId();
            if (!sessionId.equals(sessionId2)) continue;
            linkedList.add(debugSession);
        }
        return linkedList;
    }

    public synchronized DebugSession getCurrentSession(SessionId sessionId) {
        if (sessionId == null) {
            return null;
        }
        return ConversionUtils.toDebugSession(sessionId);
    }

    public synchronized void stop(Session session) {
        SessionId sessionId = (SessionId)session.lookupFirst(null, SessionId.class);
        List<DebugSession> list = this.findSessionsById(sessionId);
        for (DebugSession debugSession : list) {
            debugSession.cancel();
            this.remove(debugSession);
        }
        Session[] sessionArray = DebuggerManager.getDebuggerManager().getSessions();
        boolean bl = true;
        for (Session session2 : sessionArray) {
            if (session2.equals(session) || session2.lookupFirst(null, SessionId.class) == null) continue;
            bl = false;
        }
        if (bl) {
            this.serverThread.cancel();
        }
        this.stopEngines(session);
    }

    private void stopEngines(Session session) {
        String[] stringArray;
        for (String string : stringArray = session.getSupportedLanguages()) {
            DebuggerEngine debuggerEngine = session.getEngineForLanguage(string);
            ((DbgpEngineProvider)((Object)debuggerEngine.lookupFirst(null, DebuggerEngineProvider.class))).getDestructor().killEngine();
        }
    }
}

