/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.breakpoints;

import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.breakpoints.AbstractBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.LineBreakpoint;
import org.netbeans.modules.php.dbgp.models.ViewModelSupport;
import org.netbeans.modules.php.dbgp.packets.Stack;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class BreakpointModel
extends ViewModelSupport
implements NodeModel {
    public static final String BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpoint";
    public static final String LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint";
    public static final String CURRENT_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpointHit";
    public static final String CURRENT_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/BreakpointHit";
    public static final String DISABLED_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledNonLineBreakpoint";
    public static final String DISABLED_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledBreakpoint";
    public static final String DISABLED_CURRENT_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledNonLineBreakpointHit";
    public static final String DISABLED_CURRENT_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledBreakpointHit";
    public static final String LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/ConditionalBreakpoint";
    public static final String CURRENT_LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/ConditionalBreakpointHit";
    public static final String DISABLED_LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledConditionalBreakpoint";
    private static final String METHOD = "TXT_Method";
    private static final String PARENS = "()";
    private Map<DebugSession, AbstractBreakpoint> myCurrentBreakpoints = new WeakHashMap<DebugSession, AbstractBreakpoint>();

    public void clearModel() {
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object instanceof LineBreakpoint) {
            LineBreakpoint lineBreakpoint = (LineBreakpoint)((Object)object);
            FileObject fileObject = (FileObject)lineBreakpoint.getLine().getLookup().lookup(FileObject.class);
            return fileObject.getNameExt() + ":" + (lineBreakpoint.getLine().getLineNumber() + 1);
        }
        if (object instanceof FunctionBreakpoint) {
            FunctionBreakpoint functionBreakpoint = (FunctionBreakpoint)((Object)object);
            StringBuilder stringBuilder = new StringBuilder(NbBundle.getMessage(BreakpointModel.class, (String)METHOD));
            stringBuilder.append(" ");
            stringBuilder.append(functionBreakpoint.getFunction());
            stringBuilder.append(PARENS);
            return stringBuilder.toString();
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIconBase(Object object) throws UnknownTypeException {
        Object object2 = this.myCurrentBreakpoints;
        synchronized (object2) {
            for (AbstractBreakpoint abstractBreakpoint : this.myCurrentBreakpoints.values()) {
                if (!object.equals((Object)abstractBreakpoint)) continue;
                return this.getCurrentBreakpointIconBase(abstractBreakpoint);
            }
        }
        if (object instanceof LineBreakpoint) {
            object2 = (LineBreakpoint)((Object)object);
            if (!((AbstractBreakpoint)((Object)object2)).isEnabled()) {
                return DISABLED_LINE_BREAKPOINT;
            }
            return LINE_BREAKPOINT;
        }
        if (object instanceof AbstractBreakpoint) {
            object2 = (AbstractBreakpoint)((Object)object);
            if (!((AbstractBreakpoint)((Object)object2)).isEnabled()) {
                return DISABLED_BREAKPOINT;
            }
            return BREAKPOINT;
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object instanceof LineBreakpoint) {
            return ((LineBreakpoint)((Object)object)).getLine().getDisplayName();
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentStack(Stack stack, DebugSession debugSession) {
        if (stack == null) {
            Map<DebugSession, AbstractBreakpoint> map = this.myCurrentBreakpoints;
            synchronized (map) {
                AbstractBreakpoint abstractBreakpoint = this.myCurrentBreakpoints.remove(debugSession);
                this.fireChangeEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)abstractBreakpoint));
            }
            return;
        }
        String string = stack.getCurrentCommandName();
        if (this.foundLineBreakpoint(stack.getLine() - 1, debugSession)) {
            return;
        }
        this.foundFunctionBreakpoint(string, debugSession);
    }

    private String getCurrentBreakpointIconBase(AbstractBreakpoint abstractBreakpoint) {
        if (abstractBreakpoint instanceof LineBreakpoint) {
            return CURRENT_LINE_BREAKPOINT;
        }
        return CURRENT_BREAKPOINT;
    }

    private boolean foundFunctionBreakpoint(String string, DebugSession debugSession) {
        return this.foundBreakpoint(debugSession, new FunctionBreakpointAcceptor(string));
    }

    private boolean foundLineBreakpoint(int n, DebugSession debugSession) {
        return this.foundBreakpoint(debugSession, new LineBreakpointAcceptor(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean foundBreakpoint(DebugSession debugSession, Acceptor acceptor) {
        Breakpoint[] breakpointArray;
        for (Breakpoint breakpoint : breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints()) {
            if (!(breakpoint instanceof AbstractBreakpoint) || !((AbstractBreakpoint)breakpoint).isSessionRelated(debugSession) || !acceptor.accept(breakpoint)) continue;
            AbstractBreakpoint abstractBreakpoint = (AbstractBreakpoint)breakpoint;
            Map<DebugSession, AbstractBreakpoint> map = this.myCurrentBreakpoints;
            synchronized (map) {
                AbstractBreakpoint abstractBreakpoint2 = this.myCurrentBreakpoints.get(debugSession);
                this.myCurrentBreakpoints.put(debugSession, abstractBreakpoint);
                this.fireChangeEvents(new ModelEvent[]{new ModelEvent.NodeChanged((Object)this, (Object)abstractBreakpoint2), new ModelEvent.NodeChanged((Object)this, (Object)abstractBreakpoint)});
            }
            return true;
        }
        return false;
    }

    private class FunctionBreakpointAcceptor
    implements Acceptor {
        private String myFunction;

        FunctionBreakpointAcceptor(String string) {
            this.myFunction = string;
        }

        public boolean accept(Breakpoint breakpoint) {
            if (!(breakpoint instanceof FunctionBreakpoint)) {
                return false;
            }
            String string = ((FunctionBreakpoint)breakpoint).getFunction();
            return string == null ? false : string.equals(this.myFunction);
        }
    }

    private class LineBreakpointAcceptor
    implements Acceptor {
        private int myLine;

        LineBreakpointAcceptor(int n) {
            this.myLine = n;
        }

        public boolean accept(Breakpoint breakpoint) {
            if (!(breakpoint instanceof LineBreakpoint)) {
                return false;
            }
            LineBreakpoint lineBreakpoint = (LineBreakpoint)breakpoint;
            return this.myLine == lineBreakpoint.getLine().getLineNumber();
        }
    }

    private static interface Acceptor {
        public boolean accept(Breakpoint var1);
    }
}

