/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.viewmodel;

import java.beans.PropertyEditor;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.nodes.PropertySupport;

public class Column
extends PropertySupport.ReadWrite {
    public static final String PROP_ORDER_NUMBER = "OrderNumberOutline";
    private PropertyEditor propertyEditor;
    private ColumnModel columnModel;

    Column(ColumnModel columnModel) {
        super(columnModel.getID(), columnModel.getType() == null ? String.class : columnModel.getType(), Actions.cutAmpersand((String)columnModel.getDisplayName()), columnModel.getShortDescription());
        Character c;
        this.columnModel = columnModel;
        this.setValue("ComparableColumnTTV", columnModel.isSortable());
        if (columnModel.getType() == null) {
            this.setValue("TreeColumnTTV", Boolean.TRUE);
        }
        if (Mnemonics.findMnemonicAmpersand((String)columnModel.getDisplayName()) >= 0) {
            this.setValue("ColumnDisplayNameWithMnemonicTTV", columnModel.getDisplayName());
        }
        if ((c = columnModel.getDisplayedMnemonic()) != null) {
            this.setValue("ColumnMnemonicCharTTV", c);
        }
        this.propertyEditor = columnModel.getPropertyEditor();
    }

    int getColumnWidth() {
        return this.columnModel.getColumnWidth();
    }

    void setColumnWidth(int n) {
        this.columnModel.setColumnWidth(n);
    }

    int getOrderNumber() {
        Object object = this.getValue("OrderNumberTTV");
        if (object == null) {
            return -1;
        }
        return (Integer)object;
    }

    int getModelOrderNumber() {
        return this.columnModel.getCurrentOrderNumber();
    }

    boolean isDefault() {
        return this.columnModel.getType() == null;
    }

    public boolean isHidden() {
        return !this.columnModel.isVisible();
    }

    public void setHidden(boolean bl) {
        this.columnModel.setVisible(!bl);
    }

    public Object getValue() {
        return null;
    }

    public void setValue(Object object) {
    }

    public Object getValue(String string) {
        if (PROP_ORDER_NUMBER.equals(string)) {
            int n = this.columnModel.getCurrentOrderNumber();
            return new Integer(n);
        }
        if ("InvisibleInTreeTableView".equals(string)) {
            return !this.columnModel.isVisible();
        }
        if ("SortingColumnTTV".equals(string)) {
            return this.columnModel.isSorted();
        }
        if ("DescendingOrderTTV".equals(string)) {
            return this.columnModel.isSortedDescending();
        }
        return super.getValue(string);
    }

    public void setValue(String string, Object object) {
        if (PROP_ORDER_NUMBER.equals(string)) {
            int n = (Integer)object;
            this.columnModel.setCurrentOrderNumber(n);
        } else if ("SortingColumnTTV".equals(string)) {
            this.columnModel.setSorted((Boolean)object);
        } else if ("DescendingOrderTTV".equals(string)) {
            this.columnModel.setSortedDescending((Boolean)object);
        } else {
            super.setValue(string, object);
        }
    }

    boolean isSorted() {
        return this.columnModel.isSorted();
    }

    boolean isSortedDescending() {
        return this.columnModel.isSortedDescending();
    }

    void setSorted(boolean bl) {
        this.columnModel.setSorted(bl);
    }

    void setSortedDescending(boolean bl) {
        this.columnModel.setSortedDescending(bl);
    }

    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }
}

