/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.fold;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.modules.editor.fold.ApiPackageAccessor;
import org.netbeans.modules.editor.fold.FoldHierarchyExecution;
import org.netbeans.modules.editor.fold.FoldHierarchyTransactionImpl;
import org.netbeans.modules.editor.fold.SpiPackageAccessor;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldOperation;

public final class FoldOperationImpl {
    private static final Logger LOG = Logger.getLogger(FoldHierarchy.class.getName());
    private FoldOperation operation;
    private FoldHierarchyExecution execution;
    private FoldManager manager;
    private int priority;
    private boolean released;

    public FoldOperationImpl(FoldHierarchyExecution foldHierarchyExecution, FoldManager foldManager, int n) {
        this.execution = foldHierarchyExecution;
        this.manager = foldManager;
        this.priority = n;
        this.operation = SpiPackageAccessor.get().createFoldOperation(this);
        if (foldManager != null) {
            foldManager.init(this.getOperation());
        }
    }

    public FoldOperation getOperation() {
        return this.operation;
    }

    public void initFolds(FoldHierarchyTransactionImpl foldHierarchyTransactionImpl) {
        this.manager.initFolds(foldHierarchyTransactionImpl.getTransaction());
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Fold Hierarchy after initFolds():\n" + this.execution + '\n');
            this.execution.checkConsistency();
        }
    }

    public FoldHierarchy getHierarchy() {
        return this.execution.getHierarchy();
    }

    public FoldManager getManager() {
        return this.manager;
    }

    public int getPriority() {
        return this.priority;
    }

    public Document getDocument() {
        return this.execution.getComponent().getDocument();
    }

    public Fold createFold(FoldType foldType, String string, boolean bl, int n, int n2, int n3, int n4, Object object) throws BadLocationException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Creating fold: type=" + foldType + ", description='" + string + "', collapsed=" + bl + ", startOffset=" + n + ", endOffset=" + n2 + ", startGuardedLength=" + n3 + ", endGuardedLength=" + n4 + ", extraInfo=" + object + '\n');
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.INFO, "Fold creation stack", new Exception());
            }
        }
        return FoldOperationImpl.getAccessor().createFold(this, foldType, string, bl, this.getDocument(), n, n2, n3, n4, object);
    }

    public Object getExtraInfo(Fold fold) {
        this.checkFoldOperation(fold);
        return FoldOperationImpl.getAccessor().foldGetExtraInfo(fold);
    }

    public boolean isStartDamaged(Fold fold) {
        this.checkFoldOperation(fold);
        return FoldOperationImpl.getAccessor().foldIsStartDamaged(fold);
    }

    public boolean isEndDamaged(Fold fold) {
        this.checkFoldOperation(fold);
        return FoldOperationImpl.getAccessor().foldIsEndDamaged(fold);
    }

    public FoldHierarchyTransactionImpl openTransaction() {
        return this.execution.openTransaction();
    }

    public boolean addToHierarchy(Fold fold, FoldHierarchyTransactionImpl foldHierarchyTransactionImpl) {
        this.checkFoldOperation(fold);
        return this.execution.add(fold, foldHierarchyTransactionImpl);
    }

    public void removeFromHierarchy(Fold fold, FoldHierarchyTransactionImpl foldHierarchyTransactionImpl) {
        this.checkFoldOperation(fold);
        this.execution.remove(fold, foldHierarchyTransactionImpl);
    }

    public boolean isAddedOrBlocked(Fold fold) {
        this.checkFoldOperation(fold);
        return this.execution.isAddedOrBlocked(fold);
    }

    public boolean isBlocked(Fold fold) {
        this.checkFoldOperation(fold);
        return this.execution.isBlocked(fold);
    }

    public void setEndOffset(Fold fold, int n, FoldHierarchyTransactionImpl foldHierarchyTransactionImpl) throws BadLocationException {
        this.checkFoldOperation(fold);
        int n2 = fold.getEndOffset();
        ApiPackageAccessor apiPackageAccessor = FoldOperationImpl.getAccessor();
        apiPackageAccessor.foldSetEndOffset(fold, this.getDocument(), n);
        apiPackageAccessor.foldStateChangeEndOffsetChanged(foldHierarchyTransactionImpl.getFoldStateChange(fold), n2);
    }

    public void insertUpdate(DocumentEvent documentEvent, FoldHierarchyTransactionImpl foldHierarchyTransactionImpl) {
        this.manager.insertUpdate(documentEvent, foldHierarchyTransactionImpl.getTransaction());
    }

    public void removeUpdate(DocumentEvent documentEvent, FoldHierarchyTransactionImpl foldHierarchyTransactionImpl) {
        this.manager.removeUpdate(documentEvent, foldHierarchyTransactionImpl.getTransaction());
    }

    public void changedUpdate(DocumentEvent documentEvent, FoldHierarchyTransactionImpl foldHierarchyTransactionImpl) {
        this.manager.changedUpdate(documentEvent, foldHierarchyTransactionImpl.getTransaction());
    }

    public void release() {
        this.released = true;
        this.manager.release();
    }

    public boolean isReleased() {
        return this.released;
    }

    private void checkFoldOperation(Fold fold) {
        FoldOperationImpl foldOperationImpl = FoldOperationImpl.getAccessor().foldGetOperation(fold);
        if (foldOperationImpl != this) {
            throw new IllegalStateException("Attempt to use the fold " + fold + " with invalid fold operation " + foldOperationImpl + " instead of " + this);
        }
    }

    private static ApiPackageAccessor getAccessor() {
        return ApiPackageAccessor.get();
    }
}

