/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.lib.editor.bookmarks.api.Bookmark;
import org.netbeans.lib.editor.bookmarks.api.BookmarkList;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.text.NbDocument;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BookmarksPersistence {
    private static final String EDITOR_BOOKMARKS_NAMESPACE_URI = "http://www.netbeans.org/ns/editor-bookmarks/1";
    private static final Map<Project, URLToBookmarks> projectToBookmarks = new WeakHashMap<Project, URLToBookmarks>();
    private static ProjectsListener projectsListener;

    public static void init() {
        projectsListener = new ProjectsListener();
    }

    public static void destroy() {
        if (projectsListener != null) {
            projectsListener.destroy();
        }
        ArrayList<Project> arrayList = new ArrayList<Project>(projectToBookmarks.keySet());
        for (Project project : arrayList) {
            BookmarksPersistence.saveBookmarks(project);
        }
    }

    public static synchronized void loadBookmarks(BookmarkList bookmarkList) {
        Document document = bookmarkList.getDocument();
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        if (fileObject == null) {
            return;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return;
        }
        URLToBookmarks uRLToBookmarks = projectToBookmarks.get(project);
        if (uRLToBookmarks == null && (uRLToBookmarks = BookmarksPersistence.loadBookmarks(project)) != null) {
            projectToBookmarks.put(project, uRLToBookmarks);
        }
        if (uRLToBookmarks == null) {
            return;
        }
        try {
            URL uRL = fileObject.getURL();
            int[] nArray = (int[])uRLToBookmarks.get(uRL);
            if (nArray != null) {
                for (int n : nArray) {
                    try {
                        int n2 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)document), (int)n);
                        bookmarkList.addBookmark(n2);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    private static URLToBookmarks loadBookmarks(Project project) {
        AuxiliaryConfiguration auxiliaryConfiguration = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        Element element = auxiliaryConfiguration.getConfigurationFragment("editor-bookmarks", EDITOR_BOOKMARKS_NAMESPACE_URI, false);
        if (element == null) {
            return null;
        }
        try {
            URLToBookmarks uRLToBookmarks = new URLToBookmarks();
            URL uRL = project.getProjectDirectory().getURL();
            Node node = BookmarksPersistence.skipNonElementNode(element.getFirstChild());
            while (node != null) {
                Object object;
                Object object2;
                assert ("file".equals(node.getNodeName()));
                Node node2 = BookmarksPersistence.skipNonElementNode(node.getFirstChild());
                assert ("url".equals(node2.getNodeName()));
                Node node3 = BookmarksPersistence.skipNonElementNode(node2.getNextSibling());
                int[] nArray = new int[1];
                int n = 0;
                while (node3 != null) {
                    assert ("line".equals(node3.getNodeName()));
                    if (n == nArray.length) {
                        nArray = BookmarksPersistence.reallocateIntArray(nArray, n, n << 1);
                    }
                    try {
                        object2 = node3.getFirstChild();
                        object = object2.getNodeValue();
                        int n2 = Integer.parseInt((String)object);
                        nArray[n++] = n2;
                    }
                    catch (DOMException dOMException) {
                        ErrorManager.getDefault().notify((Throwable)dOMException);
                    }
                    catch (NumberFormatException numberFormatException) {
                        ErrorManager.getDefault().notify((Throwable)numberFormatException);
                    }
                    node3 = BookmarksPersistence.skipNonElementNode(node3.getNextSibling());
                }
                try {
                    try {
                        object = node2.getFirstChild();
                        String string = object.getNodeValue();
                        URI uRI = new URI(string);
                        object2 = !uRI.isAbsolute() && uRL != null ? new URL(uRL, string) : new URL(string);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        ErrorManager.getDefault().notify((Throwable)uRISyntaxException);
                        object2 = null;
                    }
                    catch (MalformedURLException malformedURLException) {
                        ErrorManager.getDefault().notify((Throwable)malformedURLException);
                        object2 = null;
                    }
                    if (object2 != null) {
                        if (n != nArray.length) {
                            nArray = BookmarksPersistence.reallocateIntArray(nArray, n, n);
                        }
                        uRLToBookmarks.put(object2, nArray);
                    }
                }
                catch (DOMException dOMException) {
                    ErrorManager.getDefault().notify((Throwable)dOMException);
                }
                node = BookmarksPersistence.skipNonElementNode(node.getNextSibling());
            }
            return uRLToBookmarks;
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return null;
        }
    }

    private static Node skipNonElementNode(Node node) {
        while (node != null && node.getNodeType() != 1) {
            node = node.getNextSibling();
        }
        return node;
    }

    private static int[] reallocateIntArray(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public static synchronized void saveBookmarks(BookmarkList bookmarkList) {
        Bookmark bookmark;
        Document document = bookmarkList.getDocument();
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        if (fileObject == null) {
            return;
        }
        ArrayList<Bookmark> arrayList = new ArrayList<Bookmark>(bookmarkList.getBookmarks());
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            bookmark = (Bookmark)arrayList.get(i);
            nArray[i] = bookmark.getLineNumber();
        }
        try {
            URL uRL = fileObject.getURL();
            bookmark = FileOwnerQuery.getOwner((FileObject)fileObject);
            URLToBookmarks uRLToBookmarks = projectToBookmarks.get(bookmark);
            if (uRLToBookmarks == null) {
                uRLToBookmarks = new URLToBookmarks();
                projectToBookmarks.put((Project)bookmark, uRLToBookmarks);
            }
            uRLToBookmarks.put(uRL, nArray);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    private static void saveBookmarks(Project project) {
        URI uRI;
        if (!ProjectManager.getDefault().isValid(project)) {
            return;
        }
        AuxiliaryConfiguration auxiliaryConfiguration = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        try {
            uRI = new URI(project.getProjectDirectory().getURL().toExternalForm());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            uRI = null;
        }
        catch (URISyntaxException uRISyntaxException) {
            uRI = null;
        }
        URLToBookmarks uRLToBookmarks = projectToBookmarks.get(project);
        if (uRLToBookmarks == null) {
            return;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            org.w3c.dom.Document document = documentBuilder.newDocument();
            Element element = document.createElementNS(EDITOR_BOOKMARKS_NAMESPACE_URI, "editor-bookmarks");
            for (URL uRL : uRLToBookmarks.keySet()) {
                Object object;
                if (((int[])uRLToBookmarks.get(uRL)).length == 0) continue;
                Element element2 = document.createElementNS(EDITOR_BOOKMARKS_NAMESPACE_URI, "file");
                Element element3 = document.createElementNS(EDITOR_BOOKMARKS_NAMESPACE_URI, "url");
                String string = uRL.toExternalForm();
                if (uRI != null) {
                    try {
                        object = new URI(string);
                        URI uRI2 = uRI.relativize((URI)object);
                        string = uRI2.toString();
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        ErrorManager.getDefault().notify((Throwable)uRISyntaxException);
                    }
                }
                element3.appendChild(document.createTextNode(string));
                element2.appendChild(element3);
                for (Object object2 : object = (Object)((int[])uRLToBookmarks.get(uRL))) {
                    Element element4 = document.createElementNS(EDITOR_BOOKMARKS_NAMESPACE_URI, "line");
                    element4.appendChild(document.createTextNode(Integer.toString((int)object2)));
                    element2.appendChild(element4);
                }
                element.appendChild(element2);
            }
            auxiliaryConfiguration.putConfigurationFragment(element, false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ErrorManager.getDefault().notify((Throwable)parserConfigurationException);
        }
    }

    private static class ProjectsListener
    implements PropertyChangeListener {
        private static List<Project> lastOpenProjects;

        public ProjectsListener() {
            OpenProjects openProjects = OpenProjects.getDefault();
            lastOpenProjects = new ArrayList<Project>(Arrays.asList(openProjects.getOpenProjects()));
            openProjects.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            List<Project> list = Arrays.asList(OpenProjects.getDefault().getOpenProjects());
            lastOpenProjects.removeAll(list);
            Iterator<Project> iterator = lastOpenProjects.iterator();
            while (iterator.hasNext()) {
                BookmarksPersistence.saveBookmarks(iterator.next());
            }
            lastOpenProjects = new ArrayList<Project>(list);
        }

        void destroy() {
            OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class URLToBookmarks
    extends HashMap<URL, int[]> {
        private URLToBookmarks() {
        }
    }
}

