/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesOpen;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.PropertyBundleListener;
import org.netbeans.modules.properties.PropertyBundleSupport;
import org.netbeans.modules.properties.StructHandler;
import org.netbeans.modules.properties.Util;
import org.openide.filesystems.FileObject;
import org.openide.loaders.MultiDataObject;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleStructure {
    PropertiesDataObject obj;
    private PropertiesFileEntry[] entries;
    private List<String> keyList;
    private KeyComparator comparator = new KeyComparator();
    private PropertyBundleSupport propBundleSupport = new PropertyBundleSupport(this);
    private PropertyChangeListener propListener;

    protected BundleStructure() {
        this.obj = null;
    }

    public BundleStructure(PropertiesDataObject propertiesDataObject) {
        this.obj = propertiesDataObject;
        this.updateEntries();
        this.propListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("files")) {
                    BundleStructure.this.updateEntries();
                    BundleStructure.this.propBundleSupport.fireBundleStructureChanged();
                }
            }
        };
        propertiesDataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propListener, (Object)((Object)propertiesDataObject)));
    }

    public PropertiesFileEntry getNthEntry(int n) {
        if (this.entries == null) {
            this.notifyEntriesNotInitialized();
        }
        if (n >= 0 && n < this.entries.length) {
            return this.entries[n];
        }
        return null;
    }

    public int getEntryIndexByFileName(String string) {
        if (this.entries == null) {
            this.notifyEntriesNotInitialized();
        }
        for (int i = 0; i < this.getEntryCount(); ++i) {
            if (!this.entries[i].getFile().getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public PropertiesFileEntry getEntryByFileName(String string) {
        int n = this.getEntryIndexByFileName(string);
        return n == -1 ? null : this.entries[n];
    }

    public int getEntryCount() {
        if (this.entries == null) {
            this.notifyEntriesNotInitialized();
        }
        return this.entries.length;
    }

    public String[] getKeys() {
        if (this.keyList == null) {
            this.notifyKeyListNotInitialized();
        }
        return this.keyList.toArray(new String[0]);
    }

    public String keyAt(int n) {
        if (this.keyList == null) {
            this.notifyKeyListNotInitialized();
        }
        if (n < 0 || n >= this.keyList.size()) {
            return null;
        }
        return this.keyList.get(n);
    }

    public int getKeyIndexByName(String string) {
        if (this.keyList == null) {
            this.notifyKeyListNotInitialized();
        }
        return this.keyList.indexOf(string);
    }

    public String findFreeKey(String string) {
        if (this.keyList == null) {
            this.notifyKeyListNotInitialized();
        }
        int n = 1;
        String string2 = string;
        while (this.keyList.contains(string2)) {
            string2 = string + "_" + n++;
        }
        return string2;
    }

    public Element.ItemElem getItem(int n, int n2) {
        String string = this.keyAt(n2);
        return this.getItem(n, string);
    }

    public Element.ItemElem getItem(int n, String string) {
        if (string == null) {
            return null;
        }
        PropertiesFileEntry propertiesFileEntry = this.getNthEntry(n);
        if (propertiesFileEntry == null) {
            return null;
        }
        PropertiesStructure propertiesStructure = propertiesFileEntry.getHandler().getStructure();
        if (propertiesStructure != null) {
            return propertiesStructure.getItem(string);
        }
        return null;
    }

    public Element.ItemElem getItem(String string, String string2) {
        int n = 0;
        Element.ItemElem itemElem = null;
        for (int i = 0; i < this.getEntryCount(); ++i) {
            Element.ItemElem itemElem2;
            PropertiesStructure propertiesStructure;
            String string3;
            PropertiesFileEntry propertiesFileEntry = this.getNthEntry(i);
            if (propertiesFileEntry == null || !string.startsWith(string3 = propertiesFileEntry.getFile().getName()) || itemElem != null && string3.length() <= n || (propertiesStructure = propertiesFileEntry.getHandler().getStructure()) == null || (itemElem2 = propertiesStructure.getItem(string2)) == null) continue;
            itemElem = itemElem2;
            n = string3.length();
        }
        return itemElem;
    }

    public String[] getAllData(String string) {
        ArrayList<String> arrayList = null;
        for (int i = 0; i < this.getEntryCount(); ++i) {
            Element.ItemElem itemElem;
            PropertiesStructure propertiesStructure;
            PropertiesFileEntry propertiesFileEntry = this.getNthEntry(i);
            if (propertiesFileEntry == null || (propertiesStructure = propertiesFileEntry.getHandler().getStructure()) == null || (itemElem = propertiesStructure.getItem(string)) == null) continue;
            String string2 = Util.getLocaleSuffix((MultiDataObject.Entry)propertiesFileEntry);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(string2);
            arrayList.add(itemElem.getValue());
            arrayList.add(itemElem.getComment());
        }
        return arrayList != null ? arrayList.toArray(new String[arrayList.size()]) : null;
    }

    public void setAllData(String string, String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        int n;
        boolean bl = false;
        for (n = 0; n < stringArray.length; n += 3) {
            object3 = stringArray[n];
            PropertiesFileEntry propertiesFileEntry = null;
            for (int i = 0; i < this.getEntryCount(); ++i) {
                object2 = this.getNthEntry(i);
                if (object2 == null || !Util.getLocaleSuffix((MultiDataObject.Entry)object2).equals(object3)) continue;
                propertiesFileEntry = object2;
                break;
            }
            if (propertiesFileEntry != null) continue;
            Util.createLocaleFile(this.obj, ((String)object3).substring(1), false);
            bl = true;
        }
        if (bl) {
            this.updateEntries();
        }
        block2: for (n = 0; n < stringArray.length; n += 3) {
            object3 = stringArray[n];
            for (int i = 0; i < this.getEntryCount(); ++i) {
                PropertiesFileEntry propertiesFileEntry = this.getNthEntry(i);
                if (propertiesFileEntry == null || !Util.getLocaleSuffix((MultiDataObject.Entry)propertiesFileEntry).equals(object3)) continue;
                object2 = propertiesFileEntry.getHandler().getStructure();
                if (object2 == null) continue block2;
                object = ((PropertiesStructure)object2).getItem(string);
                if (object != null) {
                    ((Element.ItemElem)object).setValue(stringArray[n + 1]);
                    ((Element.ItemElem)object).setComment(stringArray[n + 2]);
                    continue block2;
                }
                ((PropertiesStructure)object2).addItem(string, stringArray[n + 1], stringArray[n + 2]);
                continue block2;
            }
        }
        if (this.getEntryCount() > stringArray.length / 3) {
            for (n = 0; n < this.getEntryCount(); ++n) {
                object3 = this.getNthEntry(n);
                PropertiesStructure propertiesStructure = ((PropertiesFileEntry)((Object)object3)).getHandler().getStructure();
                if (object3 == null || propertiesStructure == null) continue;
                boolean bl2 = false;
                for (int i = 0; i < stringArray.length; i += 3) {
                    object = stringArray[i];
                    if (!Util.getLocaleSuffix((MultiDataObject.Entry)object3).equals(object)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                propertiesStructure.deleteItem(string);
            }
        }
    }

    public int getKeyCount() {
        if (this.keyList != null) {
            return this.keyList.size();
        }
        this.notifyKeyListNotInitialized();
        return 0;
    }

    public void addItem(String string, String string2, String string3, String string4, boolean bl) {
        PropertiesStructure[] propertiesStructureArray = this.getRelatedStructures(string);
        boolean bl2 = false;
        for (int i = 0; i < propertiesStructureArray.length; ++i) {
            Element.ItemElem itemElem = propertiesStructureArray[i].getItem(string2);
            if (itemElem != null) {
                if (!bl || bl2) continue;
                itemElem.setValue(string3);
                itemElem.setComment(string4);
                bl2 = true;
                continue;
            }
            propertiesStructureArray[i].addItem(string2, string3, string4);
            bl2 = true;
        }
    }

    public void removeItem(String string) {
        for (int i = 0; i < this.getEntryCount(); ++i) {
            PropertiesStructure propertiesStructure;
            PropertiesFileEntry propertiesFileEntry = this.getNthEntry(i);
            if (propertiesFileEntry == null || (propertiesStructure = propertiesFileEntry.getHandler().getStructure()) == null) continue;
            propertiesStructure.deleteItem(string);
        }
    }

    public void sort(int n) {
        if (n >= 0) {
            this.comparator.setIndex(n);
        }
        Collections.sort(this.keyList, this.comparator);
        this.propBundleSupport.fireBundleDataChanged();
    }

    public int getSortIndex() {
        return this.comparator.getIndex();
    }

    public boolean getSortOrder() {
        return this.comparator.isAscending();
    }

    PropertiesOpen getOpenSupport() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateEntries() {
        TreeMap<String, PropertiesFileEntry> treeMap = new TreeMap<String, PropertiesFileEntry>(PropertiesDataObject.getSecondaryFilesComparator());
        for (MultiDataObject.Entry entry : this.obj.secondaryEntries()) {
            treeMap.put(entry.getFile().getName(), (PropertiesFileEntry)entry);
        }
        BundleStructure bundleStructure = this;
        synchronized (bundleStructure) {
            int n = treeMap.size();
            this.entries = new PropertiesFileEntry[n + 1];
            this.entries[0] = (PropertiesFileEntry)this.obj.getPrimaryEntry();
            int n2 = 0;
            for (Map.Entry entry : treeMap.entrySet()) {
                this.entries[++n2] = (PropertiesFileEntry)((Object)entry.getValue());
            }
        }
        this.buildKeySet();
    }

    protected synchronized void buildKeySet() {
        ArrayList<String> arrayList = new ArrayList<String>(){

            @Override
            public boolean equals(Object object) {
                if (!(object instanceof ArrayList)) {
                    return false;
                }
                ArrayList arrayList = (ArrayList)object;
                if (this.size() != arrayList.size()) {
                    return false;
                }
                for (int i = 0; i < this.size(); ++i) {
                    if (this.contains(arrayList.get(i)) && arrayList.contains(this.get(i))) continue;
                    return false;
                }
                return true;
            }
        };
        int n = this.getEntryCount();
        for (int i = 0; i < n; ++i) {
            PropertiesStructure propertiesStructure;
            PropertiesFileEntry propertiesFileEntry = this.getNthEntry(i);
            if (propertiesFileEntry == null || (propertiesStructure = propertiesFileEntry.getHandler().getStructure()) == null) continue;
            Iterator<Element.ItemElem> iterator = propertiesStructure.allItems();
            while (iterator.hasNext()) {
                String string;
                Element.ItemElem itemElem = iterator.next();
                if (itemElem == null || (string = itemElem.getKey()) == null || arrayList.contains(string)) continue;
                arrayList.add(itemElem.getKey());
            }
        }
        Collections.sort(arrayList, this.comparator);
        this.keyList = arrayList;
    }

    private PropertiesStructure[] getRelatedStructures(String string) {
        ArrayList<PropertiesFileEntry> arrayList = null;
        for (int i = 0; i < this.getEntryCount(); ++i) {
            PropertiesFileEntry propertiesFileEntry = this.getNthEntry(i);
            if (propertiesFileEntry == null || !string.startsWith(propertiesFileEntry.getFile().getName()) || propertiesFileEntry.getHandler().getStructure() == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<PropertiesFileEntry>(4);
            }
            arrayList.add(propertiesFileEntry);
        }
        if (arrayList == null) {
            return new PropertiesStructure[0];
        }
        Collections.sort(arrayList, new Comparator<PropertiesFileEntry>(){

            @Override
            public int compare(PropertiesFileEntry propertiesFileEntry, PropertiesFileEntry propertiesFileEntry2) {
                return propertiesFileEntry2.getFile().getName().length() - propertiesFileEntry.getFile().getName().length();
            }
        });
        PropertiesStructure[] propertiesStructureArray = new PropertiesStructure[arrayList.size()];
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            propertiesStructureArray[i] = ((PropertiesFileEntry)((Object)arrayList.get(i))).getHandler().getStructure();
        }
        return propertiesStructureArray;
    }

    boolean isReadOnly() {
        boolean bl = false;
        for (int i = 0; i < this.getEntryCount(); ++i) {
            PropertiesFileEntry propertiesFileEntry = this.getNthEntry(i);
            if (propertiesFileEntry == null) continue;
            bl |= propertiesFileEntry.getFile().canWrite();
        }
        return !bl;
    }

    public void addPropertyBundleListener(PropertyBundleListener propertyBundleListener) {
        if (this.propBundleSupport == null) {
            this.propBundleSupport = new PropertyBundleSupport(this);
        }
        this.propBundleSupport.addPropertyBundleListener(propertyBundleListener);
    }

    public void removePropertyBundleListener(PropertyBundleListener propertyBundleListener) {
        this.propBundleSupport.removePropertyBundleListener(propertyBundleListener);
    }

    void notifyItemChanged(PropertiesStructure propertiesStructure, Element.ItemElem itemElem) {
        this.propBundleSupport.fireItemChanged(propertiesStructure.getParent().getEntry().getFile().getName(), itemElem.getKey());
    }

    void notifyOneFileChanged(FileObject fileObject) {
        List<String> list = this.keyList;
        this.buildKeySet();
        if (!((Object)this.keyList).equals(list)) {
            this.propBundleSupport.fireBundleDataChanged();
        } else {
            this.propBundleSupport.fireFileChanged(fileObject.getName());
        }
    }

    void notifyOneFileChanged(StructHandler structHandler) {
        List<String> list = this.keyList;
        this.buildKeySet();
        if (!((Object)this.keyList).equals(list)) {
            this.propBundleSupport.fireBundleDataChanged();
        } else {
            this.propBundleSupport.fireFileChanged(structHandler.getEntry().getFile().getName());
        }
    }

    void notifyOneFileChanged(StructHandler structHandler, Map<String, Element.ItemElem> map, Map<String, Element.ItemElem> map2, Map<String, Element.ItemElem> map3) {
        this.buildKeySet();
        this.propBundleSupport.fireBundleDataChanged();
    }

    private void notifyKeyListNotInitialized() {
        throw new IllegalStateException("Resource Bundles: KeyList not initialized");
    }

    private void notifyEntriesNotInitialized() {
        throw new IllegalStateException("Resource Bundles: Entries not initialized");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeyComparator
    implements Comparator<String> {
        private int index = -1;
        private boolean ascending = false;

        public void setIndex(int n) {
            if (n == -1) {
                throw new IllegalArgumentException();
            }
            if (this.index == n) {
                if (this.ascending) {
                    this.ascending = false;
                } else {
                    n = -1;
                    this.ascending = true;
                }
            } else {
                this.ascending = true;
            }
            this.index = n;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        @Override
        public int compare(String string, String string2) {
            String string3;
            String string4;
            Element.ItemElem itemElem;
            Element.ItemElem itemElem2;
            if (this.index < 0) {
                itemElem2 = BundleStructure.this.getItem(0, string);
                itemElem = BundleStructure.this.getItem(0, string2);
                if (itemElem2 != null && itemElem != null) {
                    int n = itemElem2.getBounds().getBegin().getOffset();
                    int n2 = itemElem.getBounds().getBegin().getOffset();
                    return n - n2;
                }
                if (itemElem2 != null) {
                    return -1;
                }
                if (itemElem != null) {
                    return 1;
                }
                string4 = string;
                string3 = string2;
            }
            if (this.index == 0) {
                string4 = string;
                string3 = string2;
            } else {
                itemElem2 = BundleStructure.this.getItem(this.index - 1, string);
                itemElem = BundleStructure.this.getItem(this.index - 1, string2);
                if (itemElem2 == null) {
                    if (itemElem == null) {
                        return 0;
                    }
                    return this.ascending ? 1 : -1;
                }
                if (itemElem == null) {
                    return this.ascending ? -1 : 1;
                }
                string4 = itemElem2.getValue();
                string3 = itemElem.getValue();
            }
            if (string4 == null) {
                if (string3 == null) {
                    return 0;
                }
                return this.ascending ? 1 : -1;
            }
            if (string3 == null) {
                return this.ascending ? -1 : 1;
            }
            int n = string4.compareToIgnoreCase(string3);
            return this.ascending ? n : -n;
        }
    }
}

