/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.editor.codetemplates;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Future;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.editor.completion.GsfCompletionProvider;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.util.Exceptions;

public class GsfCodeTemplateFilter
extends UserTask
implements CodeTemplateFilter {
    private int startOffset;
    private int endOffset;
    private Set<String> templates;
    private boolean cancelled;

    private GsfCodeTemplateFilter(JTextComponent jTextComponent, int n) {
        this.startOffset = n;
        this.endOffset = jTextComponent.getSelectionStart() == n ? jTextComponent.getSelectionEnd() : -1;
        Source source = Source.create((Document)jTextComponent.getDocument());
        if (source != null) {
            try {
                Future future = ParserManager.parseWhenScanFinished(Collections.singleton(source), (UserTask)this);
                if (!future.isDone()) {
                    future.cancel(true);
                }
            }
            catch (ParseException parseException) {
                Exceptions.printStackTrace((Throwable)parseException);
            }
        }
    }

    public boolean accept(CodeTemplate codeTemplate) {
        if (this.templates != null && codeTemplate != null && codeTemplate.getParametrizedText().indexOf("${selection") != -1) {
            return this.templates.contains(codeTemplate.getAbbreviation()) || codeTemplate.getParametrizedText().indexOf("allowSurround") != -1;
        }
        return true;
    }

    public synchronized void cancel() {
        this.cancelled = true;
    }

    private synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public void run(ResultIterator resultIterator) throws IOException, ParseException {
        if (this.isCancelled()) {
            return;
        }
        Parser.Result result = resultIterator.getParserResult(this.startOffset);
        if (!(result instanceof ParserResult)) {
            return;
        }
        ParserResult parserResult = (ParserResult)result;
        Snapshot snapshot = parserResult.getSnapshot();
        CodeCompletionHandler codeCompletionHandler = GsfCompletionProvider.getCompletable(snapshot.getSource().getDocument(true), this.startOffset);
        if (codeCompletionHandler != null && !this.isCancelled()) {
            this.templates = codeCompletionHandler.getApplicableTemplates(parserResult, this.startOffset, this.endOffset);
        }
    }

    public static final class Factory
    implements CodeTemplateFilter.Factory {
        public CodeTemplateFilter createFilter(JTextComponent jTextComponent, int n) {
            return new GsfCodeTemplateFilter(jTextComponent, n);
        }
    }
}

