/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.editor.completion;

import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.core.UiUtils;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;

public class GsfCompletionDoc
implements CompletionDocumentation {
    private String content = null;
    private URL docURL = null;
    private AbstractAction goToSource = null;
    private ElementHandle elementHandle;
    private Language language;
    private ParserResult controller;

    private GsfCompletionDoc(final ParserResult parserResult, final ElementHandle elementHandle, URL uRL) {
        Object object;
        this.controller = parserResult;
        this.language = LanguageRegistry.getInstance().getLanguageByMimeType(parserResult.getSnapshot().getMimeType());
        if (elementHandle != null && elementHandle.getMimeType() != null && (object = LanguageRegistry.getInstance().getLanguageByMimeType(elementHandle.getMimeType())) != null && ((Language)object).getParser(Collections.singleton(parserResult.getSnapshot())) != null) {
            this.language = object;
        }
        object = this.language.getCompletionProvider();
        this.elementHandle = elementHandle;
        if (elementHandle != null) {
            this.goToSource = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Completion.get().hideAll();
                    UiUtils.open(parserResult.getSnapshot().getSource(), elementHandle);
                }
            };
            this.docURL = uRL != null ? uRL : null;
        }
        if (object != null) {
            this.content = object.document(parserResult, elementHandle);
        }
        if (this.content == null) {
            Completion.get().hideDocumentation();
        }
    }

    public static final GsfCompletionDoc create(ParserResult parserResult, ElementHandle elementHandle) {
        return new GsfCompletionDoc(parserResult, elementHandle, null);
    }

    public String getText() {
        return this.content;
    }

    public URL getURL() {
        return this.docURL;
    }

    public CompletionDocumentation resolveLink(String string) {
        ElementHandle elementHandle;
        if (string.startsWith("www.")) {
            string = "http://" + string;
        }
        if (string.matches("[a-z]+://.*")) {
            try {
                URL uRL = new URL(string);
                HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
                return null;
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
        if ((elementHandle = this.language.getCompletionProvider().resolveLink(string, this.elementHandle)) != null) {
            URL uRL = null;
            if (elementHandle instanceof ElementHandle.UrlHandle) {
                String string2 = ((ElementHandle.UrlHandle)elementHandle).getUrl();
                try {
                    uRL = new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    Logger.getLogger("global").log(Level.INFO, null, malformedURLException);
                }
            }
            return new GsfCompletionDoc(this.controller, elementHandle, uRL);
        }
        return null;
    }

    public Action getGotoSourceAction() {
        return this.goToSource;
    }
}

