/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.spi;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

public class DefaultDataLoadersBridge
extends DataLoadersBridge {
    private static Logger log = Logger.getLogger(DataLoadersBridge.class.getName());

    private DataObject getDataObject(Document document) {
        Object object = document.getProperty("stream");
        if (object instanceof DataObject) {
            return (DataObject)object;
        }
        if (object != null) {
            log.warning("Unable to return DataObject for Document " + document + ". StreamDescriptionProperty points to non-DataLoader instace: " + object);
        }
        return null;
    }

    public FileObject getFileObject(Document document) {
        Object object = document.getProperty("stream");
        if (object instanceof DataObject) {
            return ((DataObject)object).getPrimaryFile();
        }
        if (object instanceof FileObject) {
            return (FileObject)object;
        }
        if (object != null) {
            log.warning("Unable to return FileObject for Document " + document + ". StreamDescriptionProperty points to non-DataLoader, non-FileObject instace: " + object);
        }
        return null;
    }

    public StyledDocument getDocument(FileObject fileObject) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie == null) {
                return null;
            }
            return editorCookie.getDocument();
        }
        catch (IOException iOException) {
            Logger.global.log(Level.INFO, "SemanticHighlighter: Cannot find DataObject for file: " + FileUtil.getFileDisplayName((FileObject)fileObject), iOException);
            return null;
        }
    }

    public JEditorPane[] getOpenedPanes(FileObject fileObject) {
        DataObject dataObject;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return new JEditorPane[0];
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return new JEditorPane[0];
        }
        return editorCookie.getOpenedPanes();
    }

    public Object createInstance(FileObject fileObject) {
        assert (fileObject.getExt().equals("instance"));
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
            return instanceCookie.instanceCreate();
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)classNotFoundException);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        return null;
    }

    public FileObject getPrimaryFile(FileObject fileObject) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject != null) {
                return dataObject.getPrimaryFile();
            }
            return null;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            return null;
        }
    }

    public String getLine(Document document, int n) {
        DataObject dataObject = (DataObject)document.getProperty("stream");
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        Line line = lineCookie.getLineSet().getCurrent(n);
        return line.getText();
    }

    public Object getCookie(FileObject fileObject, Class clazz) throws IOException {
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        return dataObject.getCookie(clazz);
    }

    public Object getSafeCookie(FileObject fileObject, Class clazz) {
        try {
            return this.getCookie(fileObject, clazz);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public EditorCookie isModified(FileObject fileObject) {
        DataObject.Registry registry = DataObject.getRegistry();
        Set set = registry.getModifiedSet();
        for (DataObject dataObject : set) {
            if (!fileObject.equals(dataObject.getPrimaryFile())) continue;
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            return editorCookie;
        }
        return null;
    }

    public PropertyChangeListener getDataObjectListener(FileObject fileObject, FileChangeListener fileChangeListener) throws IOException {
        return new DataObjectListener(fileObject, fileChangeListener);
    }

    public Node getNodeDelegate(JTextComponent jTextComponent) {
        DataObject dataObject = this.getDataObject(jTextComponent.getDocument());
        return dataObject != null ? dataObject.getNodeDelegate() : null;
    }

    private static final class DataObjectListener
    implements PropertyChangeListener {
        private DataObject dobj;
        private final FileObject fobj;
        private PropertyChangeListener wlistener;
        private final FileChangeListener flisten;

        public DataObjectListener(FileObject fileObject, FileChangeListener fileChangeListener) throws DataObjectNotFoundException {
            this.fobj = fileObject;
            this.flisten = fileChangeListener;
            this.dobj = DataObject.find((FileObject)fileObject);
            this.wlistener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.dobj);
            this.dobj.addPropertyChangeListener(this.wlistener);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DataObject dataObject = (DataObject)propertyChangeEvent.getSource();
            if (dataObject != this.dobj) {
                return;
            }
            if ("valid".equals(propertyChangeEvent.getPropertyName())) {
                this.handleInvalidDataObject(dataObject);
            } else if (propertyChangeEvent.getPropertyName() == null && !this.dobj.isValid()) {
                this.handleInvalidDataObject(dataObject);
            }
        }

        private void handleInvalidDataObject(DataObject dataObject) {
            dataObject.removePropertyChangeListener(this.wlistener);
            if (this.fobj.isValid()) {
                try {
                    this.dobj = DataObject.find((FileObject)this.fobj);
                    this.dobj.addPropertyChangeListener(this.wlistener);
                    this.flisten.fileChanged(new FileEvent(this.fobj));
                }
                catch (IOException iOException) {
                    Logger.getLogger(DataObjectListener.class.getName()).log(Level.SEVERE, iOException.getMessage(), iOException);
                }
            }
        }
    }
}

