/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates.textsync;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.lib.editor.codetemplates.textsync.TextRegion;
import org.netbeans.lib.editor.codetemplates.textsync.TextRegionManager;
import org.netbeans.lib.editor.codetemplates.textsync.TextSyncGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TextSync {
    private static int EDITABLE_FLAG = 1;
    private static int CARET_MARKER_FLAG = 2;
    private TextSyncGroup<?> textSyncGroup;
    private List<TextRegion<?>> regions;
    private int masterRegionIndex;
    private int flags;

    public TextSync(TextRegion<?> ... textRegionArray) {
        this.initRegions(textRegionArray.length);
        for (TextRegion<?> textRegion : textRegionArray) {
            this.addRegion(textRegion);
        }
    }

    public TextSync() {
        this.initRegions(4);
    }

    private void initRegions(int n) {
        this.regions = new ArrayList(n);
    }

    public List<TextRegion<?>> regions() {
        return Collections.unmodifiableList(this.regions);
    }

    public <I> TextRegion<I> region(int n) {
        TextRegion<?> textRegion = this.regions.get(n);
        return textRegion;
    }

    public <I> TextRegion<I> masterRegion() {
        if (this.masterRegionIndex < 0 || this.masterRegionIndex >= this.regions.size()) {
            return null;
        }
        TextRegion<?> textRegion = this.regions.get(this.masterRegionIndex);
        return textRegion;
    }

    public <I> TextRegion<I> validMasterRegion() {
        TextRegion<I> textRegion = this.masterRegion();
        if (textRegion == null) {
            throw new IllegalStateException("masterRegion expected to be non-null");
        }
        return textRegion;
    }

    public int masterRegionIndex() {
        return this.masterRegionIndex;
    }

    public void setMasterRegionIndex(int n) {
        this.masterRegionIndex = n;
    }

    public void syncByMaster() {
        this.validTextRegionManager().syncByMaster(this);
    }

    public void setText(String string) {
        this.validTextRegionManager().setText(this, string);
    }

    public boolean isEditable() {
        return (this.flags & EDITABLE_FLAG) != 0;
    }

    public void setEditable(boolean bl) {
        this.flags = bl ? (this.flags |= EDITABLE_FLAG) : (this.flags &= ~EDITABLE_FLAG);
    }

    public boolean isCaretMarker() {
        return (this.flags & CARET_MARKER_FLAG) != 0;
    }

    public void setCaretMarker(boolean bl) {
        this.flags = bl ? (this.flags |= CARET_MARKER_FLAG) : (this.flags &= ~CARET_MARKER_FLAG);
    }

    public void addRegion(TextRegion<?> textRegion) {
        if (textRegion == null) {
            throw new IllegalArgumentException("region cannot be null");
        }
        if (textRegion.textSync() != null) {
            throw new IllegalArgumentException("region " + textRegion + " already assigned to textSync=" + textRegion.textSync());
        }
        this.regions.add(textRegion);
        textRegion.setTextSync(this);
    }

    public void removeRegion(TextRegion textRegion) {
        int n = this.regions.indexOf(textRegion);
        if (n == -1) {
            throw new IllegalArgumentException("region " + textRegion + " not part of textSync " + this);
        }
        this.regions.remove(n);
        textRegion.setTextSync(null);
        if (n == this.masterRegionIndex) {
            n = -1;
        } else if (n < this.masterRegionIndex) {
            --this.masterRegionIndex;
        }
    }

    List<TextRegion<?>> regionsModifiable() {
        return this.regions;
    }

    public <T> TextSyncGroup<T> group() {
        TextSyncGroup<?> textSyncGroup = this.textSyncGroup;
        return textSyncGroup;
    }

    void setGroup(TextSyncGroup<?> textSyncGroup) {
        this.textSyncGroup = textSyncGroup;
    }

    TextRegionManager textRegionManager() {
        return this.textSyncGroup != null ? this.textSyncGroup.textRegionManager() : null;
    }

    private TextRegionManager validTextRegionManager() {
        TextRegionManager textRegionManager = this.textRegionManager();
        if (textRegionManager == null) {
            throw new IllegalStateException("Only possible for textSync connected to a TextRegionManager");
        }
        return textRegionManager;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.regions.size() * 8 + 2);
        TextRegion textRegion = this.masterRegion();
        for (TextRegion<?> textRegion2 : this.regions) {
            stringBuilder.append("    ");
            if (textRegion2 == textRegion) {
                stringBuilder.append("M:");
            }
            stringBuilder.append(textRegion2).append('\n');
        }
        return stringBuilder.toString();
    }
}

