/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.api.customization.model.BindingCustomization;
import org.netbeans.modules.websvc.api.customization.model.BindingOperationCustomization;
import org.netbeans.modules.websvc.api.customization.model.CustomizationComponentFactory;
import org.netbeans.modules.websvc.api.customization.model.DefinitionsCustomization;
import org.netbeans.modules.websvc.api.customization.model.EnableMIMEContent;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class BindingOperationPanel
extends SaveableSectionInnerPanel {
    private BindingOperation bindingOperation;
    private WSDLModel model;
    private boolean wsdlDirty;
    private ModelChangeListener modelListener;
    private ModelChangeListener primaryModelListener;
    private Definitions primaryDefinitions;
    private WSDLModel primaryModel;
    private JLabel bindingLabel;
    private JLabel bindingName;
    private ButtonGroup emcButtonGroup;
    private JCheckBox enableMIMEContentCB;

    public BindingOperationPanel(SectionView sectionView, BindingOperation bindingOperation, Definitions definitions) {
        super(sectionView);
        this.bindingOperation = bindingOperation;
        this.primaryDefinitions = definitions;
        this.model = this.bindingOperation.getModel();
        this.primaryModel = this.primaryDefinitions.getModel();
        this.initComponents();
        this.bindingName.setText(this.getParentOfBindingOperation(bindingOperation));
        this.sync();
        this.addModifier(this.enableMIMEContentCB);
        this.modelListener = new ModelChangeListener();
        PropertyChangeListener propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this.modelListener, (Object)this.model);
        this.model.addPropertyChangeListener(propertyChangeListener);
        if (this.primaryModel != this.model) {
            this.primaryModelListener = new ModelChangeListener();
            PropertyChangeListener propertyChangeListener2 = WeakListeners.propertyChange((PropertyChangeListener)this.primaryModelListener, (Object)this.primaryModel);
            this.primaryModel.addPropertyChangeListener(propertyChangeListener2);
        }
    }

    private String getParentOfBindingOperation(BindingOperation bindingOperation) {
        Binding binding = (Binding)bindingOperation.getParent();
        return binding.getName();
    }

    private void sync() {
        List list = this.bindingOperation.getExtensibilityElements(BindingOperationCustomization.class);
        if (list.size() == 1) {
            BindingOperationCustomization bindingOperationCustomization = (BindingOperationCustomization)list.get(0);
            EnableMIMEContent enableMIMEContent = bindingOperationCustomization.getEnableMIMEContent();
            if (enableMIMEContent != null) {
                this.setEnableMIMEContent(enableMIMEContent.isEnabled());
            } else {
                this.setEnableMIMEContent(this.getMIMEContentOfParent());
            }
        } else {
            this.setEnableMIMEContent(this.getMIMEContentOfParent());
        }
    }

    private boolean getMIMEContentOfParent() {
        BindingCustomization bindingCustomization;
        EnableMIMEContent enableMIMEContent;
        boolean bl = false;
        Binding binding = (Binding)this.bindingOperation.getParent();
        List list = binding.getExtensibilityElements(BindingCustomization.class);
        bl = list.size() > 0 ? ((enableMIMEContent = (bindingCustomization = (BindingCustomization)list.get(0)).getEnableMIMEContent()) != null ? enableMIMEContent.isEnabled() : this.getMIMEContentFromDefinitions(this.primaryDefinitions)) : this.getMIMEContentFromDefinitions(this.primaryDefinitions);
        return bl;
    }

    private boolean getMIMEContentFromDefinitions(Definitions definitions) {
        DefinitionsCustomization definitionsCustomization;
        EnableMIMEContent enableMIMEContent;
        List list = definitions.getExtensibilityElements(DefinitionsCustomization.class);
        if (list.size() > 0 && (enableMIMEContent = (definitionsCustomization = (DefinitionsCustomization)list.get(0)).getEnableMIMEContent()) != null) {
            return enableMIMEContent.isEnabled();
        }
        return false;
    }

    public void setEnableMIMEContent(boolean bl) {
        this.enableMIMEContentCB.setSelected(bl);
    }

    public Boolean getEnableMIMEContent() {
        return this.enableMIMEContentCB.isSelected();
    }

    public JComponent getErrorComponent(String string) {
        return new JButton("error");
    }

    public void linkButtonPressed(Object object, String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(JComponent jComponent, Object object) {
        List list = this.bindingOperation.getExtensibilityElements(BindingOperationCustomization.class);
        CustomizationComponentFactory customizationComponentFactory = CustomizationComponentFactory.getDefault();
        if (jComponent == this.enableMIMEContentCB) {
            if (list.size() > 0) {
                BindingOperationCustomization bindingOperationCustomization = (BindingOperationCustomization)list.get(0);
                EnableMIMEContent enableMIMEContent = bindingOperationCustomization.getEnableMIMEContent();
                if (enableMIMEContent == null) {
                    try {
                        this.model.startTransaction();
                        enableMIMEContent = customizationComponentFactory.createEnableMIMEContent(this.model);
                        enableMIMEContent.setEnabled(this.getEnableMIMEContent().booleanValue());
                        bindingOperationCustomization.setEnableMIMEContent(enableMIMEContent);
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                } else {
                    try {
                        this.model.startTransaction();
                        enableMIMEContent.setEnabled(this.getEnableMIMEContent().booleanValue());
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else {
                BindingOperationCustomization bindingOperationCustomization = customizationComponentFactory.createBindingOperationCustomization(this.model);
                EnableMIMEContent enableMIMEContent = customizationComponentFactory.createEnableMIMEContent(this.model);
                try {
                    this.model.startTransaction();
                    enableMIMEContent.setEnabled(this.getEnableMIMEContent().booleanValue());
                    bindingOperationCustomization.setEnableMIMEContent(enableMIMEContent);
                    this.bindingOperation.addExtensibilityElement((ExtensibilityElement)bindingOperationCustomization);
                    this.wsdlDirty = true;
                }
                finally {
                    this.model.endTransaction();
                }
            }
        }
    }

    public boolean wsdlIsDirty() {
        return this.wsdlDirty;
    }

    public void save() {
        if (this.wsdlDirty) {
            this.setModelDirty(this.model);
        }
    }

    private void initComponents() {
        this.emcButtonGroup = new ButtonGroup();
        this.enableMIMEContentCB = new JCheckBox();
        this.bindingLabel = new JLabel();
        this.bindingName = new JLabel();
        this.enableMIMEContentCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_ENABLE_MIME_CONTENT").charAt(0));
        this.enableMIMEContentCB.setText(NbBundle.getBundle(BindingOperationPanel.class).getString("LBL_ENABLE_MIME_CONTENT"));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle");
        this.enableMIMEContentCB.setToolTipText(resourceBundle.getString("TOOLTIP_ENABLE_MIME"));
        this.enableMIMEContentCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableMIMEContentCB.setContentAreaFilled(false);
        this.enableMIMEContentCB.setMargin(new Insets(0, 0, 0, 0));
        this.bindingLabel.setText(resourceBundle.getString("LBL_ENCLOSING_BINDING"));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(21, 21, 21).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.bindingLabel).add(22, 22, 22).add((Component)this.bindingName, -2, 139, -2)).add((Component)this.enableMIMEContentCB)).addContainerGap(201, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(13, 13, 13).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.bindingLabel).add((Component)this.bindingName)).addPreferredGap(0, 21, Short.MAX_VALUE).add((Component)this.enableMIMEContentCB).addContainerGap()));
        this.enableMIMEContentCB.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_ENABLE_MIME_CONTENT"));
        this.enableMIMEContentCB.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_ENABLE_MIME_CONTENT"));
        this.bindingLabel.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_ENCLOSING_BINDING"));
    }

    class ModelChangeListener
    implements PropertyChangeListener {
        ModelChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            EnableMIMEContent enableMIMEContent;
            WSDLComponent wSDLComponent;
            Object object = propertyChangeEvent.getSource();
            if (object instanceof EnableMIMEContent && ((wSDLComponent = (WSDLComponent)(enableMIMEContent = (EnableMIMEContent)object).getParent()) instanceof DefinitionsCustomization || wSDLComponent instanceof BindingCustomization)) {
                BindingOperationPanel.this.sync();
            }
        }
    }
}

