/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.form;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.form.I18nService;
import org.netbeans.modules.form.I18nValue;
import org.netbeans.modules.i18n.FileSelector;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.ResourceHolder;
import org.netbeans.modules.i18n.Util;
import org.netbeans.modules.i18n.form.FormI18nInteger;
import org.netbeans.modules.i18n.form.FormI18nMnemonic;
import org.netbeans.modules.i18n.form.FormI18nString;
import org.netbeans.modules.i18n.form.FormI18nStringEditor;
import org.netbeans.modules.i18n.java.JavaResourceHolder;
import org.netbeans.modules.properties.LocalePanel;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I18nServiceImpl
implements I18nService {
    private Map changesMap = new HashMap();

    public I18nValue create(String string, String string2, DataObject dataObject) {
        FormI18nString formI18nString = new FormI18nString(dataObject);
        formI18nString.setKey(string);
        formI18nString.setValue(string2);
        return formI18nString;
    }

    public I18nValue copy(I18nValue i18nValue) {
        FormI18nString formI18nString = (FormI18nString)i18nValue;
        FormI18nString formI18nString2 = new FormI18nString(formI18nString);
        formI18nString2.getSupport().getResourceHolder().setResource(null);
        if (formI18nString.allData == null && formI18nString.getKey() != null) {
            JavaResourceHolder javaResourceHolder = (JavaResourceHolder)formI18nString.getSupport().getResourceHolder();
            formI18nString2.allData = javaResourceHolder.getAllData(formI18nString.getKey());
        } else {
            formI18nString2.allData = formI18nString.allData;
        }
        return formI18nString2;
    }

    public I18nValue changeKey(I18nValue i18nValue, String string) {
        FormI18nString formI18nString;
        FormI18nString formI18nString2 = (FormI18nString)i18nValue;
        if (formI18nString2.getKey() == "#auto") {
            formI18nString = formI18nString2;
        } else {
            formI18nString = new FormI18nString(formI18nString2);
            formI18nString.allData = formI18nString2.allData;
        }
        formI18nString.setKey(string);
        return formI18nString;
    }

    public I18nValue changeValue(I18nValue i18nValue, String string) {
        FormI18nString formI18nString = new FormI18nString((FormI18nString)i18nValue);
        formI18nString.setValue(string);
        return formI18nString;
    }

    public I18nValue switchLocale(I18nValue i18nValue, String string) {
        if (i18nValue == null || i18nValue.getKey() == null) {
            return i18nValue;
        }
        FormI18nString formI18nString = i18nValue instanceof FormI18nInteger ? new FormI18nInteger((FormI18nInteger)i18nValue) : (i18nValue instanceof FormI18nMnemonic ? new FormI18nMnemonic((FormI18nMnemonic)i18nValue) : new FormI18nString((FormI18nString)i18nValue));
        JavaResourceHolder javaResourceHolder = (JavaResourceHolder)formI18nString.getSupport().getResourceHolder();
        javaResourceHolder.setLocalization(string);
        formI18nString.setValue(javaResourceHolder.getValueForKey(formI18nString.getKey()));
        formI18nString.setComment(javaResourceHolder.getCommentForKey(formI18nString.getKey()));
        return formI18nString;
    }

    public void update(I18nValue i18nValue, I18nValue i18nValue2, DataObject dataObject, String string, String string2, boolean bl) throws IOException {
        DataObject dataObject2;
        Object object;
        ResourceHolder resourceHolder;
        FormI18nString formI18nString = (FormI18nString)i18nValue;
        FormI18nString formI18nString2 = (FormI18nString)i18nValue2;
        if (formI18nString != null) {
            String string3;
            resourceHolder = formI18nString.getSupport().getResourceHolder();
            object = resourceHolder.getResource();
            dataObject2 = null;
            if (formI18nString2 != null && (dataObject2 = (string3 = formI18nString2.getSupport().getResourceHolder()).getResource()) == null) {
                string3.setResource(object);
                dataObject2 = object;
            }
            string3 = formI18nString.getKey();
            if (bl && string3 != null) {
                JavaResourceHolder javaResourceHolder = (JavaResourceHolder)resourceHolder;
                Object object2 = javaResourceHolder.getAllData(string3);
                this.registerChange(dataObject, (DataObject)object, string3, object2);
                if (formI18nString2 == null || formI18nString2.getKey() == null || !formI18nString2.getKey().equals(string3) || dataObject2 != object) {
                    formI18nString.allData = object2;
                    javaResourceHolder.removeProperty((Object)string3);
                    if (formI18nString2 != null) {
                        formI18nString2.allData = formI18nString.allData;
                    }
                } else if (string2 != null && !string2.equals("")) {
                    formI18nString.allData = object2;
                }
                if (formI18nString2 == null && object == I18nServiceImpl.getPropertiesDataObject(dataObject.getPrimaryFile(), string)) {
                    resourceHolder.setResource(null);
                }
            }
        }
        if (formI18nString2 != null && formI18nString2.getKey() != null) {
            resourceHolder = (JavaResourceHolder)formI18nString2.getSupport().getResourceHolder();
            object = formI18nString2.getKey();
            if (resourceHolder.getResource() == null) {
                dataObject2 = I18nServiceImpl.getPropertiesDataObject(dataObject.getPrimaryFile(), string);
                if (dataObject2 == null) {
                    dataObject2 = I18nServiceImpl.createPropertiesDataObject(dataObject.getPrimaryFile(), string);
                    if (dataObject2 == null) {
                        return;
                    }
                } else if (formI18nString == null && formI18nString2.getValue() == null) {
                    resourceHolder.setResource(dataObject2);
                    formI18nString2.setValue(resourceHolder.getValueForKey((String)object));
                    formI18nString2.setComment(resourceHolder.getCommentForKey((String)object));
                    return;
                }
                resourceHolder.setResource(dataObject2);
                object = resourceHolder.findFreeKey((String)object);
                formI18nString2.setKey((String)object);
            }
            resourceHolder.setLocalization(string2);
            if (!I18nServiceImpl.isValueUpToDate(resourceHolder, (I18nString)formI18nString2)) {
                if (formI18nString2.allData != null) {
                    resourceHolder.setAllData((String)object, formI18nString2.allData);
                    formI18nString2.allData = null;
                    if (formI18nString == null) {
                        formI18nString2.setValue(resourceHolder.getValueForKey((String)object));
                        formI18nString2.setComment(resourceHolder.getCommentForKey((String)object));
                    } else if (formI18nString2.getValue() != null) {
                        resourceHolder.addProperty(object, formI18nString2.getValue(), formI18nString2.getComment(), true);
                    }
                } else {
                    resourceHolder.addProperty(object, formI18nString2.getValue(), formI18nString2.getComment(), true);
                }
                this.registerChange(dataObject, resourceHolder.getResource(), formI18nString2.getKey(), null);
            }
        }
    }

    private static boolean isValueUpToDate(ResourceHolder resourceHolder, I18nString i18nString) {
        String string = resourceHolder.getValueForKey(i18nString.getKey());
        String string2 = resourceHolder.getCommentForKey(i18nString.getKey());
        if ("".equals(string2)) {
            string2 = null;
        }
        String string3 = i18nString.getValue();
        String string4 = i18nString.getComment();
        if ("".equals(string4)) {
            string4 = null;
        }
        return (string == string3 || string != null && string.equals(string3)) && (string2 == string4 || string2 != null && string2.equals(string4));
    }

    public PropertyEditor getPropertyEditor(Class clazz, PropertyEditor propertyEditor) {
        return propertyEditor instanceof FormI18nStringEditor ? propertyEditor : new FormI18nStringEditor();
    }

    private static boolean isPlainStringEditor(PropertyEditor propertyEditor) {
        return propertyEditor != null && propertyEditor.getClass().getName().endsWith(".StringEditor");
    }

    public Component getBundleSelectionComponent(final PropertyEditor propertyEditor, FileObject fileObject) {
        try {
            final FileSelector fileSelector = new FileSelector(fileObject, JavaResourceHolder.getTemplate());
            return fileSelector.getDialog(NbBundle.getMessage(I18nServiceImpl.class, (String)"CTL_SELECT_BUNDLE_TITLE"), new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClassPath classPath;
                    DataObject dataObject = fileSelector.getSelectedDataObject();
                    if (dataObject != null && (classPath = ClassPath.getClassPath((FileObject)dataObject.getPrimaryFile(), (String)"classpath/source")) != null) {
                        String string = classPath.getResourceName(dataObject.getPrimaryFile(), '/', false);
                        propertyEditor.setValue(string);
                    }
                }
            });
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            return null;
        }
    }

    public String[][] getAvailableLocales(FileObject fileObject, String string) {
        int n;
        String[] stringArray;
        PropertiesDataObject propertiesDataObject = null;
        try {
            propertiesDataObject = I18nServiceImpl.getPropertiesDataObject(fileObject, string);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        if (propertiesDataObject == null) {
            return null;
        }
        ArrayList<MultiDataObject.Entry> arrayList = new ArrayList<MultiDataObject.Entry>();
        arrayList.add(propertiesDataObject.getPrimaryEntry());
        arrayList.addAll(propertiesDataObject.secondaryEntries());
        try {
            stringArray = propertiesDataObject.getName() + "_";
            FileObject[] objectArray = propertiesDataObject.getPrimaryFile().getParent().getChildren();
            n = objectArray.length;
            for (int entry = 0; entry < n; ++entry) {
                DataObject dataObject;
                FileObject fileObject2 = objectArray[entry];
                String string2 = fileObject2.getNameExt();
                if (!string2.endsWith(".properties") || !string2.startsWith((String)stringArray) || !((dataObject = DataObject.find((FileObject)fileObject2)) instanceof PropertiesDataObject)) continue;
                arrayList.add(((MultiDataObject)dataObject).getPrimaryEntry());
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                MultiDataObject.Entry entry = (MultiDataObject.Entry)object;
                MultiDataObject.Entry entry2 = (MultiDataObject.Entry)object2;
                return entry.getFile().getName().compareTo(entry2.getFile().getName());
            }
        });
        stringArray = new String[arrayList.size()];
        String[] stringArray2 = new String[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            MultiDataObject.Entry entry = (MultiDataObject.Entry)arrayList.get(n);
            stringArray[n] = org.netbeans.modules.properties.Util.getLocaleSuffix((MultiDataObject.Entry)entry);
            stringArray2[n] = org.netbeans.modules.properties.Util.getLocaleLabel((MultiDataObject.Entry)entry);
        }
        return new String[][]{stringArray, stringArray2};
    }

    public Component getCreateLocaleComponent(final PropertyEditor propertyEditor, FileObject fileObject, String string) {
        PropertiesDataObject propertiesDataObject;
        try {
            propertiesDataObject = I18nServiceImpl.getPropertiesDataObject(fileObject, string);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
            return null;
        }
        final Dialog[] dialogArray = new Dialog[1];
        final LocalePanel localePanel = new LocalePanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)localePanel, NbBundle.getBundle(PropertiesDataObject.class).getString("CTL_NewLocaleTitle"), true, 2, DialogDescriptor.OK_OPTION, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == DialogDescriptor.OK_OPTION) {
                    String string = localePanel.getLocale().toString();
                    org.netbeans.modules.properties.Util.createLocaleFile((PropertiesDataObject)propertiesDataObject, (String)string, (boolean)false);
                    propertyEditor.setValue("_" + string);
                }
                dialogArray[0].setVisible(false);
                dialogArray[0].dispose();
            }
        });
        dialogArray[0] = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        return dialogArray[0];
    }

    public void autoSave(DataObject dataObject) {
        Map map = (Map)this.changesMap.remove(dataObject);
        if (map != null) {
            for (DataObject dataObject2 : map.keySet()) {
                SaveCookie saveCookie = (SaveCookie)dataObject2.getCookie(SaveCookie.class);
                if (saveCookie == null) continue;
                try {
                    saveCookie.save();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
        }
    }

    public void close(DataObject dataObject) {
        Map map = (Map)this.changesMap.remove(dataObject);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                PropertiesDataObject propertiesDataObject = (PropertiesDataObject)entry.getKey();
                ChangeInfo changeInfo = (ChangeInfo)entry.getValue();
                JavaResourceHolder javaResourceHolder = new JavaResourceHolder();
                javaResourceHolder.setResource((DataObject)propertiesDataObject);
                for (Map.Entry entry2 : changeInfo.changed.entrySet()) {
                    String string = (String)entry2.getKey();
                    Object v = entry2.getValue();
                    javaResourceHolder.setAllData(string, v);
                }
                for (String string : changeInfo.added) {
                    javaResourceHolder.removeProperty((Object)string);
                }
            }
        }
    }

    public boolean isDefaultInternationalizableProject(FileObject fileObject) {
        return I18nServiceImpl.isNbBundleAvailable(fileObject);
    }

    static boolean isNbBundleAvailable(FileObject fileObject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
        if (classPath != null && classPath.findResource("org/openide/util/NbBundle.class") != null) {
            return true;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        return project != null && project.getClass().getName().startsWith("org.netbeans.modules.apisupport.") && project.getClass().getName().endsWith("Project");
    }

    public List<URL> getResourceFiles(FileObject fileObject, String string) {
        PropertiesDataObject propertiesDataObject = null;
        try {
            propertiesDataObject = I18nServiceImpl.getPropertiesDataObject(fileObject, string);
            if (propertiesDataObject != null) {
                ArrayList<URL> arrayList = new ArrayList<URL>();
                arrayList.add(propertiesDataObject.getPrimaryEntry().getFile().getURL());
                for (MultiDataObject.Entry entry : propertiesDataObject.secondaryEntries()) {
                    arrayList.add(entry.getFile().getURL());
                }
                return arrayList;
            }
            FileObject fileObject2 = I18nServiceImpl.getResourcesRoot(fileObject);
            if (fileObject2 != null) {
                return Collections.singletonList(new File(FileUtil.toFile((FileObject)fileObject2).getPath() + File.separator + string + ".properties").toURI().toURL());
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(I18nServiceImpl.class.getName()).log(Level.INFO, null, iOException);
        }
        return Collections.emptyList();
    }

    private static PropertiesDataObject getPropertiesDataObject(FileObject fileObject, String string) throws DataObjectNotFoundException {
        DataObject dataObject;
        FileObject fileObject2;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (!string.toLowerCase().endsWith(".properties")) {
            string = string + ".properties";
        }
        if ((fileObject2 = Util.getResource((FileObject)fileObject, (String)string)) != null && (dataObject = DataObject.find((FileObject)fileObject2)) instanceof PropertiesDataObject) {
            return (PropertiesDataObject)dataObject;
        }
        return null;
    }

    private static DataObject createPropertiesDataObject(FileObject fileObject, String string) throws IOException {
        if (string == null) {
            return null;
        }
        FileObject fileObject2 = I18nServiceImpl.getResourcesRoot(fileObject);
        return org.netbeans.modules.properties.Util.createPropertiesDataObject((FileObject)fileObject2, (String)string);
    }

    private static FileObject getResourcesRoot(FileObject fileObject) {
        Sources sources;
        SourceGroup[] sourceGroupArray;
        FileObject fileObject2 = null;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null && (sourceGroupArray = (sources = ProjectUtils.getSources((Project)project)).getSourceGroups("resources")) != null && sourceGroupArray.length > 0) {
            fileObject2 = sourceGroupArray[0].getRootFolder();
        }
        if (fileObject2 == null) {
            fileObject2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").getRoots()[0];
        }
        return fileObject2;
    }

    private void registerChange(DataObject dataObject, DataObject dataObject2, String string, Object object) {
        ChangeInfo changeInfo;
        if (dataObject2 == null) {
            return;
        }
        HashMap<DataObject, ChangeInfo> hashMap = (HashMap<DataObject, ChangeInfo>)this.changesMap.get(dataObject);
        if (hashMap == null) {
            hashMap = new HashMap<DataObject, ChangeInfo>();
            this.changesMap.put(dataObject, hashMap);
        }
        if ((changeInfo = (ChangeInfo)hashMap.get(dataObject2)) == null) {
            changeInfo = new ChangeInfo();
            hashMap.put(dataObject2, changeInfo);
        }
        if (!changeInfo.changed.containsKey(string) && !changeInfo.added.contains(string)) {
            if (object != null) {
                changeInfo.changed.put(string, object);
            } else {
                changeInfo.added.add(string);
            }
        }
    }

    private static class ChangeInfo {
        Map changed = new HashMap();
        Set added = new HashSet();

        private ChangeInfo() {
        }
    }
}

