/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui.preview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import org.netbeans.modules.css.visual.api.StyleBuilderTopComponent;
import org.netbeans.modules.css.visual.ui.preview.CssPreviewTopComponent;
import org.openide.filesystems.FileObject;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class CssTCController
implements PropertyChangeListener {
    public static WeakReference<CssTCController> instance;
    private TopComponent lastCSSTC = null;

    public static synchronized CssTCController getDefault() {
        CssTCController cssTCController;
        if (instance == null) {
            instance = new WeakReference<CssTCController>(new CssTCController());
        }
        if ((cssTCController = (CssTCController)instance.get()) == null) {
            cssTCController = new CssTCController();
            instance = new WeakReference<CssTCController>(cssTCController);
            return cssTCController;
        }
        return (CssTCController)instance.get();
    }

    public CssTCController() {
        TopComponent.Registry registry = WindowManager.getDefault().getRegistry();
        registry.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)registry));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        TopComponent topComponent;
        if ("activated".equals(propertyChangeEvent.getPropertyName())) {
            TopComponent topComponent2 = (TopComponent)propertyChangeEvent.getNewValue();
            if (this.isCSSTC(topComponent2)) {
                this.previewableActivated(topComponent2);
            } else {
                if (topComponent2 instanceof CssPreviewTopComponent || topComponent2 instanceof StyleBuilderTopComponent) {
                    return;
                }
                if (WindowManager.getDefault().isOpenedEditorTopComponent(topComponent2) && this.lastCSSTC != null) {
                    this.notPreviewableActivated();
                }
            }
        } else if (this.lastCSSTC != null && "tcClosed".equals(propertyChangeEvent.getPropertyName()) && (topComponent = (TopComponent)propertyChangeEvent.getNewValue()) == this.lastCSSTC) {
            this.notPreviewableActivated();
        }
    }

    private boolean isCSSTC(TopComponent topComponent) {
        String string;
        if (topComponent == null) {
            return false;
        }
        FileObject fileObject = (FileObject)topComponent.getLookup().lookup(FileObject.class);
        return fileObject != null && (string = fileObject.getMIMEType()) != null && "text/x-css".equals(string);
    }

    private void previewableActivated(TopComponent topComponent) {
        this.lastCSSTC = topComponent;
        WindowManager.getDefault().findTopComponentGroup("Csswsgrp").open();
    }

    private void notPreviewableActivated() {
        this.lastCSSTC = null;
        WindowManager.getDefault().findTopComponentGroup("Csswsgrp").close();
    }
}

