/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.actions.scm.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.options.MavenCommandSettings;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class CheckoutUI
extends JPanel {
    private static File lastFolder = new File(System.getProperty("user.home"));
    private final JButton checkoutButton;
    private Scm scm;
    private MavenProject project;
    private JButton btnFile;
    private ButtonGroup buttonGroup1;
    private JCheckBox chkPrintDebugInfo;
    private JRadioButton defaultConnection;
    private JRadioButton developerConnection;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel lblActhenticationHint;
    private JLabel lblAuthenticationDescription;
    private JLabel lblConnection;
    private JLabel lblDescription;
    private JLabel lblFolderError;
    private JLabel lblLocalFolder;
    private JLabel lblLocalFolderDescription;
    private JLabel lblPassword;
    private JLabel lblUser;
    private JTextField txtFolder;
    private JPasswordField txtPassword;
    private JTextField txtUrl;
    private JTextField txtUser;

    public CheckoutUI(MavenProject mavenProject) {
        this.project = mavenProject;
        this.scm = mavenProject.getScm();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<b>");
        stringBuffer.append(mavenProject.getArtifactId());
        stringBuffer.append("</b>");
        stringBuffer.append(":");
        stringBuffer.append("<b>");
        stringBuffer.append(mavenProject.getVersion());
        stringBuffer.append("</b>");
        this.initComponents();
        this.lblDescription.setText(NbBundle.getMessage(CheckoutUI.class, (String)"LBL_Description", (Object)stringBuffer.toString()));
        this.checkoutButton = new JButton(NbBundle.getMessage(CheckoutUI.class, (String)"BTN_Checkout"));
        this.load();
        this.txtFolder.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                CheckoutUI.this.validateFolder();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                CheckoutUI.this.validateFolder();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                CheckoutUI.this.validateFolder();
            }
        });
        this.txtFolder.setText(ProjectChooser.getProjectsFolder().getAbsolutePath() + File.separator + this.project.getArtifactId());
    }

    private void validateFolder() {
        File file = new File(this.txtFolder.getText().trim());
        if (file.exists() && file.list() != null && file.list().length > 0) {
            this.checkoutButton.setEnabled(false);
            this.lblFolderError.setForeground(Color.red);
            this.lblFolderError.setText(NbBundle.getMessage(CheckoutUI.class, (String)"LBL_Folder_Error"));
        } else {
            this.lblFolderError.setText(NbBundle.getMessage(CheckoutUI.class, (String)"LBL_Folder"));
            this.checkoutButton.setEnabled(true);
            this.lblFolderError.setForeground(Color.BLACK);
        }
    }

    private void load() {
        if (this.scm.getConnection() != null) {
            this.defaultConnection.setSelected(true);
            this.txtUrl.setText(this.scm.getConnection());
        } else {
            this.defaultConnection.setEnabled(false);
        }
        if (this.scm.getDeveloperConnection() == null) {
            this.developerConnection.setEnabled(false);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.lblDescription = new JLabel();
        this.lblConnection = new JLabel();
        this.defaultConnection = new JRadioButton();
        this.developerConnection = new JRadioButton();
        this.lblLocalFolderDescription = new JLabel();
        this.txtFolder = new JTextField();
        this.btnFile = new JButton();
        this.lblLocalFolder = new JLabel();
        this.lblAuthenticationDescription = new JLabel();
        this.lblUser = new JLabel();
        this.txtUser = new JTextField();
        this.lblPassword = new JLabel();
        this.txtPassword = new JPasswordField();
        this.lblActhenticationHint = new JLabel();
        this.chkPrintDebugInfo = new JCheckBox();
        this.txtUrl = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.lblFolderError = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.lblDescription, (String)NbBundle.getMessage(CheckoutUI.class, (String)"LBL_Description"));
        this.lblConnection.setForeground(new Color(0, 0, 102));
        Mnemonics.setLocalizedText((JLabel)this.lblConnection, (String)NbBundle.getMessage(CheckoutUI.class, (String)"LBL_Connection"));
        this.buttonGroup1.add(this.defaultConnection);
        Mnemonics.setLocalizedText((AbstractButton)this.defaultConnection, (String)NbBundle.getMessage(CheckoutUI.class, (String)"LBL_DefaultConnection"));
        this.defaultConnection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CheckoutUI.this.defaultConnectionActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.developerConnection);
        Mnemonics.setLocalizedText((AbstractButton)this.developerConnection, (String)NbBundle.getMessage(CheckoutUI.class, (String)"LBL_DeveloperConnection"));
        this.developerConnection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CheckoutUI.this.developerConnectionActionPerformed(actionEvent);
            }
        });
        this.lblLocalFolderDescription.setForeground(new Color(0, 0, 102));
        Mnemonics.setLocalizedText((JLabel)this.lblLocalFolderDescription, (String)NbBundle.getMessage(CheckoutUI.class, (String)"LBL_LocalFolderDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnFile, (String)NbBundle.getMessage(CheckoutUI.class, (String)"BTN_Browse"));
        this.btnFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CheckoutUI.this.btnFileActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblLocalFolder, (String)NbBundle.getMessage(CheckoutUI.class, (String)"LBL_LocalFolder"));
        this.lblAuthenticationDescription.setForeground(new Color(0, 0, 102));
        Mnemonics.setLocalizedText((JLabel)this.lblAuthenticationDescription, (String)NbBundle.getMessage(CheckoutUI.class, (String)"LBL_AuthenticationDescription"));
        Mnemonics.setLocalizedText((JLabel)this.lblUser, (String)NbBundle.getMessage(CheckoutUI.class, (String)"LBL_User"));
        Mnemonics.setLocalizedText((JLabel)this.lblPassword, (String)NbBundle.getMessage(CheckoutUI.class, (String)"LBL_Password"));
        Mnemonics.setLocalizedText((JLabel)this.lblActhenticationHint, (String)NbBundle.getMessage(CheckoutUI.class, (String)"LBL_ActhenticationHint"));
        Mnemonics.setLocalizedText((AbstractButton)this.chkPrintDebugInfo, (String)NbBundle.getMessage(CheckoutUI.class, (String)"LBL_PrintDebugInfo"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CheckoutUI.class, (String)"CheckoutUI.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(CheckoutUI.class, (String)"CheckoutUI.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblFolderError, (String)NbBundle.getMessage(CheckoutUI.class, (String)"LBL_Folder"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblLocalFolderDescription, -1, 667, Short.MAX_VALUE).add((Component)this.chkPrintDebugInfo).add((Component)this.lblDescription, -1, 667, Short.MAX_VALUE).add((Component)this.lblAuthenticationDescription, -2, 297, -2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblUser).add((Component)this.lblPassword)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.txtPassword, -1, 174, Short.MAX_VALUE).add((Component)this.txtUser, -1, 174, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.lblActhenticationHint).add(166, 166, 166)).add((Component)this.lblConnection, -1, 667, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((Component)this.lblLocalFolder).add(10, 10, 10).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((Component)this.lblFolderError, -1, 555, Short.MAX_VALUE)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.txtFolder, -1, 470, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnFile)))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.jLabel1, -1, -1, Short.MAX_VALUE).add((Component)this.defaultConnection, -1, 97, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((Component)this.jLabel2, -1, 532, Short.MAX_VALUE)).add(2, (Component)this.txtUrl, -1, 542, Short.MAX_VALUE).add((Component)this.developerConnection, -2, 122, -2)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.lblDescription).addPreferredGap(1).add((Component)this.lblConnection).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.developerConnection).add((Component)this.defaultConnection)).add(3, 3, 3).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.txtUrl, -2, -1, -2)).add(5, 5, 5).add((Component)this.jLabel2).addPreferredGap(0, 13, Short.MAX_VALUE).add((Component)this.lblLocalFolderDescription).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.btnFile).add((Component)this.lblLocalFolder).add((Component)this.txtFolder, -2, -1, -2)).add(5, 5, 5).add((Component)this.lblFolderError, -2, 14, -2).addPreferredGap(0).add((Component)this.lblAuthenticationDescription).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblUser).add((Component)this.txtUser, -2, -1, -2).add((Component)this.lblActhenticationHint)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblPassword).add((Component)this.txtPassword, -2, -1, -2)).add(18, 18, 18).add((Component)this.chkPrintDebugInfo).add(18, 18, 18)));
    }

    private void btnFileActionPerformed(ActionEvent actionEvent) {
        int n;
        File file;
        JFileChooser jFileChooser = new JFileChooser(lastFolder);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle(NbBundle.getMessage(CheckoutUI.class, (String)"TIT_Choose"));
        jFileChooser.setMultiSelectionEnabled(false);
        if (this.txtFolder.getText().trim().length() > 0 && (file = new File(this.txtFolder.getText().trim())).exists()) {
            jFileChooser.setSelectedFile(file);
        }
        if ((n = jFileChooser.showDialog(SwingUtilities.getWindowAncestor(this), NbBundle.getMessage(CheckoutUI.class, (String)"LBL_Select"))) == 0) {
            this.txtFolder.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            this.txtFolder.requestFocusInWindow();
        }
    }

    private void defaultConnectionActionPerformed(ActionEvent actionEvent) {
        if (this.defaultConnection.isEnabled()) {
            this.txtUrl.setText(this.scm.getConnection());
        }
    }

    private void developerConnectionActionPerformed(ActionEvent actionEvent) {
        if (this.developerConnection.isEnabled()) {
            this.txtUrl.setText(this.scm.getDeveloperConnection());
        }
    }

    public File getCheckoutDirectory() {
        return FileUtil.normalizeFile((File)new File(this.txtFolder.getText().trim()));
    }

    public RunConfig getRunConfig() {
        BeanRunConfig beanRunConfig = new BeanRunConfig();
        beanRunConfig.setExecutionDirectory(this.getCheckoutDirectory().getParentFile());
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(MavenCommandSettings.getDefault().getCommand("scmCheckout"));
        beanRunConfig.setGoals(arrayList);
        beanRunConfig.setTaskDisplayName(NbBundle.getMessage(CheckoutUI.class, (String)"LBL_Checkout", (Object)(this.project.getArtifactId() + " : " + this.project.getVersion())));
        beanRunConfig.setExecutionName(beanRunConfig.getTaskDisplayName());
        Properties properties = new Properties();
        properties.put("checkoutDirectory", this.getCheckoutDirectory().getAbsolutePath());
        properties.put("connectionUrl", this.txtUrl.getText());
        if (this.txtUser.getText().trim().length() != 0) {
            properties.put("username", this.txtUser.getText());
            properties.put("password ", new String(this.txtPassword.getPassword()));
        }
        beanRunConfig.setProperties(properties);
        beanRunConfig.setShowDebug(this.chkPrintDebugInfo.isSelected());
        beanRunConfig.setShowError(this.chkPrintDebugInfo.isSelected());
        beanRunConfig.setOffline(false);
        beanRunConfig.setUpdateSnapshots(false);
        beanRunConfig.setActivatedProfiles(Collections.<String>emptyList());
        beanRunConfig.setInteractive(true);
        beanRunConfig.setActionName("scm-checkout");
        return beanRunConfig;
    }

    public JButton getCheckoutButton() {
        return this.checkoutButton;
    }
}

