/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.classpath.EndorsedClassPathImpl;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BootClassPathImpl
implements ClassPathImplementation,
PropertyChangeListener {
    private List<? extends PathResourceImplementation> resourcesCache;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final NbMavenProjectImpl project;
    private String lastHintValue = null;
    private boolean activePlatformValid = true;
    private JavaPlatformManager platformManager;
    private final EndorsedClassPathImpl ecpImpl;
    final Object LOCK = new Object();

    BootClassPathImpl(NbMavenProjectImpl nbMavenProjectImpl, EndorsedClassPathImpl endorsedClassPathImpl) {
        this.project = nbMavenProjectImpl;
        this.ecpImpl = endorsedClassPathImpl;
        endorsedClassPathImpl.setBCP(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends PathResourceImplementation> getResources() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.resourcesCache == null) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.addAll(this.ecpImpl.getResources());
                JavaPlatform javaPlatform = this.findActivePlatform();
                if (javaPlatform != null) {
                    ClassPath classPath = javaPlatform.getBootstrapLibraries();
                    List list = classPath.entries();
                    for (ClassPath.Entry entry : list) {
                        arrayList.add(ClassPathSupport.createResource((URL)entry.getURL()));
                    }
                }
                this.resourcesCache = Collections.unmodifiableList(arrayList);
            }
            return this.resourcesCache;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JavaPlatform findActivePlatform() {
        Object object = this.LOCK;
        synchronized (object) {
            Object object2;
            this.activePlatformValid = true;
            if (this.platformManager == null) {
                this.platformManager = JavaPlatformManager.getDefault();
                this.platformManager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.platformManager));
                object2 = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
                ((NbMavenProject)object2).addPropertyChangeListener(this);
            }
            object2 = this.project.getAuxProps().get("netbeans.hint.jdkPlatform", true);
            this.lastHintValue = object2;
            JavaPlatform javaPlatform = BootClassPathImpl.getActivePlatform((String)object2);
            if (javaPlatform == null) {
                Logger.getLogger(BootClassPathImpl.class.getName()).fine("Cannot find java platform with id of '" + (String)object2 + "'");
                javaPlatform = this.platformManager.getDefaultPlatform();
                this.activePlatformValid = false;
            }
            return javaPlatform;
        }
    }

    public static JavaPlatform getActivePlatform(String string) {
        JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
        if (string == null) {
            return javaPlatformManager.getDefaultPlatform();
        }
        JavaPlatform[] javaPlatformArray = javaPlatformManager.getPlatforms(null, new Specification("j2se", null));
        for (int i = 0; i < javaPlatformArray.length; ++i) {
            String string2 = (String)javaPlatformArray[i].getProperties().get("platform.ant.name");
            if (string2 == null || !string2.equals(string)) continue;
            return javaPlatformArray[i];
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = ((AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class)).get("netbeans.hint.jdkPlatform", true);
        if (propertyChangeEvent.getSource() == this.project && propertyChangeEvent.getPropertyName().equals("MavenProject")) {
            if (this.ecpImpl.resetCache()) {
                this.resetCache();
            } else if (string == null && this.lastHintValue != null || string != null && !string.equals(this.lastHintValue)) {
                this.resetCache();
            }
        } else if (propertyChangeEvent.getSource() == this.platformManager && "installedPlatforms".equals(propertyChangeEvent.getPropertyName()) && this.lastHintValue != null) {
            this.lastHintValue = string;
            if (this.activePlatformValid) {
                if (BootClassPathImpl.getActivePlatform(this.lastHintValue) == null) {
                    this.resetCache();
                }
            } else if (BootClassPathImpl.getActivePlatform(this.lastHintValue) != null) {
                this.resetCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCache() {
        Object object = this.LOCK;
        synchronized (object) {
            this.resourcesCache = null;
        }
        this.support.firePropertyChange("resources", null, null);
    }
}

