/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.dependencies;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyExcludeNodeVisitor
implements DependencyNodeVisitor {
    private DependencyNode root;
    private Set<DependencyNode> directs;
    private Stack<DependencyNode> path;
    private Set<Stack<DependencyNode>> allPaths;
    private String key;

    public DependencyExcludeNodeVisitor(String string, String string2, String string3) {
        assert (string != null);
        assert (string2 != null);
        this.key = string + ":" + string2 + ":" + string3;
    }

    public Set<DependencyNode> getDirectDependencies() {
        return this.directs;
    }

    public Set<Stack<DependencyNode>> getAllPaths() {
        return this.allPaths;
    }

    public boolean visit(DependencyNode dependencyNode) {
        if (this.root == null) {
            this.root = dependencyNode;
            this.directs = new HashSet<DependencyNode>();
            this.path = new Stack();
            this.allPaths = new HashSet<Stack<DependencyNode>>();
            return true;
        }
        this.path.push(dependencyNode);
        Artifact artifact = dependencyNode.getArtifact();
        if (this.key.equals(artifact.getDependencyConflictId())) {
            if (!this.path.isEmpty()) {
                this.directs.add((DependencyNode)this.path.firstElement());
                Stack<DependencyNode> stack = new Stack<DependencyNode>();
                stack.addAll(this.path);
                this.allPaths.add(stack);
            }
            return false;
        }
        return true;
    }

    public boolean endVisit(DependencyNode dependencyNode) {
        if (this.root == dependencyNode) {
            this.root = null;
            this.path = null;
            return true;
        }
        this.path.pop();
        return true;
    }
}

