/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.maven.execute.JavaOutputHandler;
import org.openide.util.io.NullOutputStream;

public class IOBridge {
    private static int delegating = 0;
    private static InputStream origIn;
    private static PrintStream origOut;
    private static PrintStream origErr;
    private static Map<ThreadGroup, InputStream> delegateIns;
    private static Map<ThreadGroup, PrintStream> delegateOuts;
    private static Map<ThreadGroup, PrintStream> delegateErrs;
    private static List<Thread> suspendedDelegationTasks;

    static synchronized void pushSystemInOutErr(JavaOutputHandler javaOutputHandler) {
        if (delegating++ == 0) {
            origIn = System.in;
            origOut = System.out;
            origErr = System.err;
            System.setIn(new MultiplexInputStream());
            System.setOut(new MultiplexPrintStream(false));
            System.setErr(new MultiplexPrintStream(true));
        }
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        delegateIns.put(threadGroup, javaOutputHandler.getIn());
        delegateOuts.put(threadGroup, javaOutputHandler.getOut());
        delegateErrs.put(threadGroup, javaOutputHandler.getErr());
    }

    public static synchronized void restoreSystemInOutErr() {
        assert (delegating > 0);
        if (--delegating == 0) {
            System.setIn(origIn);
            System.setOut(origOut);
            System.setErr(origErr);
            origIn = null;
            origOut = null;
            origErr = null;
        }
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        delegateIns.remove(threadGroup);
        delegateOuts.remove(threadGroup);
        delegateErrs.remove(threadGroup);
    }

    public static synchronized void suspendDelegation() {
        Thread thread = Thread.currentThread();
        suspendedDelegationTasks.add(thread);
    }

    public static synchronized void resumeDelegation() {
        Thread thread = Thread.currentThread();
        assert (suspendedDelegationTasks.contains(thread)) : "Have not suspended delegation in " + thread;
        suspendedDelegationTasks.remove(thread);
    }

    static {
        delegateIns = new HashMap<ThreadGroup, InputStream>();
        delegateOuts = new HashMap<ThreadGroup, PrintStream>();
        delegateErrs = new HashMap<ThreadGroup, PrintStream>();
        suspendedDelegationTasks = new ArrayList<Thread>();
    }

    private static final class MultiplexPrintStream
    extends PrintStream {
        private final boolean err;

        public MultiplexPrintStream(boolean bl) {
            this(new NullOutputStream(), bl);
        }

        private MultiplexPrintStream(NullOutputStream nullOutputStream, boolean bl) {
            super((OutputStream)nullOutputStream);
            nullOutputStream.throwException = true;
            this.err = bl;
        }

        private PrintStream delegate() {
            ThreadGroup threadGroup;
            Map map;
            Thread thread = Thread.currentThread();
            Map map2 = map = this.err ? delegateErrs : delegateOuts;
            for (threadGroup = thread.getThreadGroup(); threadGroup != null && !map.containsKey(threadGroup); threadGroup = threadGroup.getParent()) {
            }
            PrintStream printStream = (PrintStream)map.get(threadGroup);
            if (printStream != null && !suspendedDelegationTasks.contains(thread)) {
                return printStream;
            }
            if (delegating > 0) {
                PrintStream printStream2;
                PrintStream printStream3 = printStream2 = this.err ? origErr : origOut;
                assert (printStream2 != null);
                return printStream2;
            }
            return this.err ? System.err : System.out;
        }

        public boolean checkError() {
            return this.delegate().checkError();
        }

        public void close() {
            this.delegate().close();
        }

        public void flush() {
            this.delegate().flush();
        }

        public void print(long l) {
            this.delegate().print(l);
        }

        public void print(char[] cArray) {
            this.delegate().print(cArray);
        }

        public void print(int n) {
            this.delegate().print(n);
        }

        public void print(boolean bl) {
            this.delegate().print(bl);
        }

        public void print(char c) {
            this.delegate().print(c);
        }

        public void print(float f) {
            this.delegate().print(f);
        }

        public void print(double d) {
            this.delegate().print(d);
        }

        public void print(Object object) {
            this.delegate().print(object);
        }

        public void print(String string) {
            this.delegate().print(string);
        }

        public void println(double d) {
            this.delegate().println(d);
        }

        public void println(Object object) {
            this.delegate().println(object);
        }

        public void println(float f) {
            this.delegate().println(f);
        }

        public void println(int n) {
            this.delegate().println(n);
        }

        public void println(char c) {
            this.delegate().println(c);
        }

        public void println(boolean bl) {
            this.delegate().println(bl);
        }

        public void println(String string) {
            this.delegate().println(string);
        }

        public void println(char[] cArray) {
            this.delegate().println(cArray);
        }

        public void println() {
            this.delegate().println();
        }

        public void println(long l) {
            this.delegate().println(l);
        }

        public void write(int n) {
            this.delegate().write(n);
        }

        public void write(byte[] byArray) throws IOException {
            this.delegate().write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) {
            this.delegate().write(byArray, n, n2);
        }
    }

    private static final class MultiplexInputStream
    extends InputStream {
        private InputStream delegate() {
            ThreadGroup threadGroup;
            Thread thread = Thread.currentThread();
            for (threadGroup = thread.getThreadGroup(); threadGroup != null && !delegateIns.containsKey(threadGroup); threadGroup = threadGroup.getParent()) {
            }
            InputStream inputStream = (InputStream)delegateIns.get(threadGroup);
            if (inputStream != null && !suspendedDelegationTasks.contains(thread)) {
                return inputStream;
            }
            if (delegating > 0) {
                assert (origIn != null);
                return origIn;
            }
            return System.in;
        }

        public int read() throws IOException {
            return this.delegate().read();
        }

        public int read(byte[] byArray) throws IOException {
            return this.delegate().read(byArray);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.delegate().read(byArray, n, n2);
        }

        public int available() throws IOException {
            return this.delegate().available();
        }

        public boolean markSupported() {
            return this.delegate().markSupported();
        }

        public void mark(int n) {
            this.delegate().mark(n);
        }

        public void close() throws IOException {
            this.delegate().close();
        }

        public long skip(long l) throws IOException {
            return this.delegate().skip(l);
        }

        public void reset() throws IOException {
            this.delegate().reset();
        }
    }
}

