/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.lucene.search.BooleanQuery;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.TextValueCompleter;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.customizer.support.DelayedDocumentChangeListener;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.spi.nodes.MavenNodeFactory;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.DialogDescriptor;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddDependencyPanel
extends JPanel
implements ActionListener {
    private MavenProject project;
    private final TextValueCompleter groupCompleter;
    private final TextValueCompleter artifactCompleter;
    private final TextValueCompleter versionCompleter;
    private final JButton okButton;
    private final QueryPanel queryPanel;
    private DMListPanel artifactList;
    private Color defaultProgressC;
    private Color curProgressC;
    private Color defaultVersionC;
    private static final int PROGRESS_STEP = 10;
    private static final int CYCLE_LOWER_LIMIT = -3;
    private static final int CYCLE_UPPER_LIMIT = 5;
    private int varianceStep;
    private int variance;
    private Timer progressTimer = new Timer(100, this);
    private static final String DELIMITER = " : ";
    private NotificationLineSupport nls;
    private JPanel artifactPanel;
    private JLabel artifactsLabel;
    private JComboBox comScope;
    private JPanel coordPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JLabel lblArtifactId;
    private JLabel lblGroupId;
    private JLabel lblScope;
    private JLabel lblVersion;
    private JPanel pnlDepMan;
    private JPanel pnlOpen;
    private JPanel pnlOpenProjects;
    private JLabel progressLabel;
    private JLabel resultsLabel;
    private JPanel resultsPanel;
    private JTextField searchField;
    private JLabel searchLabel;
    private JPanel searchPanel;
    private JTabbedPane tabPane;
    private JTextField txtArtifactId;
    private JTextField txtGroupId;
    private JTextField txtVersion;
    private static Node noResultsRoot;
    private static final Object LOCK;
    private static final Object DM_DEPS_LOCK;

    public AddDependencyPanel(MavenProject mavenProject, Project project) {
        this(mavenProject, true, project);
    }

    public AddDependencyPanel(MavenProject mavenProject, boolean bl, Project project) {
        this.project = mavenProject;
        this.initComponents();
        this.groupCompleter = new TextValueCompleter(Collections.<String>emptyList(), this.txtGroupId);
        this.artifactCompleter = new TextValueCompleter(Collections.<String>emptyList(), this.txtArtifactId);
        this.versionCompleter = new TextValueCompleter(Collections.<String>emptyList(), this.txtVersion);
        this.txtGroupId.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (AddDependencyPanel.this.txtGroupId.getText().trim().length() > 0) {
                    AddDependencyPanel.this.artifactCompleter.setLoading(true);
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            AddDependencyPanel.this.populateArtifact();
                        }
                    });
                }
            }
        });
        this.txtArtifactId.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (AddDependencyPanel.this.txtGroupId.getText().trim().length() > 0 && AddDependencyPanel.this.txtArtifactId.getText().trim().length() > 0) {
                    AddDependencyPanel.this.versionCompleter.setLoading(true);
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            AddDependencyPanel.this.populateVersion();
                        }
                    });
                }
            }
        });
        this.okButton = new JButton(NbBundle.getMessage(AddDependencyPanel.class, (String)"BTN_OK"));
        DocumentListener documentListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                AddDependencyPanel.this.checkValidState();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                AddDependencyPanel.this.checkValidState();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                AddDependencyPanel.this.checkValidState();
            }
        };
        this.txtGroupId.getDocument().addDocumentListener(documentListener);
        this.txtVersion.getDocument().addDocumentListener(documentListener);
        this.txtArtifactId.getDocument().addDocumentListener(documentListener);
        this.checkValidState();
        this.groupCompleter.setLoading(true);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                AddDependencyPanel.this.populateGroupId();
            }
        });
        this.queryPanel = new QueryPanel();
        this.resultsPanel.add((Component)this.queryPanel, "Center");
        this.searchField.getDocument().addDocumentListener(DelayedDocumentChangeListener.create(this.searchField.getDocument(), this.queryPanel, 500));
        this.defaultProgressC = this.progressLabel.getForeground();
        this.defaultVersionC = this.txtVersion.getForeground();
        this.setSearchInProgressUI(false);
        if (bl) {
            this.artifactList = new DMListPanel(this.project);
            this.artifactPanel.add((Component)this.artifactList, "Center");
        } else {
            this.tabPane.setEnabledAt(1, false);
        }
        this.pnlOpenProjects.add((Component)new OpenListPanel(project), "Center");
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public String getGroupId() {
        return this.txtGroupId.getText().trim();
    }

    public String getArtifactId() {
        return this.txtArtifactId.getText().trim();
    }

    public String getVersion() {
        return this.txtVersion.getText().trim();
    }

    public String getScope() {
        String string = this.comScope.getSelectedItem().toString();
        if ("compile".equals(string)) {
            string = null;
        }
        return string;
    }

    public void attachDialogDisplayer(DialogDescriptor dialogDescriptor) {
        this.nls = dialogDescriptor.getNotificationLineSupport();
        if (this.nls == null) {
            this.nls = dialogDescriptor.createNotificationLineSupport();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        assert (this.nls != null) : " The notificationLineSupport was not attached to the panel.";
    }

    void setSelectedScope(String string) {
        this.comScope.setSelectedItem(string);
    }

    private void checkValidState() {
        String string;
        String string2;
        String string3 = this.txtGroupId.getText().trim();
        if (string3.length() <= 0) {
            string3 = null;
        }
        if ((string2 = this.txtArtifactId.getText().trim()).length() <= 0) {
            string2 = null;
        }
        if ((string = this.txtVersion.getText().trim()).length() <= 0) {
            string = null;
        }
        boolean bl = this.tabPane.isEnabledAt(1);
        if (this.artifactList != null) {
            Color color = this.defaultVersionC;
            String string4 = null;
            if (bl && AddDependencyPanel.findConflict(this.artifactList.getDMDeps(), string3, string2, string, null) == 1) {
                color = Color.RED;
                string4 = NbBundle.getMessage(AddDependencyPanel.class, (String)"MSG_VersionConflict");
            }
            this.txtVersion.setForeground(color);
            if (string4 != null) {
                this.nls.setWarningMessage(string4);
            } else {
                this.nls.clearMessages();
            }
        }
        if (string3 == null) {
            this.okButton.setEnabled(false);
            return;
        }
        if (string2 == null) {
            this.okButton.setEnabled(false);
            return;
        }
        if (string == null && !bl) {
            this.okButton.setEnabled(false);
            return;
        }
        this.okButton.setEnabled(true);
    }

    private static Border getNbScrollPaneBorder() {
        Border border = UIManager.getBorder("Nb.ScrollPane.border");
        if (border == null) {
            Color color = UIManager.getColor("controlShadow");
            border = new LineBorder(color != null ? color : Color.GRAY);
        }
        return border;
    }

    private void initComponents() {
        this.coordPanel = new JPanel();
        this.lblGroupId = new JLabel();
        this.txtGroupId = new JTextField();
        this.lblArtifactId = new JLabel();
        this.txtArtifactId = new JTextField();
        this.lblVersion = new JLabel();
        this.txtVersion = new JTextField();
        this.lblScope = new JLabel();
        this.comScope = new JComboBox();
        this.tabPane = new JTabbedPane();
        this.searchPanel = new JPanel();
        this.searchLabel = new JLabel();
        this.searchField = new JTextField();
        this.jLabel1 = new JLabel();
        this.resultsLabel = new JLabel();
        this.resultsPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.progressLabel = new JLabel();
        this.pnlDepMan = new JPanel();
        this.artifactsLabel = new JLabel();
        this.artifactPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.pnlOpen = new JPanel();
        this.jLabel3 = new JLabel();
        this.pnlOpenProjects = new JPanel();
        this.lblGroupId.setLabelFor(this.txtGroupId);
        Mnemonics.setLocalizedText((JLabel)this.lblGroupId, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"LBL_GroupId"));
        this.lblArtifactId.setLabelFor(this.txtArtifactId);
        Mnemonics.setLocalizedText((JLabel)this.lblArtifactId, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"LBL_ArtifactId"));
        this.lblVersion.setLabelFor(this.txtVersion);
        Mnemonics.setLocalizedText((JLabel)this.lblVersion, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"LBL_Version"));
        this.lblScope.setLabelFor(this.comScope);
        Mnemonics.setLocalizedText((JLabel)this.lblScope, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"LBL_Scope"));
        this.comScope.setModel(new DefaultComboBoxModel<String>(new String[]{"compile", "runtime", "test", "provided"}));
        GroupLayout groupLayout = new GroupLayout((Container)this.coordPanel);
        this.coordPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblArtifactId).add((Component)this.lblGroupId).add((Component)this.lblVersion)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.txtArtifactId, -1, 382, Short.MAX_VALUE).add((Component)this.txtGroupId, -1, 382, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.txtVersion, -1, 273, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.lblScope).addPreferredGap(0).add((Component)this.comScope, -2, -1, -2))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.txtGroupId, -2, -1, -2).add((Component)this.lblGroupId)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblArtifactId).add((Component)this.txtArtifactId, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblVersion).add((Component)this.comScope, -2, -1, -2).add((Component)this.lblScope).add((Component)this.txtVersion, -2, -1, -2)).add(43, 43, 43)));
        this.txtGroupId.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.txtGroupId.AccessibleContext.accessibleDescription"));
        this.txtArtifactId.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.txtArtifactId.AccessibleContext.accessibleDescription"));
        this.txtVersion.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.txtVersion.AccessibleContext.accessibleDescription"));
        this.comScope.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.comScope.AccessibleContext.accessibleDescription"));
        this.searchPanel.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                AddDependencyPanel.this.searchPanelComponentShown(componentEvent);
            }
        });
        this.searchLabel.setLabelFor(this.searchField);
        Mnemonics.setLocalizedText((JLabel)this.searchLabel, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.searchLabel.text", (Object[])new Object[0]));
        this.searchField.setText(NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.searchField.text", (Object[])new Object[0]));
        this.jLabel1.setForeground(UIManager.getDefaults().getColor("textInactiveText"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.jLabel1.text", (Object[])new Object[0]));
        Mnemonics.setLocalizedText((JLabel)this.resultsLabel, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.resultsLabel.text", (Object[])new Object[0]));
        this.resultsPanel.setBorder(AddDependencyPanel.getNbScrollPaneBorder());
        this.resultsPanel.setLayout(new BorderLayout());
        this.progressLabel.setForeground(SystemColor.textInactiveText);
        Mnemonics.setLocalizedText((JLabel)this.progressLabel, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.progressLabel.text", (Object[])new Object[0]));
        this.progressLabel.setToolTipText(NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.progressLabel.toolTipText", (Object[])new Object[0]));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.progressLabel, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.progressLabel, -2, 18, -2));
        GroupLayout groupLayout3 = new GroupLayout((Container)this.searchPanel);
        this.searchPanel.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(2).add(1, (GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((Component)this.resultsPanel, -1, 431, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((Component)this.resultsLabel).addPreferredGap(0, 297, Short.MAX_VALUE).add((Component)this.jPanel1, -2, -1, -2)).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add(12, 12, 12).add((Component)this.searchLabel).add(4, 4, 4).add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.jLabel1).add(14, 14, 14)).add((Component)this.searchField, -1, 391, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.searchLabel).add((Component)this.searchField, -2, -1, -2)).addPreferredGap(0).add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.jPanel1, -2, -1, -2).add((Component)this.resultsLabel)).addPreferredGap(0).add((Component)this.resultsPanel, -1, 194, Short.MAX_VALUE).addContainerGap()));
        this.searchField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.searchField.AccessibleContext.accessibleDescription"));
        this.resultsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.resultsLabel.AccessibleContext.accessibleDescription"));
        this.tabPane.addTab(NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.searchPanel.TabConstraints.tabTitle", (Object[])new Object[0]), this.searchPanel);
        Mnemonics.setLocalizedText((JLabel)this.artifactsLabel, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.artifactsLabel.text", (Object[])new Object[0]));
        this.artifactPanel.setBorder(AddDependencyPanel.getNbScrollPaneBorder());
        this.artifactPanel.setLayout(new BorderLayout());
        this.jLabel2.setForeground(UIManager.getDefaults().getColor("textInactiveText"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.jLabel2.text", (Object[])new Object[0]));
        this.artifactPanel.add((Component)this.jLabel2, "Last");
        GroupLayout groupLayout4 = new GroupLayout((Container)this.pnlDepMan);
        this.pnlDepMan.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.artifactPanel, -1, 431, Short.MAX_VALUE).add((Component)this.artifactsLabel)).addContainerGap()));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((Component)this.artifactsLabel).addPreferredGap(0).add((Component)this.artifactPanel, -1, 244, Short.MAX_VALUE).addContainerGap()));
        this.tabPane.addTab(NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.pnlDepMan.TabConstraints.tabTitle", (Object[])new Object[0]), this.pnlDepMan);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.jLabel3.text"));
        this.pnlOpenProjects.setLayout(new BorderLayout());
        GroupLayout groupLayout5 = new GroupLayout((Container)this.pnlOpen);
        this.pnlOpen.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((Component)this.pnlOpenProjects, -1, 431, Short.MAX_VALUE).add((Component)this.jLabel3)).addContainerGap()));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.pnlOpenProjects, -1, 244, Short.MAX_VALUE).addContainerGap()));
        this.tabPane.addTab(NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.pnlOpen.TabConstraints.tabTitle"), this.pnlOpen);
        GroupLayout groupLayout6 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout6);
        groupLayout6.setHorizontalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((Component)this.tabPane, -1, 456, Short.MAX_VALUE).add(2, (Component)this.coordPanel, -1, -1, Short.MAX_VALUE));
        groupLayout6.setVerticalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((GroupLayout.Group)groupLayout6.createSequentialGroup().add((Component)this.coordPanel, -2, 125, -2).addPreferredGap(0).add((Component)this.tabPane, -1, 311, Short.MAX_VALUE)));
        this.tabPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.tabPane.AccessibleContext.accessibleDescription"));
    }

    private void searchPanelComponentShown(ComponentEvent componentEvent) {
        this.searchField.requestFocus();
    }

    private void populateGroupId() {
        assert (!SwingUtilities.isEventDispatchThread());
        final ArrayList arrayList = new ArrayList(RepositoryQueries.getGroups((RepositoryInfo[])new RepositoryInfo[0]));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AddDependencyPanel.this.groupCompleter.setValueList(arrayList);
            }
        });
    }

    private void populateArtifact() {
        assert (!SwingUtilities.isEventDispatchThread());
        final ArrayList arrayList = new ArrayList(RepositoryQueries.getArtifacts((String)this.txtGroupId.getText().trim(), (RepositoryInfo[])new RepositoryInfo[0]));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AddDependencyPanel.this.artifactCompleter.setValueList(arrayList);
            }
        });
    }

    private void populateVersion() {
        assert (!SwingUtilities.isEventDispatchThread());
        List list = RepositoryQueries.getVersions((String)this.txtGroupId.getText().trim(), (String)this.txtArtifactId.getText().trim(), (RepositoryInfo[])new RepositoryInfo[0]);
        final ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : list) {
            if (arrayList.contains(object.getVersion())) continue;
            arrayList.add(object.getVersion());
        }
        Collections.sort(arrayList);
        ArrayList arrayList2 = new ArrayList();
        for (Object e : this.project.getProperties().keySet()) {
            String string = (String)e;
            if (!string.endsWith(".version")) continue;
            arrayList2.add("${" + string + "}");
        }
        Collections.sort(arrayList2);
        arrayList.addAll(arrayList2);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AddDependencyPanel.this.versionCompleter.setValueList(arrayList);
            }
        });
    }

    private void setSearchInProgressUI(boolean bl) {
        if (bl && this.progressLabel.isVisible()) {
            return;
        }
        if (bl) {
            this.progressLabel.setForeground(this.defaultProgressC);
            this.progressLabel.setVisible(true);
            this.curProgressC = this.defaultProgressC;
            this.varianceStep = 1;
            this.variance = 0;
            this.progressTimer.start();
        } else {
            this.progressLabel.setVisible(false);
            this.progressTimer.stop();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = 10 * this.variance;
        this.curProgressC = new Color(Math.min(255, Math.max(0, this.defaultProgressC.getRed() + n)), Math.min(255, Math.max(0, this.defaultProgressC.getGreen() + n)), Math.min(255, Math.max(0, this.defaultProgressC.getBlue() + n)));
        this.progressLabel.setForeground(this.curProgressC);
        if (this.variance == -3 || this.variance == 5) {
            this.varianceStep = -this.varianceStep;
        }
        this.variance += this.varianceStep;
    }

    private static List<Dependency> getDepencenciesFromDM(MavenProject mavenProject) {
        ArrayList<Dependency> arrayList = new ArrayList<Dependency>();
        HashSet<String> hashSet = new HashSet<String>();
        for (MavenProject mavenProject2 = mavenProject; mavenProject2 != null; mavenProject2 = mavenProject2.getParent()) {
            DependencyManagement dependencyManagement = mavenProject2.getDependencyManagement();
            if (dependencyManagement == null) continue;
            List list = dependencyManagement.getDependencies();
            for (Dependency dependency : list) {
                if (hashSet.contains(dependency.getManagementKey())) continue;
                arrayList.add(dependency);
                hashSet.add(dependency.getManagementKey());
            }
        }
        return arrayList;
    }

    private static int findConflict(List<Dependency> list, String string, String string2, String string3, String string4) {
        if (list == null) {
            return 0;
        }
        for (Dependency dependency : list) {
            if (string2 == null || !string2.equals(dependency.getArtifactId()) || string == null || !string.equals(dependency.getGroupId())) continue;
            if (string3 != null && !string3.equals(dependency.getVersion())) {
                return 1;
            }
            if (!(string4 != null ? !string4.equals(dependency.getScope()) : dependency.getScope() != null)) continue;
            return 2;
        }
        return 0;
    }

    void setFields(String string, String string2, String string3) {
        boolean bl = false;
        if (string != null && string.equals(this.project.getGroupId())) {
            string = "${project.groupId}";
            bl = true;
        }
        this.txtGroupId.setText(string);
        this.txtArtifactId.setText(string2);
        if (bl && string3 != null && string3.equals(this.project.getVersion())) {
            string3 = "${project.version}";
        }
        this.txtVersion.setText(string3);
    }

    private static Node getNoResultsRoot() {
        if (noResultsRoot == null) {
            AbstractNode abstractNode = new AbstractNode(Children.LEAF){

                public Image getIcon(int n) {
                    return ImageUtilities.loadImage((String)"org/netbeans/modules/maven/resources/empty.png");
                }

                public Image getOpenedIcon(int n) {
                    return this.getIcon(n);
                }
            };
            abstractNode.setName("Empty");
            abstractNode.setDisplayName(NbBundle.getMessage(QueryPanel.class, (String)"LBL_Node_Empty"));
            Children.Array array = new Children.Array();
            array.add(new Node[]{abstractNode});
            noResultsRoot = new AbstractNode((Children)array);
        }
        return noResultsRoot;
    }

    private void changeSelection(Lookup lookup) {
        new DefAction(false, lookup).actionPerformed(null);
    }

    private Node createFilterWithDefaultAction(final Node node, boolean bl) {
        Object object = bl ? Children.LEAF : new FilterNode.Children(node){

            protected Node[] createNodes(Node node) {
                return new Node[]{AddDependencyPanel.this.createFilterWithDefaultAction(node, true)};
            }
        };
        return new FilterNode(node, (Children)object){

            public Action getPreferredAction() {
                return new DefAction(true, node.getLookup());
            }
        };
    }

    static {
        LOCK = new Object();
        DM_DEPS_LOCK = new Object();
    }

    private class DefAction
    extends AbstractAction
    implements ContextAwareAction {
        private final boolean close;
        private final Lookup lookup;

        public DefAction(boolean bl, Lookup lookup) {
            this.close = bl;
            this.lookup = lookup;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            NbMavenProject nbMavenProject;
            Project project = (Project)this.lookup.lookup(Project.class);
            boolean bl = false;
            if (project != null) {
                nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
                object = nbMavenProject.getMavenProject();
                AddDependencyPanel.this.setFields(object.getGroupId(), object.getArtifactId(), object.getVersion());
                bl = true;
            }
            if (!bl && (nbMavenProject = (NBVersionInfo)this.lookup.lookup(NBVersionInfo.class)) != null) {
                object = AddDependencyPanel.this.queryPanel.isVisible() ? nbMavenProject.getVersion() : "";
                AddDependencyPanel.this.setFields(nbMavenProject.getGroupId(), nbMavenProject.getArtifactId(), (String)object);
                bl = true;
            }
            if (bl) {
                if (this.close) {
                    AddDependencyPanel.this.getOkButton().doClick();
                } else {
                    AddDependencyPanel.this.artifactCompleter.setLoading(true);
                    AddDependencyPanel.this.versionCompleter.setLoading(true);
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            AddDependencyPanel.this.populateArtifact();
                            AddDependencyPanel.this.populateVersion();
                        }
                    });
                }
            } else {
                AddDependencyPanel.this.setFields("", "", "");
                AddDependencyPanel.this.artifactCompleter.setValueList(Collections.<String>emptyList());
                AddDependencyPanel.this.versionCompleter.setValueList(Collections.<String>emptyList());
            }
        }

        public Action createContextAwareInstance(Lookup lookup) {
            return new DefAction(this.close, lookup);
        }
    }

    private class OpenListPanel
    extends JPanel
    implements ExplorerManager.Provider,
    PropertyChangeListener,
    Runnable,
    ActionListener {
        private BeanTreeView btv;
        private ExplorerManager manager;
        private Project project;

        public OpenListPanel(Project project) {
            this.project = project;
            this.btv = new BeanTreeView();
            this.btv.setRootVisible(false);
            this.btv.setDefaultActionAllowed(true);
            this.btv.setUseSubstringInQuickSearch(true);
            this.manager = new ExplorerManager();
            this.manager.addPropertyChangeListener((PropertyChangeListener)this);
            this.setLayout(new BorderLayout());
            this.add((Component)this.btv, "Center");
            RequestProcessor.getDefault().post((Runnable)this);
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Node[] nodeArray = this.manager.getSelectedNodes();
            AddDependencyPanel.this.changeSelection(nodeArray.length == 1 ? nodeArray[0].getLookup() : Lookup.EMPTY);
        }

        public void run() {
            Children.Array array = OpenProjects.getDefault().getOpenProjects();
            final ArrayList<Node> arrayList = new ArrayList<Node>();
            for (Project project : array) {
                NbMavenProject nbMavenProject;
                if (project == this.project || (nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class)) == null) continue;
                LogicalViewProvider logicalViewProvider = (LogicalViewProvider)project.getLookup().lookup(LogicalViewProvider.class);
                arrayList.add(AddDependencyPanel.this.createFilterWithDefaultAction(logicalViewProvider.createLogicalView(), true));
            }
            Children.Array array2 = new Children.Array();
            array2.add(arrayList.toArray(new Node[0]));
            AbstractNode abstractNode = new AbstractNode((Children)array2);
            this.getExplorerManager().setRootContext((Node)abstractNode);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    boolean bl = arrayList.isEmpty();
                    AddDependencyPanel.this.tabPane.setEnabledAt(2, !bl);
                    if (bl) {
                        AddDependencyPanel.this.tabPane.setToolTipTextAt(1, NbBundle.getMessage(AddDependencyPanel.class, (String)"TXT_No_Opened"));
                    }
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DMListPanel
    extends JPanel
    implements ExplorerManager.Provider,
    AncestorListener,
    ActionListener,
    PropertyChangeListener,
    Runnable {
        private BeanTreeView btv;
        private ExplorerManager manager;
        private MavenProject project;
        private Node noDMRoot;
        private List<Dependency> dmDeps;

        public DMListPanel(MavenProject mavenProject) {
            this.project = mavenProject;
            this.btv = new BeanTreeView();
            this.btv.setRootVisible(false);
            this.btv.setDefaultActionAllowed(true);
            this.btv.setUseSubstringInQuickSearch(true);
            this.manager = new ExplorerManager();
            this.manager.addPropertyChangeListener((PropertyChangeListener)this);
            this.setLayout(new BorderLayout());
            this.add((Component)this.btv, "Center");
            this.addAncestorListener(this);
            AddDependencyPanel.this.artifactsLabel.setLabelFor((Component)this.btv);
            RequestProcessor.getDefault().post((Runnable)this);
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        private NBVersionInfo convert2VInfo(Dependency dependency) {
            return new NBVersionInfo(null, dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), null, null, null, dependency.getClassifier());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Dependency> getDMDeps() {
            Object object = DM_DEPS_LOCK;
            synchronized (object) {
                return this.dmDeps;
            }
        }

        private void loadArtifacts() {
            List<Dependency> list = this.getDMDeps();
            if (list == null || list.isEmpty()) {
                if (this.noDMRoot == null) {
                    AbstractNode abstractNode = new AbstractNode(Children.LEAF){

                        public Image getIcon(int n) {
                            return ImageUtilities.loadImage((String)"org/netbeans/modules/maven/resources/empty.png");
                        }

                        public Image getOpenedIcon(int n) {
                            return this.getIcon(n);
                        }
                    };
                    abstractNode.setName("Empty");
                    abstractNode.setDisplayName(NbBundle.getMessage(DMListPanel.class, (String)"LBL_DM_Empty"));
                    Children.Array array = new Children.Array();
                    array.add(new Node[]{abstractNode});
                    this.noDMRoot = new AbstractNode((Children)array);
                }
                this.manager.setRootContext(this.noDMRoot);
            } else {
                Children.Array array = new Children.Array();
                AbstractNode abstractNode = new AbstractNode((Children)array);
                for (Dependency dependency : list) {
                    array.add(new Node[]{AddDependencyPanel.this.createFilterWithDefaultAction((Node)MavenNodeFactory.createVersionNode(this.convert2VInfo(dependency), true), true)});
                }
                this.manager.setRootContext((Node)abstractNode);
            }
        }

        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            this.loadArtifacts();
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Node[] nodeArray = this.manager.getSelectedNodes();
            AddDependencyPanel.this.changeSelection(nodeArray.length == 1 ? nodeArray[0].getLookup() : Lookup.EMPTY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = DM_DEPS_LOCK;
            synchronized (object) {
                this.dmDeps = AddDependencyPanel.getDepencenciesFromDM(this.project);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    boolean bl = DMListPanel.this.dmDeps.isEmpty();
                    AddDependencyPanel.this.tabPane.setEnabledAt(1, !bl);
                    if (bl) {
                        AddDependencyPanel.this.tabPane.setToolTipTextAt(1, NbBundle.getMessage(AddDependencyPanel.class, (String)"TXT_No_DM"));
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueryPanel
    extends JPanel
    implements ExplorerManager.Provider,
    Comparator<String>,
    PropertyChangeListener,
    ChangeListener {
        private BeanTreeView btv = new BeanTreeView();
        private ExplorerManager manager;
        private String inProgressText;
        private String lastQueryText;
        private String curTypedText;
        private Color defSearchC;

        private QueryPanel() {
            this.btv.setRootVisible(false);
            this.btv.setDefaultActionAllowed(true);
            this.btv.setUseSubstringInQuickSearch(true);
            this.manager = new ExplorerManager();
            this.manager.setRootContext(AddDependencyPanel.getNoResultsRoot());
            this.setLayout(new BorderLayout());
            this.add((Component)this.btv, "Center");
            this.defSearchC = AddDependencyPanel.this.searchField.getForeground();
            this.manager.addPropertyChangeListener((PropertyChangeListener)this);
            AddDependencyPanel.this.resultsLabel.setLabelFor((Component)this.btv);
            this.btv.getAccessibleContext().setAccessibleDescription(AddDependencyPanel.this.resultsLabel.getAccessibleContext().getAccessibleDescription());
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Document document = (Document)changeEvent.getSource();
            try {
                this.curTypedText = document.getText(0, document.getLength()).trim();
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            AddDependencyPanel.this.searchField.setForeground(this.defSearchC);
            if (this.curTypedText.length() > 0) {
                this.find(this.curTypedText);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void find(String string) {
            final ArrayList<QueryField> arrayList = LOCK;
            synchronized (arrayList) {
                if (this.inProgressText != null) {
                    this.lastQueryText = string;
                    return;
                }
                this.inProgressText = string;
                this.lastQueryText = null;
            }
            AddDependencyPanel.this.setSearchInProgressUI(true);
            arrayList = new ArrayList<QueryField>();
            final ArrayList<QueryField> arrayList2 = new ArrayList<QueryField>();
            String string2 = string.trim();
            RequestProcessor.Task task = string2.split(" ");
            ArrayList<String> arrayList3 = new ArrayList<String>();
            arrayList3.add("groupId");
            arrayList3.add("artifactId");
            arrayList3.add("version");
            arrayList3.add("name");
            arrayList3.add("description");
            arrayList3.add("classes");
            for (String string3 : task) {
                for (String string4 : arrayList3) {
                    QueryField queryField = new QueryField();
                    queryField.setField(string4);
                    queryField.setValue(string3);
                    arrayList.add(queryField);
                    if ("classes".equals(string4)) continue;
                    arrayList2.add(queryField);
                }
            }
            RequestProcessor.Task task2 = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    List list = null;
                    boolean bl = false;
                    try {
                        list = RepositoryQueries.find((List)arrayList, (RepositoryInfo[])new RepositoryInfo[0]);
                    }
                    catch (BooleanQuery.TooManyClauses tooManyClauses) {
                        try {
                            list = RepositoryQueries.find((List)arrayList2, (RepositoryInfo[])new RepositoryInfo[0]);
                        }
                        catch (BooleanQuery.TooManyClauses tooManyClauses2) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    AddDependencyPanel.this.searchField.setForeground(Color.RED);
                                    AddDependencyPanel.this.nls.setWarningMessage(NbBundle.getMessage(AddDependencyPanel.class, (String)"MSG_TooGeneral"));
                                }
                            });
                            bl = true;
                        }
                    }
                    List list2 = list;
                    final boolean bl2 = bl;
                    final HashMap<String, ArrayList<NBVersionInfo>> hashMap = new HashMap<String, ArrayList<NBVersionInfo>>();
                    if (list2 != null) {
                        for (NBVersionInfo nBVersionInfo : list2) {
                            String string = nBVersionInfo.getGroupId() + AddDependencyPanel.DELIMITER + nBVersionInfo.getArtifactId();
                            ArrayList<NBVersionInfo> arrayList3 = (ArrayList<NBVersionInfo>)hashMap.get(string);
                            if (arrayList3 == null) {
                                arrayList3 = new ArrayList<NBVersionInfo>();
                                hashMap.put(string, arrayList3);
                            }
                            arrayList3.add(nBVersionInfo);
                        }
                    }
                    final ArrayList arrayList4 = new ArrayList(hashMap.keySet());
                    Collections.sort(arrayList4, QueryPanel.this);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            QueryPanel.this.manager.setRootContext(QueryPanel.this.createResultsNode(arrayList4, hashMap));
                            if (!bl2) {
                                AddDependencyPanel.this.searchField.setForeground(QueryPanel.this.defSearchC);
                                AddDependencyPanel.this.nls.clearMessages();
                            }
                        }
                    });
                }
            });
            task2.addTaskListener(new TaskListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void taskFinished(Task task) {
                    Object object = LOCK;
                    synchronized (object) {
                        String string = QueryPanel.this.inProgressText;
                        QueryPanel.this.inProgressText = null;
                        if (QueryPanel.this.lastQueryText != null && !QueryPanel.this.lastQueryText.equals(string)) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    if (QueryPanel.this.lastQueryText != null) {
                                        QueryPanel.this.find(QueryPanel.this.lastQueryText);
                                    }
                                }
                            });
                        } else {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    AddDependencyPanel.this.setSearchInProgressUI(false);
                                }
                            });
                        }
                    }
                }
            });
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        private Node createResultsNode(List<String> list, Map<String, List<NBVersionInfo>> map) {
            Node node;
            if (list.size() > 0) {
                Children.Array array = new Children.Array();
                node = new AbstractNode((Children)array);
                for (String string : list) {
                    array.add(new Node[]{AddDependencyPanel.this.createFilterWithDefaultAction((Node)MavenNodeFactory.createArtifactNode(string, map.get(string)), false)});
                }
            } else {
                node = AddDependencyPanel.getNoResultsRoot();
            }
            return node;
        }

        @Override
        public int compare(String string, String string2) {
            int n = string.indexOf(this.inProgressText);
            int n2 = string2.indexOf(this.inProgressText);
            if (n >= 0 || n2 >= 0) {
                if (n < 0) {
                    return 1;
                }
                if (n2 < 0) {
                    return -1;
                }
                return string.compareTo(string2);
            }
            return string.compareTo(string2);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                Node[] nodeArray = this.manager.getSelectedNodes();
                AddDependencyPanel.this.changeSelection(nodeArray.length == 1 ? nodeArray[0].getLookup() : Lookup.EMPTY);
            }
        }
    }
}

