/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class InstallDocSourcePanel
extends JPanel {
    private static File lastFolder = new File(System.getProperty("user.home"));
    private boolean docs;
    private JButton btnFile;
    private JLabel lblFile;
    private JTextField txtFile;

    private InstallDocSourcePanel(boolean bl) {
        this.initComponents();
        this.docs = bl;
        if (bl) {
            this.lblFile.setText(NbBundle.getMessage(InstallDocSourcePanel.class, (String)"TXT_Javadoc_Loc"));
        } else {
            this.lblFile.setText(NbBundle.getMessage(InstallDocSourcePanel.class, (String)"TXT_Sources_Loc"));
        }
    }

    boolean isJavadoc() {
        return this.docs;
    }

    private void initComponents() {
        this.lblFile = new JLabel();
        this.txtFile = new JTextField();
        this.btnFile = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.lblFile, (String)"Javadoc Location :");
        Mnemonics.setLocalizedText((AbstractButton)this.btnFile, (String)NbBundle.getMessage(InstallDocSourcePanel.class, (String)"BTN_Browse"));
        this.btnFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InstallDocSourcePanel.this.btnFileActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.lblFile).addPreferredGap(0).add((Component)this.txtFile, -1, 247, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnFile).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblFile).add((Component)this.btnFile).add((Component)this.txtFile, -2, -1, -2)).addContainerGap(36, Short.MAX_VALUE)));
    }

    private void btnFileActionPerformed(ActionEvent actionEvent) {
        int n;
        File file;
        JFileChooser jFileChooser = new JFileChooser(lastFolder);
        jFileChooser.setDialogTitle(this.isJavadoc() ? NbBundle.getMessage(InstallDocSourcePanel.class, (String)"TIT_Select_javadoc_zip") : NbBundle.getMessage(InstallDocSourcePanel.class, (String)"TIT_Select_source_zip"));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".jar") || file.getName().toLowerCase().endsWith(".zip");
            }

            public String getDescription() {
                return InstallDocSourcePanel.this.isJavadoc() ? NbBundle.getMessage(InstallDocSourcePanel.class, (String)"LBL_Select_javadoc_zip") : NbBundle.getMessage(InstallDocSourcePanel.class, (String)"LBL_Select_source_zip");
            }
        });
        jFileChooser.setMultiSelectionEnabled(false);
        if (this.txtFile.getText().trim().length() > 0 && (file = new File(this.txtFile.getText().trim())).exists()) {
            jFileChooser.setSelectedFile(file);
        }
        if ((n = jFileChooser.showDialog(SwingUtilities.getWindowAncestor(this), NbBundle.getMessage(InstallDocSourcePanel.class, (String)"BTN_Select"))) == 0) {
            this.txtFile.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            this.txtFile.requestFocusInWindow();
        }
    }

    File getFile() {
        File file = this.txtFile.getText().trim().length() > 0 ? new File(this.txtFile.getText().trim()) : null;
        return file != null && file.exists() ? file : null;
    }

    public static File showInstallDialog(boolean bl) {
        final InstallDocSourcePanel installDocSourcePanel = new InstallDocSourcePanel(bl);
        final JButton jButton = new JButton(NbBundle.getMessage(InstallDocSourcePanel.class, (String)"BTN_Select"));
        jButton.setEnabled(installDocSourcePanel.getFile() != null);
        installDocSourcePanel.addDocListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                jButton.setEnabled(installDocSourcePanel.getFile() != null);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                jButton.setEnabled(installDocSourcePanel.getFile() != null);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                jButton.setEnabled(installDocSourcePanel.getFile() != null);
            }
        });
        Object[] objectArray = new Object[]{jButton, NotifyDescriptor.CANCEL_OPTION};
        String string = installDocSourcePanel.isJavadoc() ? NbBundle.getMessage(InstallDocSourcePanel.class, (String)"TIT_Use_local_docs") : NbBundle.getMessage(InstallDocSourcePanel.class, (String)"TIT_Use_local_source");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)installDocSourcePanel, string, true, objectArray, (Object)jButton, 0, HelpCtx.DEFAULT_HELP, null);
        dialogDescriptor.setClosingOptions(objectArray);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object == jButton) {
            lastFolder = installDocSourcePanel.getFile().getParentFile();
            return installDocSourcePanel.getFile();
        }
        return null;
    }

    private void addDocListener(DocumentListener documentListener) {
        this.txtFile.getDocument().addDocumentListener(documentListener);
    }
}

