/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.embedder.MavenSettingsSingleton;
import org.netbeans.modules.maven.nodes.AnnotatedAbstractNode;
import org.netbeans.modules.maven.nodes.OthersRootNode;
import org.netbeans.modules.maven.spi.nodes.NodeUtils;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class ProjectFilesNode
extends AnnotatedAbstractNode {
    private NbMavenProjectImpl project;

    public ProjectFilesNode(NbMavenProjectImpl nbMavenProjectImpl) {
        super((Children)new ProjectFilesChildren(nbMavenProjectImpl), Lookups.fixed((Object[])new Object[]{nbMavenProjectImpl.getProjectDirectory(), new OthersRootNode.ChildDelegateFind()}));
        this.setName("projectfiles");
        this.setDisplayName(NbBundle.getMessage(ProjectFilesNode.class, (String)"LBL_Project_Files"));
        this.project = nbMavenProjectImpl;
        this.setMyFiles();
    }

    public Action[] getActions(boolean bl) {
        ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
        if (this.project.getProjectDirectory().getFileObject("profiles.xml") == null) {
            arrayList.add(new AddProfileXmlAction());
        }
        if (!new File(MavenSettingsSingleton.getInstance().getM2UserDir(), "settings.xml").exists()) {
            arrayList.add(new AddSettingsXmlAction());
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private Image getIcon(boolean bl) {
        Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/projectfiles-badge.png", (boolean)true);
        Image image2 = ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon(bl), (Image)image, (int)8, (int)8);
        return image2;
    }

    protected Image getIconImpl(int n) {
        return this.getIcon(false);
    }

    protected Image getOpenedIconImpl(int n) {
        return this.getIcon(true);
    }

    private void setMyFiles() {
        FileObject fileObject;
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        FileObject fileObject2 = this.project.getProjectDirectory().getFileObject("pom.xml");
        if (fileObject2 != null) {
            hashSet.add(fileObject2);
        }
        if ((fileObject = this.project.getProjectDirectory().getFileObject("profiles.xml")) != null) {
            hashSet.add(fileObject);
        }
        this.setFiles(hashSet);
    }

    private class AddSettingsXmlAction
    extends AbstractAction {
        AddSettingsXmlAction() {
            this.putValue("Name", NbBundle.getMessage(ProjectFilesNode.class, (String)"BTN_Create_settings_xml"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                File file = MavenSettingsSingleton.getInstance().getM2UserDir();
                DataFolder dataFolder = DataFolder.findFolder((FileObject)FileUtil.createFolder((File)file));
                FileObject fileObject = FileUtil.getConfigFile((String)"Maven2Templates/settings.xml");
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                DataObject dataObject2 = dataObject.createFromTemplate(dataFolder);
                EditCookie editCookie = (EditCookie)dataObject2.getCookie(EditCookie.class);
                if (editCookie != null) {
                    editCookie.edit();
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                dataObjectNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private class AddProfileXmlAction
    extends AbstractAction {
        AddProfileXmlAction() {
            this.putValue("Name", NbBundle.getMessage(ProjectFilesNode.class, (String)"BTN_Create_profile_xml"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DataFolder dataFolder = DataFolder.findFolder((FileObject)ProjectFilesNode.this.project.getProjectDirectory());
                FileObject fileObject = FileUtil.getConfigFile((String)"Maven2Templates/profiles.xml");
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                DataObject dataObject2 = dataObject.createFromTemplate(dataFolder);
                EditCookie editCookie = (EditCookie)dataObject2.getCookie(EditCookie.class);
                if (editCookie != null) {
                    editCookie.edit();
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                dataObjectNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProjectFilesChildren
    extends Children.Keys<File>
    implements PropertyChangeListener {
        private NbMavenProjectImpl project;
        private FileChangeAdapter fileChangeListener;

        public ProjectFilesChildren(NbMavenProjectImpl nbMavenProjectImpl) {
            this.project = nbMavenProjectImpl;
            this.fileChangeListener = new FileChangeAdapter(){

                public void fileDataCreated(FileEvent fileEvent) {
                    ProjectFilesChildren.this.regenerateKeys(true);
                }

                public void fileDeleted(FileEvent fileEvent) {
                    ProjectFilesChildren.this.regenerateKeys(true);
                }
            };
        }

        protected Node[] createNodes(File file) {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject != null) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    FilterNode filterNode = new FilterNode(dataObject.getNodeDelegate().cloneNode());
                    return new Node[]{filterNode};
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
            return new Node[0];
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
                this.regenerateKeys(true);
            }
        }

        protected void addNotify() {
            super.addNotify();
            NbMavenProject.addPropertyChangeListener(this.project, this);
            this.project.getProjectDirectory().addFileChangeListener((FileChangeListener)this.fileChangeListener);
            this.regenerateKeys(false);
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            NbMavenProject.removePropertyChangeListener(this.project, this);
            this.project.getProjectDirectory().removeFileChangeListener((FileChangeListener)this.fileChangeListener);
            super.removeNotify();
        }

        private void regenerateKeys(final boolean bl) {
            if (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        ProjectFilesChildren.this.regenerateKeys(bl);
                    }
                });
                return;
            }
            ArrayList<File> arrayList = new ArrayList<File>();
            arrayList.add(new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), "pom.xml"));
            arrayList.add(new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), "profiles.xml"));
            arrayList.add(new File(MavenSettingsSingleton.getInstance().getM2UserDir(), "settings.xml"));
            this.setKeys(arrayList);
            ((ProjectFilesNode)this.getNode()).setMyFiles();
            if (bl) {
                for (File file : arrayList) {
                    this.refreshKey(file);
                }
            }
        }
    }
}

