/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.output;

import java.io.File;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class JavadocOutputProcessor
implements OutputProcessor {
    private static final String[] JAVADOCGOALS = new String[]{"mojo-execute#javadoc:javadoc"};
    private Pattern index = Pattern.compile("Generating (.*)index\\.html.*", 32);
    private String path;

    public String[] getRegisteredOutputSequences() {
        return JAVADOCGOALS;
    }

    public void processLine(String string, OutputVisitor outputVisitor) {
        Matcher matcher = this.index.matcher(string);
        if (matcher.matches()) {
            this.path = matcher.group(1);
        }
    }

    public void sequenceStart(String string, OutputVisitor outputVisitor) {
        this.path = null;
    }

    public void sequenceEnd(String string, OutputVisitor outputVisitor) {
        if (this.path != null) {
            outputVisitor.setLine("View Generated javadoc at " + this.path);
            outputVisitor.setOutputListener(new Listener(this.path), false);
        }
    }

    public void sequenceFail(String string, OutputVisitor outputVisitor) {
    }

    private static class Listener
    implements OutputListener {
        private String root;

        private Listener(String string) {
            this.root = string;
        }

        public void outputLineSelected(OutputEvent outputEvent) {
        }

        public void outputLineAction(OutputEvent outputEvent) {
            FileObject fileObject;
            File file = FileUtil.normalizeFile((File)new File(this.root));
            FileUtil.refreshFor((File[])new File[]{file});
            FileObject fileObject2 = FileUtil.toFileObject((File)file);
            if (fileObject2 != null && (fileObject = fileObject2.getFileObject("index.html")) != null) {
                URL uRL = URLMapper.findURL((FileObject)fileObject, (int)1);
                HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
            }
        }

        public void outputLineCleared(OutputEvent outputEvent) {
        }
    }
}

