/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.output;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.netbeans.modules.maven.output.CompileAnnotation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class ScalaOutputListenerProvider
implements OutputProcessor {
    private static final String[] SCALAGOALS = new String[]{"mojo-execute#scala:compile", "mojo-execute#scala:testCompile"};
    private Pattern failPattern = Pattern.compile("\\s*(?:\\[WARNING\\])?\\s*(.*)\\.scala\\:([0-9]*)\\:(.*)", 32);

    public void processLine(String string, OutputVisitor outputVisitor) {
        Matcher matcher = this.failPattern.matcher(string);
        if (matcher.matches()) {
            Sources sources;
            Project project;
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = matcher.group(3);
            File file = FileUtil.normalizeFile((File)new File(string2 + ".scala"));
            outputVisitor.setOutputListener(new CompileAnnotation(file, string3, string4), true);
            FileUtil.refreshFor((File[])new File[]{file});
            FileObject fileObject = FileUtil.toFileObject((File)file);
            String string5 = string2;
            if (fileObject != null && (project = FileOwnerQuery.getOwner((FileObject)fileObject)) != null && (sources = (Sources)project.getLookup().lookup(Sources.class)) != null) {
                for (SourceGroup sourceGroup : sources.getSourceGroups("scala")) {
                    if (!FileUtil.isParentOf((FileObject)sourceGroup.getRootFolder(), (FileObject)fileObject) || !(string5 = FileUtil.getRelativePath((FileObject)sourceGroup.getRootFolder(), (FileObject)fileObject)).endsWith(".scala")) continue;
                    string5 = string5.substring(0, string5.length() - ".scala".length());
                }
            }
            string = string.replace(string2, string5);
            outputVisitor.setLine(string);
        }
    }

    public String[] getRegisteredOutputSequences() {
        return SCALAGOALS;
    }

    public void sequenceStart(String string, OutputVisitor outputVisitor) {
    }

    public void sequenceEnd(String string, OutputVisitor outputVisitor) {
    }

    public void sequenceFail(String string, OutputVisitor outputVisitor) {
    }
}

