/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.classpath.ClassPathProviderImpl;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;

public class MavenFileLocator
implements LineConvertors.FileLocator {
    private ClassPath classpath;
    private final Project project;
    private static final Object LOCK = new Object();

    public MavenFileLocator(Project project) {
        this.project = project;
        NbMavenProject.addPropertyChangeListener(project, new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = LOCK;
                synchronized (object) {
                    MavenFileLocator.this.classpath = null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject find(String string) {
        ClassPath classPath;
        if (string == null) {
            return null;
        }
        Object object = LOCK;
        synchronized (object) {
            if (this.classpath == null) {
                this.classpath = this.getProjectClasspath(this.project);
            }
            classPath = this.classpath;
        }
        return classPath.findResource(string);
    }

    private ClassPath getProjectClasspath(Project project) {
        Object object;
        ClassPath classPath = null;
        ClassPathProviderImpl classPathProviderImpl = (ClassPathProviderImpl)project.getLookup().lookup(ClassPathProviderImpl.class);
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        Sources sources = ProjectUtils.getSources((Project)project);
        if (sources != null) {
            for (FileObject[] fileObjectArray : object = sources.getSourceGroups("java")) {
                hashSet.add(fileObjectArray.getRootFolder());
            }
        }
        object = new HashSet();
        if (classPathProviderImpl != null) {
            for (FileObject fileObject : hashSet) {
                ClassPath classPath2 = classPathProviderImpl.findClassPath(fileObject, "classpath/compile");
                object.add(classPath2);
            }
        }
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            FileObject[] fileObjectArray;
            ClassPath classPath3 = (ClassPath)object2.next();
            for (FileObject fileObject : fileObjectArray = classPath3.getRoots()) {
                try {
                    FileObject[] fileObjectArray2 = SourceForBinaryQuery.findSourceRoots((URL)fileObject.getURL()).getRoots();
                    hashSet.addAll(Arrays.asList(fileObjectArray2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        object2 = classPathProviderImpl.getJavaPlatform();
        if (object2 != null) {
            hashSet.addAll(Arrays.asList(object2.getSourceFolders().getRoots()));
        }
        classPath = ClassPathSupport.createClassPath((FileObject[])hashSet.toArray(new FileObject[hashSet.size()]));
        return classPath;
    }
}

