/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.indentation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.options.editor.spi.PreviewProvider;
import org.netbeans.modules.options.indentation.CustomizerSelector;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class IndentationPanel
extends JPanel
implements ChangeListener,
ActionListener,
PreferenceChangeListener {
    private static final Logger LOG = Logger.getLogger(IndentationPanel.class.getName());
    private final MimePath mimePath;
    private final CustomizerSelector.PreferencesFactory prefsFactory;
    private final Preferences allLangPrefs;
    private final Preferences prefs;
    private final PreviewProvider preview;
    private final boolean showOverrideGlobalOptions;
    private JCheckBox cbExpandTabsToSpaces;
    private JCheckBox cbOverrideGlobalOptions;
    private JPanel jPanel1;
    private JLabel lNumberOfSpacesPerIndent;
    private JLabel lRightMargin;
    private JLabel lTabSize;
    private JSpinner sNumberOfSpacesPerIndent;
    private JSpinner sRightMargin;
    private JSpinner sTabSize;

    public IndentationPanel(MimePath mimePath, CustomizerSelector.PreferencesFactory preferencesFactory, Preferences preferences, Preferences preferences2, PreviewProvider previewProvider) {
        this.mimePath = mimePath;
        this.prefsFactory = preferencesFactory;
        this.prefs = preferences;
        this.prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)preferences));
        this.allLangPrefs = preferences2;
        if (this.allLangPrefs == null) {
            PreviewProvider previewProvider2;
            assert (previewProvider == null);
            assert (mimePath == MimePath.EMPTY);
            try {
                previewProvider2 = new TextPreview(preferences, "text/xml", this.getClass().getClassLoader(), "org/netbeans/modules/options/indentation/indentationExample");
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, null, iOException);
                previewProvider2 = new NoPreview();
            }
            this.preview = previewProvider2;
            this.showOverrideGlobalOptions = false;
        } else {
            assert (previewProvider != null);
            assert (mimePath != MimePath.EMPTY);
            this.preview = previewProvider;
            this.showOverrideGlobalOptions = true;
            this.allLangPrefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)this.allLangPrefs));
        }
        this.initComponents();
        this.cbOverrideGlobalOptions.setVisible(this.showOverrideGlobalOptions);
        IndentationPanel.loc(this.cbOverrideGlobalOptions, "Override_Global_Options");
        IndentationPanel.loc(this.lNumberOfSpacesPerIndent, "Indent");
        IndentationPanel.loc(this.lTabSize, "TabSize");
        IndentationPanel.loc(this.cbExpandTabsToSpaces, "Expand_Tabs");
        IndentationPanel.loc(this.lRightMargin, "Right_Margin");
        this.cbExpandTabsToSpaces.getAccessibleContext().setAccessibleName(IndentationPanel.loc("AN_Expand_Tabs"));
        this.cbExpandTabsToSpaces.getAccessibleContext().setAccessibleDescription(IndentationPanel.loc("AD_Expand_Tabs"));
        this.cbOverrideGlobalOptions.addActionListener(this);
        this.cbExpandTabsToSpaces.addActionListener(this);
        this.sNumberOfSpacesPerIndent.setModel(new SpinnerNumberModel(4, 1, 50, 1));
        this.sNumberOfSpacesPerIndent.addChangeListener(this);
        this.sTabSize.setModel(new SpinnerNumberModel(4, 1, 50, 1));
        this.sTabSize.addChangeListener(this);
        this.sRightMargin.setModel(new SpinnerNumberModel(120, 1, 200, 10));
        this.sRightMargin.addChangeListener(this);
        this.prefsChange(null);
        if (this.showOverrideGlobalOptions && null == this.prefs.get("FormattingPanelController.OVERRIDE_GLOBAL_FORMATTING_OPTIONS", null)) {
            this.prefs.putBoolean("FormattingPanelController.OVERRIDE_GLOBAL_FORMATTING_OPTIONS", this.areBasicOptionsOverriden());
        }
    }

    public PreviewProvider getPreviewProvider() {
        return this.preview;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.sNumberOfSpacesPerIndent == changeEvent.getSource()) {
            this.prefs.putInt("indent-shift-width", (Integer)this.sNumberOfSpacesPerIndent.getValue());
            this.prefs.putInt("spaces-per-tab", (Integer)this.sNumberOfSpacesPerIndent.getValue());
        } else if (this.sTabSize == changeEvent.getSource()) {
            this.prefs.putInt("tab-size", (Integer)this.sTabSize.getValue());
        } else if (this.sRightMargin == changeEvent.getSource()) {
            this.prefs.putInt("text-limit-width", (Integer)this.sRightMargin.getValue());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.cbOverrideGlobalOptions == actionEvent.getSource()) {
            this.prefs.putBoolean("FormattingPanelController.OVERRIDE_GLOBAL_FORMATTING_OPTIONS", this.cbOverrideGlobalOptions.isSelected());
        } else if (this.cbExpandTabsToSpaces == actionEvent.getSource()) {
            this.prefs.putBoolean("expand-tabs", this.cbExpandTabsToSpaces.isSelected());
        }
    }

    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getSource() == this.prefs) {
            this.prefsChange(preferenceChangeEvent);
        } else if (preferenceChangeEvent.getSource() == this.allLangPrefs) {
            this.allLangPrefsChange(preferenceChangeEvent);
        } else assert (false);
    }

    private void prefsChange(PreferenceChangeEvent preferenceChangeEvent) {
        int n;
        String string = preferenceChangeEvent == null ? null : preferenceChangeEvent.getKey();
        boolean bl = false;
        if (string == null || "expand-tabs".equals(string)) {
            n = this.prefs.getBoolean("expand-tabs", this.getDefBoolean("expand-tabs", true));
            if (n != this.cbExpandTabsToSpaces.isSelected()) {
                this.cbExpandTabsToSpaces.setSelected(n != 0);
            }
            bl = true;
        }
        if (string == null || "indent-shift-width".equals(string)) {
            n = this.prefs.getInt("indent-shift-width", this.getDefInt("indent-shift-width", 4));
            if (n != (Integer)this.sNumberOfSpacesPerIndent.getValue()) {
                this.sNumberOfSpacesPerIndent.setValue(n);
            }
            bl = true;
        }
        if ((string == null || "spaces-per-tab".equals(string)) && this.prefs.get("indent-shift-width", null) == null) {
            n = this.prefs.getInt("spaces-per-tab", this.getDefInt("spaces-per-tab", 4));
            if (n != (Integer)this.sNumberOfSpacesPerIndent.getValue()) {
                this.sNumberOfSpacesPerIndent.setValue(n);
            }
            bl = true;
        }
        if (string == null || "tab-size".equals(string)) {
            n = this.prefs.getInt("tab-size", this.getDefInt("tab-size", 8));
            if (n != (Integer)this.sTabSize.getValue()) {
                this.sTabSize.setValue(n);
            }
            bl = true;
        }
        if (string == null || "text-limit-width".equals(string)) {
            n = this.prefs.getInt("text-limit-width", this.getDefInt("text-limit-width", 80));
            if (n != (Integer)this.sRightMargin.getValue()) {
                this.sRightMargin.setValue(n);
            }
            bl = true;
        }
        if (this.showOverrideGlobalOptions && (string == null || "FormattingPanelController.OVERRIDE_GLOBAL_FORMATTING_OPTIONS".equals(string))) {
            n = this.prefs.getBoolean("FormattingPanelController.OVERRIDE_GLOBAL_FORMATTING_OPTIONS", this.areBasicOptionsOverriden()) ? 1 : 0;
            if (n != this.cbOverrideGlobalOptions.isSelected()) {
                this.cbOverrideGlobalOptions.setSelected(n != 0);
            }
            if (!n) {
                this.prefs.putBoolean("expand-tabs", this.allLangPrefs.getBoolean("expand-tabs", true));
                this.prefs.putInt("indent-shift-width", this.allLangPrefs.getInt("indent-shift-width", 4));
                this.prefs.putInt("spaces-per-tab", this.allLangPrefs.getInt("spaces-per-tab", 4));
                this.prefs.putInt("tab-size", this.allLangPrefs.getInt("tab-size", 4));
                this.prefs.putInt("text-limit-width", this.allLangPrefs.getInt("text-limit-width", 80));
            }
            bl = true;
            ((ControlledCheckBox)this.cbExpandTabsToSpaces).setEnabledInternal(n != 0);
            ((ControlledLabel)this.lNumberOfSpacesPerIndent).setEnabledInternal(n != 0);
            ((ControlledSpinner)this.sNumberOfSpacesPerIndent).setEnabledInternal(n != 0);
            ((ControlledLabel)this.lTabSize).setEnabledInternal(n != 0);
            ((ControlledSpinner)this.sTabSize).setEnabledInternal(n != 0);
            ((ControlledLabel)this.lRightMargin).setEnabledInternal(n != 0);
            ((ControlledSpinner)this.sRightMargin).setEnabledInternal(n != 0);
        }
        if (bl) {
            this.preview.refreshPreview();
        }
    }

    private void allLangPrefsChange(PreferenceChangeEvent preferenceChangeEvent) {
        String string;
        String string2 = string = preferenceChangeEvent == null ? null : preferenceChangeEvent.getKey();
        if (this.prefs.getBoolean("FormattingPanelController.OVERRIDE_GLOBAL_FORMATTING_OPTIONS", this.areBasicOptionsOverriden())) {
            return;
        }
        if (string == null || "expand-tabs".equals(string)) {
            this.prefs.putBoolean("expand-tabs", this.allLangPrefs.getBoolean("expand-tabs", true));
        }
        if (string == null || "indent-shift-width".equals(string)) {
            this.prefs.putInt("indent-shift-width", this.allLangPrefs.getInt("indent-shift-width", 4));
        }
        if (string == null || "spaces-per-tab".equals(string)) {
            this.prefs.putInt("spaces-per-tab", this.allLangPrefs.getInt("spaces-per-tab", 4));
        }
        if (string == null || "tab-size".equals(string)) {
            this.prefs.putInt("tab-size", this.allLangPrefs.getInt("tab-size", 4));
        }
        if (string == null || "text-limit-width".equals(string)) {
            this.prefs.putInt("text-limit-width", this.allLangPrefs.getInt("text-limit-width", 80));
        }
    }

    private void initComponents() {
        this.cbOverrideGlobalOptions = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.cbExpandTabsToSpaces = new ControlledCheckBox();
        this.lNumberOfSpacesPerIndent = new ControlledLabel();
        this.sNumberOfSpacesPerIndent = new ControlledSpinner();
        this.lTabSize = new ControlledLabel();
        this.sTabSize = new ControlledSpinner();
        this.lRightMargin = new ControlledLabel();
        this.sRightMargin = new ControlledSpinner();
        this.setOpaque(false);
        Mnemonics.setLocalizedText((AbstractButton)this.cbOverrideGlobalOptions, (String)NbBundle.getMessage(IndentationPanel.class, (String)"CTL_Override_Global_Options"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbExpandTabsToSpaces, (String)NbBundle.getMessage(IndentationPanel.class, (String)"CTL_Expand_Tabs"));
        this.lNumberOfSpacesPerIndent.setLabelFor(this.sNumberOfSpacesPerIndent);
        Mnemonics.setLocalizedText((JLabel)this.lNumberOfSpacesPerIndent, (String)NbBundle.getMessage(IndentationPanel.class, (String)"CTL_Indent"));
        this.lTabSize.setLabelFor(this.sTabSize);
        Mnemonics.setLocalizedText((JLabel)this.lTabSize, (String)NbBundle.getMessage(IndentationPanel.class, (String)"CTL_TabSize"));
        this.lRightMargin.setLabelFor(this.sRightMargin);
        Mnemonics.setLocalizedText((JLabel)this.lRightMargin, (String)NbBundle.getMessage(IndentationPanel.class, (String)"CTL_Right_Margin"));
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.cbExpandTabsToSpaces, -1, 231, Short.MAX_VALUE).add(54, 54, 54)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lNumberOfSpacesPerIndent, -1, 233, Short.MAX_VALUE).add((Component)this.lRightMargin, -1, 233, Short.MAX_VALUE).add(2, (Component)this.lTabSize, -1, 233, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.sNumberOfSpacesPerIndent, -1, 42, Short.MAX_VALUE).add((Component)this.sTabSize, -1, 42, Short.MAX_VALUE).add((Component)this.sRightMargin, -1, 42, Short.MAX_VALUE))))));
        groupLayout.linkSize(new Component[]{this.sNumberOfSpacesPerIndent, this.sRightMargin, this.sTabSize}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.cbExpandTabsToSpaces, -2, 19, -2).add(63, 63, 63)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap(25, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.sNumberOfSpacesPerIndent, -2, -1, -2).add((Component)this.lNumberOfSpacesPerIndent)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.sTabSize, -2, -1, -2).add((Component)this.lTabSize)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.sRightMargin, -2, -1, -2).add((Component)this.lRightMargin))));
        groupLayout.linkSize(new Component[]{this.sNumberOfSpacesPerIndent, this.sRightMargin, this.sTabSize}, 2);
        this.cbExpandTabsToSpaces.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IndentationPanel.class, (String)"AD_Expand_Tabs"));
        this.lNumberOfSpacesPerIndent.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IndentationPanel.class, (String)"AN_Indent"));
        this.lNumberOfSpacesPerIndent.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IndentationPanel.class, (String)"AD_Indent"));
        this.sNumberOfSpacesPerIndent.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IndentationPanel.class, (String)"AN_sNumberOfSpacesPerIndent"));
        this.sNumberOfSpacesPerIndent.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IndentationPanel.class, (String)"AD_sNumberOfSpacesPerIndent"));
        this.lTabSize.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IndentationPanel.class, (String)"AN_TabSize"));
        this.lTabSize.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IndentationPanel.class, (String)"AD_TabSize"));
        this.sTabSize.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IndentationPanel.class, (String)"AN_sTabSize"));
        this.sTabSize.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IndentationPanel.class, (String)"AD_sTabSize"));
        this.lRightMargin.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IndentationPanel.class, (String)"AN_Right_Margin"));
        this.lRightMargin.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IndentationPanel.class, (String)"AD_Right_Margin"));
        this.sRightMargin.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IndentationPanel.class, (String)"AN_sRightMargin"));
        this.sRightMargin.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IndentationPanel.class, (String)"AD_sRightMargin"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.cbOverrideGlobalOptions, -1, 239, Short.MAX_VALUE).add(66, 66, 66)).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.cbOverrideGlobalOptions).addPreferredGap(1).add((Component)this.jPanel1, -2, -1, -2)));
        this.cbOverrideGlobalOptions.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IndentationPanel.class, (String)"AN_Override_Global_Options"));
        this.cbOverrideGlobalOptions.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IndentationPanel.class, (String)"AD_Override_Global_Options"));
    }

    private static String loc(String string) {
        return NbBundle.getMessage(IndentationPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (!(component instanceof JLabel)) {
            component.getAccessibleContext().setAccessibleName(IndentationPanel.loc("AN_" + string));
            component.getAccessibleContext().setAccessibleDescription(IndentationPanel.loc("AD_" + string));
        }
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)IndentationPanel.loc("CTL_" + string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)IndentationPanel.loc("CTL_" + string));
        }
    }

    private boolean areBasicOptionsOverriden() {
        String string = this.mimePath.getPath();
        return this.prefsFactory.isKeyOverridenForMimeType("expand-tabs", string) || this.prefsFactory.isKeyOverridenForMimeType("indent-shift-width", string) || this.prefsFactory.isKeyOverridenForMimeType("spaces-per-tab", string) || this.prefsFactory.isKeyOverridenForMimeType("tab-size", string) || this.prefsFactory.isKeyOverridenForMimeType("text-limit-width", string);
    }

    private boolean getDefBoolean(String string, boolean bl) {
        return this.allLangPrefs != null ? this.allLangPrefs.getBoolean(string, bl) : bl;
    }

    private int getDefInt(String string, int n) {
        return this.allLangPrefs != null ? this.allLangPrefs.getInt(string, n) : n;
    }

    private static String s2s(Object object) {
        return object == null ? "null" : object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object));
    }

    private static final class ControlledSpinner
    extends JSpinner {
        private boolean externallyEnabled = true;
        private boolean internallyEnabled = true;

        private ControlledSpinner() {
        }

        public void setEnabled(boolean bl) {
            if (this.externallyEnabled == bl) {
                return;
            }
            this.externallyEnabled = bl;
            if (this.externallyEnabled) {
                if (this.internallyEnabled) {
                    super.setEnabled(true);
                }
            } else {
                super.setEnabled(false);
            }
        }

        public void setEnabledInternal(boolean bl) {
            if (this.internallyEnabled == bl) {
                return;
            }
            this.internallyEnabled = bl;
            if (this.internallyEnabled) {
                if (this.externallyEnabled) {
                    super.setEnabled(true);
                }
            } else {
                super.setEnabled(false);
            }
        }
    }

    private static final class ControlledLabel
    extends JLabel {
        private boolean externallyEnabled = true;
        private boolean internallyEnabled = true;

        private ControlledLabel() {
        }

        public void setEnabled(boolean bl) {
            if (this.externallyEnabled == bl) {
                return;
            }
            this.externallyEnabled = bl;
            if (this.externallyEnabled) {
                if (this.internallyEnabled) {
                    super.setEnabled(true);
                }
            } else {
                super.setEnabled(false);
            }
        }

        public void setEnabledInternal(boolean bl) {
            if (this.internallyEnabled == bl) {
                return;
            }
            this.internallyEnabled = bl;
            if (this.internallyEnabled) {
                if (this.externallyEnabled) {
                    super.setEnabled(true);
                }
            } else {
                super.setEnabled(false);
            }
        }
    }

    private static final class ControlledCheckBox
    extends JCheckBox {
        private boolean externallyEnabled = true;
        private boolean internallyEnabled = true;

        private ControlledCheckBox() {
        }

        public void setEnabled(boolean bl) {
            if (this.externallyEnabled == bl) {
                return;
            }
            this.externallyEnabled = bl;
            if (this.externallyEnabled) {
                if (this.internallyEnabled) {
                    super.setEnabled(true);
                }
            } else {
                super.setEnabled(false);
            }
        }

        public void setEnabledInternal(boolean bl) {
            if (this.internallyEnabled == bl) {
                return;
            }
            this.internallyEnabled = bl;
            if (this.internallyEnabled) {
                if (this.externallyEnabled) {
                    super.setEnabled(true);
                }
            } else {
                super.setEnabled(false);
            }
        }
    }

    public static final class NoPreview
    implements PreviewProvider {
        private JComponent component = null;

        public JComponent getPreviewComponent() {
            if (this.component == null) {
                JLabel jLabel = new JLabel(NbBundle.getMessage(IndentationPanel.class, (String)"MSG_no_preview_available"));
                jLabel.setOpaque(true);
                jLabel.setHorizontalAlignment(0);
                jLabel.setBorder(new EmptyBorder(new Insets(11, 11, 11, 11)));
                jLabel.setVisible(true);
                this.component = new JPanel(new BorderLayout());
                this.component.add((Component)jLabel, "Center");
            }
            return this.component;
        }

        public void refreshPreview() {
        }
    }

    public static final class TextPreview
    implements PreviewProvider {
        private final Preferences prefs;
        private final String mimeType;
        private final String previewText;
        private JEditorPane jep;

        public TextPreview(Preferences preferences, FileObject fileObject) throws IOException {
            this(preferences, fileObject.getMIMEType(), TextPreview.loadPreviewText(fileObject.getInputStream()));
        }

        public TextPreview(Preferences preferences, String string, FileObject fileObject) throws IOException {
            this(preferences, string, TextPreview.loadPreviewText(fileObject.getInputStream()));
        }

        public TextPreview(Preferences preferences, String string, String string2) {
            this.prefs = preferences;
            this.mimeType = string;
            this.previewText = string2;
        }

        public TextPreview(Preferences preferences, String string, ClassLoader classLoader, String string2) throws IOException {
            this(preferences, string, TextPreview.loadPreviewText(classLoader.getResourceAsStream(string2)));
        }

        public TextPreview(Preferences preferences, String string, Class clazz, String string2) {
            this(preferences, string, NbBundle.getMessage((Class)clazz, (String)string2));
        }

        public JComponent getPreviewComponent() {
            if (this.jep == null) {
                this.jep = new JEditorPane();
                this.jep.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IndentationPanel.class, (String)"AN_Preview"));
                this.jep.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IndentationPanel.class, (String)"AD_Preview"));
                this.jep.putClientProperty("HighlightsLayerIncludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.SyntaxHighlighting$");
                this.jep.setEditorKit(CloneableEditorSupport.getEditorKit((String)this.mimeType));
                this.jep.setEditable(false);
            }
            return this.jep;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshPreview() {
            JEditorPane jEditorPane = (JEditorPane)this.getPreviewComponent();
            jEditorPane.setText(this.previewText);
            final Document document = jEditorPane.getDocument();
            if (document instanceof BaseDocument) {
                final Reformat reformat = Reformat.get((Document)document);
                reformat.lock();
                try {
                    ((BaseDocument)document).runAtomic(new Runnable(){

                        public void run() {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("Refreshing preview: expandTabs=" + IndentUtils.isExpandTabs((Document)document) + ", indentLevelSize=" + IndentUtils.indentLevelSize((Document)document) + ", tabSize=" + IndentUtils.tabSize((Document)document) + ", mimeType='" + document.getProperty("mimeType") + "'" + ", doc=" + IndentationPanel.s2s(document));
                            }
                            try {
                                reformat.reformat(0, document.getLength());
                            }
                            catch (BadLocationException badLocationException) {
                                LOG.log(Level.WARNING, null, badLocationException);
                            }
                        }
                    });
                }
                finally {
                    reformat.unlock();
                }
            } else {
                LOG.warning("Can't format " + document + "; it's not BaseDocument.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String loadPreviewText(InputStream inputStream) throws IOException {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                StringBuilder stringBuilder = new StringBuilder();
                String string = bufferedReader.readLine();
                while (string != null) {
                    stringBuilder.append(string).append('\n');
                    string = bufferedReader.readLine();
                }
                string = stringBuilder.toString();
                return string;
            }
            finally {
                bufferedReader.close();
            }
        }
    }
}

