/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Variable;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.InstantRenamer;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.VariableScopeVisitor;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyInstantRenamer
implements InstantRenamer {
    private final Logger LOG = Logger.getLogger(GroovyInstantRenamer.class.getName());

    public boolean isRenameAllowed(ParserResult parserResult, int n, String[] stringArray) {
        this.LOG.log(Level.FINEST, "isRenameAllowed()");
        AstPath astPath = this.getPathUnderCaret(AstUtilities.getParseResult((Parser.Result)parserResult), n);
        if (astPath != null) {
            ASTNode aSTNode = astPath.leaf();
            if (aSTNode instanceof Variable) {
                return true;
            }
            stringArray[0] = NbBundle.getMessage(GroovyInstantRenamer.class, (String)"OnlyRenameLocalVars");
            return false;
        }
        return false;
    }

    public Set<OffsetRange> getRenameRegions(ParserResult parserResult, int n) {
        this.LOG.log(Level.FINEST, "getRenameRegions()");
        GroovyParserResult groovyParserResult = AstUtilities.getParseResult((Parser.Result)parserResult);
        BaseDocument baseDocument = LexUtilities.getDocument(groovyParserResult, false);
        if (baseDocument == null) {
            return Collections.emptySet();
        }
        AstPath astPath = this.getPathUnderCaret(groovyParserResult, n);
        HashSet<OffsetRange> hashSet = new HashSet<OffsetRange>();
        GroovyInstantRenamer.markOccurences(astPath, hashSet, baseDocument, n);
        return hashSet;
    }

    private AstPath getPathUnderCaret(GroovyParserResult groovyParserResult, int n) {
        ModuleNode moduleNode = AstUtilities.getRoot(groovyParserResult);
        if (moduleNode == null) {
            return null;
        }
        int n2 = AstUtilities.getAstOffset((Parser.Result)groovyParserResult, n);
        if (n2 == -1) {
            return null;
        }
        BaseDocument baseDocument = LexUtilities.getDocument(groovyParserResult, false);
        if (baseDocument == null) {
            this.LOG.log(Level.FINEST, "Could not get BaseDocument. It's null");
            return null;
        }
        return new AstPath((ASTNode)moduleNode, n2, baseDocument);
    }

    private static void markOccurences(AstPath astPath, Set<OffsetRange> set, BaseDocument baseDocument, int n) {
        ASTNode aSTNode = astPath.root();
        assert (aSTNode instanceof ModuleNode);
        ModuleNode moduleNode = (ModuleNode)aSTNode;
        VariableScopeVisitor variableScopeVisitor = new VariableScopeVisitor(moduleNode.getContext(), astPath, baseDocument, n);
        variableScopeVisitor.collect();
        for (ASTNode aSTNode2 : variableScopeVisitor.getOccurrences()) {
            OffsetRange offsetRange = AstUtilities.getRange(aSTNode2, baseDocument);
            set.add(offsetRange);
        }
    }
}

