/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.lexer;

import groovyjarjarantlr.CharBuffer;
import groovyjarjarantlr.CharQueue;
import groovyjarjarantlr.CharStreamException;
import groovyjarjarantlr.LexerSharedInputState;
import groovyjarjarantlr.TokenStreamException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.codehaus.groovy.antlr.parser.GroovyRecognizer;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GroovyLexer
implements Lexer<GroovyTokenId> {
    private static final Logger LOG = Logger.getLogger(GroovyLexer.class.getName());
    private DelegateLexer scanner = new DelegateLexer((LexerSharedInputState)null);
    private LexerInput lexerInput;
    private MyCharBuffer myCharBuffer;
    private TokenFactory<GroovyTokenId> tokenFactory;
    private final GroovyRecognizer parser;
    private int index = 1;

    public GroovyLexer(LexerRestartInfo<GroovyTokenId> lexerRestartInfo) {
        this.scanner.setWhitespaceIncluded(true);
        this.parser = GroovyRecognizer.make(this.scanner);
        this.restart(lexerRestartInfo);
    }

    private void restart(LexerRestartInfo<GroovyTokenId> lexerRestartInfo) {
        this.tokenFactory = lexerRestartInfo.tokenFactory();
        this.lexerInput = lexerRestartInfo.input();
        LexerSharedInputState lexerSharedInputState = null;
        if (this.lexerInput != null) {
            this.myCharBuffer = new MyCharBuffer(new LexerInputReader(this.lexerInput));
            lexerSharedInputState = new LexerSharedInputState(this.myCharBuffer);
        }
        this.scanner.setInputState(lexerSharedInputState);
        if (lexerSharedInputState != null) {
            this.scanner.resetText();
        }
        this.scanner.setState((State)lexerRestartInfo.state());
    }

    private void scannerConsumeChar() {
        try {
            this.scanner.consume();
        }
        catch (CharStreamException charStreamException) {
            throw new IllegalStateException();
        }
    }

    private Token<GroovyTokenId> createToken(int n, int n2) {
        GroovyTokenId groovyTokenId = this.getTokenId(n);
        LOG.finest("Creating token: " + groovyTokenId.name() + ", length: " + n2);
        String string = groovyTokenId.fixedText();
        return string != null ? this.tokenFactory.getFlyweightToken((TokenId)groovyTokenId, string) : this.tokenFactory.createToken((TokenId)groovyTokenId, n2);
    }

    public Token<GroovyTokenId> nextToken() {
        LOG.finest("");
        try {
            groovyjarjarantlr.Token token = this.parser.LT(this.index++);
            LOG.finest("Received token from antlr: " + token);
            if (token != null) {
                int n = token.getType();
                int n2 = this.lexerInput.readLengthEOF() - this.myCharBuffer.getExtraCharCount();
                if (token.getText() != null) {
                    n2 = Math.max(n2, token.getText().length());
                    LOG.finest("Counting length from " + this.lexerInput.readLengthEOF() + " and " + this.myCharBuffer.getExtraCharCount());
                }
                LOG.finest("Length of token to create: " + n2);
                switch (n) {
                    case 48: 
                    case 192: 
                    case 193: {
                        n = 85;
                        break;
                    }
                    case 1: {
                        if (this.lexerInput.readLength() > 0) {
                            return this.recovery();
                        }
                        return null;
                    }
                }
                return this.createToken(n, n2);
            }
            LOG.finest("Antlr token was null");
            int n = this.scanner.getText().length();
            if (n > 0) {
                return this.createToken(201, n);
            }
            return null;
        }
        catch (TokenStreamException tokenStreamException) {
            LOG.finest("Caught exception: " + tokenStreamException);
            return this.recovery();
        }
    }

    public Object state() {
        return this.scanner.getState();
    }

    public void release() {
    }

    private Token<GroovyTokenId> recovery() {
        int n = this.lexerInput.readLength();
        this.scanner.resetText();
        for (int i = this.lexerInput.readLength() - this.myCharBuffer.getExtraCharCount(); i < n; ++i) {
            LOG.finest("Consuming character");
            this.scannerConsumeChar();
        }
        return n > 0 ? this.createToken(GroovyTokenId.ERROR.ordinal(), n) : null;
    }

    private GroovyTokenId getTokenId(int n) {
        switch (n) {
            case 38: {
                return GroovyTokenId.ABSTRACT;
            }
            case 68: {
                return GroovyTokenId.ANNOTATION_ARRAY_INIT;
            }
            case 63: {
                return GroovyTokenId.ANNOTATION_DEF;
            }
            case 67: {
                return GroovyTokenId.ANNOTATION_FIELD_DEF;
            }
            case 66: {
                return GroovyTokenId.ANNOTATION_MEMBER_VALUE_PAIR;
            }
            case 65: {
                return GroovyTokenId.ANNOTATION;
            }
            case 64: {
                return GroovyTokenId.ANNOTATIONS;
            }
            case 16: {
                return GroovyTokenId.ARRAY_DECLARATOR;
            }
            case 120: {
                return GroovyTokenId.ASSIGN;
            }
            case 92: {
                return GroovyTokenId.AT;
            }
            case 166: {
                return GroovyTokenId.BAND_ASSIGN;
            }
            case 121: {
                return GroovyTokenId.BAND;
            }
            case 217: {
                return GroovyTokenId.BIG_SUFFIX;
            }
            case 4: {
                return GroovyTokenId.BLOCK;
            }
            case 190: {
                return GroovyTokenId.BNOT;
            }
            case 168: {
                return GroovyTokenId.BOR_ASSIGN;
            }
            case 173: {
                return GroovyTokenId.BOR;
            }
            case 164: {
                return GroovyTokenId.BSR_ASSIGN;
            }
            case 99: {
                return GroovyTokenId.BSR;
            }
            case 167: {
                return GroovyTokenId.BXOR_ASSIGN;
            }
            case 174: {
                return GroovyTokenId.BXOR;
            }
            case 31: {
                return GroovyTokenId.CASE_GROUP;
            }
            case 13: {
                return GroovyTokenId.CLASS_DEF;
            }
            case 49: {
                return GroovyTokenId.CLOSED_BLOCK;
            }
            case 76: {
                return GroovyTokenId.CLOSURE_OP;
            }
            case 132: {
                return GroovyTokenId.COLON;
            }
            case 96: {
                return GroovyTokenId.COMMA;
            }
            case 179: {
                return GroovyTokenId.COMPARE_TO;
            }
            case 44: {
                return GroovyTokenId.CTOR_CALL;
            }
            case 45: {
                return GroovyTokenId.CTOR_IDENT;
            }
            case 188: {
                return GroovyTokenId.DEC;
            }
            case 214: {
                return GroovyTokenId.DIGIT;
            }
            case 161: {
                return GroovyTokenId.DIV_ASSIGN;
            }
            case 186: {
                return GroovyTokenId.DIV;
            }
            case 200: {
                return GroovyTokenId.DOLLAR;
            }
            case 87: {
                return GroovyTokenId.DOT;
            }
            case 52: {
                return GroovyTokenId.DYNAMIC_MEMBER;
            }
            case 32: {
                return GroovyTokenId.ELIST;
            }
            case 36: {
                return GroovyTokenId.EMPTY_STAT;
            }
            case 61: {
                return GroovyTokenId.ENUM_CONSTANT_DEF;
            }
            case 60: {
                return GroovyTokenId.ENUM_DEF;
            }
            case 1: {
                return GroovyTokenId.EOF;
            }
            case 178: {
                return GroovyTokenId.EQUAL;
            }
            case 209: {
                return GroovyTokenId.ESC;
            }
            case 215: {
                return GroovyTokenId.EXPONENT;
            }
            case 27: {
                return GroovyTokenId.EXPR;
            }
            case 17: {
                return GroovyTokenId.EXTENDS_CLAUSE;
            }
            case 37: {
                return GroovyTokenId.FINAL;
            }
            case 216: {
                return GroovyTokenId.FLOAT_SUFFIX;
            }
            case 34: {
                return GroovyTokenId.FOR_CONDITION;
            }
            case 62: {
                return GroovyTokenId.FOR_EACH_CLAUSE;
            }
            case 58: {
                return GroovyTokenId.FOR_IN_ITERABLE;
            }
            case 33: {
                return GroovyTokenId.FOR_INIT;
            }
            case 35: {
                return GroovyTokenId.FOR_ITERATOR;
            }
            case 181: {
                return GroovyTokenId.GE;
            }
            case 97: {
                return GroovyTokenId.GT;
            }
            case 211: {
                return GroovyTokenId.HEX_DIGIT;
            }
            case 84: {
                return GroovyTokenId.IDENTIFIER;
            }
            case 18: {
                return GroovyTokenId.IMPLEMENTS_CLAUSE;
            }
            case 50: {
                return GroovyTokenId.IMPLICIT_PARAMETERS;
            }
            case 28: {
                return GroovyTokenId.IMPORT;
            }
            case 185: {
                return GroovyTokenId.INC;
            }
            case 23: {
                return GroovyTokenId.INDEX_OP;
            }
            case 10: {
                return GroovyTokenId.INSTANCE_INIT;
            }
            case 14: {
                return GroovyTokenId.INTERFACE_DEF;
            }
            case 53: {
                return GroovyTokenId.LABELED_ARG;
            }
            case 21: {
                return GroovyTokenId.LABELED_STAT;
            }
            case 172: {
                return GroovyTokenId.LAND;
            }
            case 82: {
                return GroovyTokenId.LBRACKET;
            }
            case 122: {
                return GroovyTokenId.LBRACE;
            }
            case 180: {
                return GroovyTokenId.LE;
            }
            case 213: {
                return GroovyTokenId.LETTER;
            }
            case 56: {
                return GroovyTokenId.LIST_CONSTRUCTOR;
            }
            case 110: {
                return GroovyTokenId.LITERAL_as;
            }
            case 143: {
                return GroovyTokenId.LITERAL_assert;
            }
            case 101: {
                return GroovyTokenId.LITERAL_boolean;
            }
            case 140: {
                return GroovyTokenId.LITERAL_break;
            }
            case 102: {
                return GroovyTokenId.LITERAL_byte;
            }
            case 146: {
                return GroovyTokenId.LITERAL_case;
            }
            case 149: {
                return GroovyTokenId.LITERAL_catch;
            }
            case 89: {
                return GroovyTokenId.LITERAL_class;
            }
            case 141: {
                return GroovyTokenId.LITERAL_continue;
            }
            case 81: {
                return GroovyTokenId.LITERAL_def;
            }
            case 126: {
                return GroovyTokenId.LITERAL_default;
            }
            case 108: {
                return GroovyTokenId.LITERAL_double;
            }
            case 134: {
                return GroovyTokenId.LITERAL_else;
            }
            case 91: {
                return GroovyTokenId.LITERAL_enum;
            }
            case 94: {
                return GroovyTokenId.LITERAL_extends;
            }
            case 153: {
                return GroovyTokenId.LITERAL_false;
            }
            case 148: {
                return GroovyTokenId.LITERAL_finally;
            }
            case 106: {
                return GroovyTokenId.LITERAL_float;
            }
            case 137: {
                return GroovyTokenId.LITERAL_for;
            }
            case 103: {
                return GroovyTokenId.LITERAL_char;
            }
            case 133: {
                return GroovyTokenId.LITERAL_if;
            }
            case 128: {
                return GroovyTokenId.LITERAL_implements;
            }
            case 79: {
                return GroovyTokenId.LITERAL_import;
            }
            case 138: {
                return GroovyTokenId.LITERAL_in;
            }
            case 154: {
                return GroovyTokenId.LITERAL_instanceof;
            }
            case 105: {
                return GroovyTokenId.LITERAL_int;
            }
            case 90: {
                return GroovyTokenId.LITERAL_interface;
            }
            case 107: {
                return GroovyTokenId.LITERAL_long;
            }
            case 115: {
                return GroovyTokenId.LITERAL_native;
            }
            case 155: {
                return GroovyTokenId.LITERAL_new;
            }
            case 156: {
                return GroovyTokenId.LITERAL_null;
            }
            case 78: {
                return GroovyTokenId.LITERAL_package;
            }
            case 111: {
                return GroovyTokenId.LITERAL_private;
            }
            case 113: {
                return GroovyTokenId.LITERAL_protected;
            }
            case 112: {
                return GroovyTokenId.LITERAL_public;
            }
            case 139: {
                return GroovyTokenId.LITERAL_return;
            }
            case 104: {
                return GroovyTokenId.LITERAL_short;
            }
            case 80: {
                return GroovyTokenId.LITERAL_static;
            }
            case 95: {
                return GroovyTokenId.LITERAL_super;
            }
            case 136: {
                return GroovyTokenId.LITERAL_switch;
            }
            case 117: {
                return GroovyTokenId.LITERAL_synchronized;
            }
            case 129: {
                return GroovyTokenId.LITERAL_this;
            }
            case 116: {
                return GroovyTokenId.LITERAL_threadsafe;
            }
            case 142: {
                return GroovyTokenId.LITERAL_throw;
            }
            case 127: {
                return GroovyTokenId.LITERAL_throws;
            }
            case 114: {
                return GroovyTokenId.LITERAL_transient;
            }
            case 157: {
                return GroovyTokenId.LITERAL_true;
            }
            case 147: {
                return GroovyTokenId.LITERAL_try;
            }
            case 100: {
                return GroovyTokenId.LITERAL_void;
            }
            case 118: {
                return GroovyTokenId.LITERAL_volatile;
            }
            case 135: {
                return GroovyTokenId.LITERAL_while;
            }
            case 191: {
                return GroovyTokenId.LNOT;
            }
            case 171: {
                return GroovyTokenId.LOR;
            }
            case 88: {
                return GroovyTokenId.LPAREN;
            }
            case 86: {
                return GroovyTokenId.LT;
            }
            case 57: {
                return GroovyTokenId.MAP_CONSTRUCTOR;
            }
            case 152: {
                return GroovyTokenId.MEMBER_POINTER;
            }
            case 26: {
                return GroovyTokenId.METHOD_CALL;
            }
            case 8: {
                return GroovyTokenId.METHOD_DEF;
            }
            case 159: {
                return GroovyTokenId.MINUS_ASSIGN;
            }
            case 145: {
                return GroovyTokenId.MINUS;
            }
            case 204: {
                return GroovyTokenId.BLOCK_COMMENT;
            }
            case 162: {
                return GroovyTokenId.MOD_ASSIGN;
            }
            case 187: {
                return GroovyTokenId.MOD;
            }
            case 5: {
                return GroovyTokenId.MODIFIERS;
            }
            case 125: {
                return GroovyTokenId.NLS;
            }
            case 177: {
                return GroovyTokenId.NOT_EQUAL;
            }
            case 3: {
                return GroovyTokenId.NULL_TREE_LOOKAHEAD;
            }
            case 199: {
                return GroovyTokenId.NUM_BIG_DECIMAL;
            }
            case 198: {
                return GroovyTokenId.NUM_BIG_INT;
            }
            case 197: {
                return GroovyTokenId.NUM_DOUBLE;
            }
            case 195: {
                return GroovyTokenId.NUM_FLOAT;
            }
            case 194: {
                return GroovyTokenId.NUM_INT;
            }
            case 196: {
                return GroovyTokenId.NUM_LONG;
            }
            case 6: {
                return GroovyTokenId.OBJBLOCK;
            }
            case 202: {
                return GroovyTokenId.ONE_NL;
            }
            case 151: {
                return GroovyTokenId.OPTIONAL_DOT;
            }
            case 15: {
                return GroovyTokenId.PACKAGE_DEF;
            }
            case 20: {
                return GroovyTokenId.PARAMETER_DEF;
            }
            case 19: {
                return GroovyTokenId.PARAMETERS;
            }
            case 158: {
                return GroovyTokenId.PLUS_ASSIGN;
            }
            case 144: {
                return GroovyTokenId.PLUS;
            }
            case 25: {
                return GroovyTokenId.POST_DEC;
            }
            case 24: {
                return GroovyTokenId.POST_INC;
            }
            case 93: {
                return GroovyTokenId.QUESTION;
            }
            case 184: {
                return GroovyTokenId.RANGE_EXCLUSIVE;
            }
            case 183: {
                return GroovyTokenId.RANGE_INCLUSIVE;
            }
            case 123: {
                return GroovyTokenId.RBRACE;
            }
            case 83: {
                return GroovyTokenId.RBRACKET;
            }
            case 175: {
                return GroovyTokenId.REGEX_FIND;
            }
            case 176: {
                return GroovyTokenId.REGEX_MATCH;
            }
            case 208: {
                return GroovyTokenId.REGEXP_SYMBOL;
            }
            case 119: {
                return GroovyTokenId.RPAREN;
            }
            case 51: {
                return GroovyTokenId.SELECT_SLOT;
            }
            case 124: {
                return GroovyTokenId.SEMI;
            }
            case 77: {
                return GroovyTokenId.LINE_COMMENT;
            }
            case 165: {
                return GroovyTokenId.SL_ASSIGN;
            }
            case 203: {
                return GroovyTokenId.LINE_COMMENT;
            }
            case 182: {
                return GroovyTokenId.SL;
            }
            case 7: {
                return GroovyTokenId.SLIST;
            }
            case 54: {
                return GroovyTokenId.SPREAD_ARG;
            }
            case 150: {
                return GroovyTokenId.SPREAD_DOT;
            }
            case 55: {
                return GroovyTokenId.SPREAD_MAP_ARG;
            }
            case 163: {
                return GroovyTokenId.SR_ASSIGN;
            }
            case 98: {
                return GroovyTokenId.SR;
            }
            case 160: {
                return GroovyTokenId.STAR_ASSIGN;
            }
            case 169: {
                return GroovyTokenId.STAR_STAR_ASSIGN;
            }
            case 189: {
                return GroovyTokenId.STAR_STAR;
            }
            case 109: {
                return GroovyTokenId.STAR;
            }
            case 59: {
                return GroovyTokenId.STATIC_IMPORT;
            }
            case 11: {
                return GroovyTokenId.STATIC_INIT;
            }
            case 42: {
                return GroovyTokenId.STRICTFP;
            }
            case 47: {
                return GroovyTokenId.STRING_CONSTRUCTOR;
            }
            case 193: {
                return GroovyTokenId.STRING_CTOR_END;
            }
            case 48: {
                return GroovyTokenId.STRING_CTOR_MIDDLE;
            }
            case 192: {
                return GroovyTokenId.STRING_CTOR_START;
            }
            case 205: {
                return GroovyTokenId.STRING_CH;
            }
            case 85: {
                return GroovyTokenId.STRING_LITERAL;
            }
            case 210: {
                return GroovyTokenId.STRING_NL;
            }
            case 43: {
                return GroovyTokenId.SUPER_CTOR_CALL;
            }
            case 130: {
                return GroovyTokenId.TRIPLE_DOT;
            }
            case 70: {
                return GroovyTokenId.TYPE_ARGUMENT;
            }
            case 69: {
                return GroovyTokenId.TYPE_ARGUMENTS;
            }
            case 75: {
                return GroovyTokenId.TYPE_LOWER_BOUNDS;
            }
            case 72: {
                return GroovyTokenId.TYPE_PARAMETER;
            }
            case 71: {
                return GroovyTokenId.TYPE_PARAMETERS;
            }
            case 74: {
                return GroovyTokenId.TYPE_UPPER_BOUNDS;
            }
            case 12: {
                return GroovyTokenId.TYPE;
            }
            case 22: {
                return GroovyTokenId.TYPECAST;
            }
            case 29: {
                return GroovyTokenId.UNARY_MINUS;
            }
            case 30: {
                return GroovyTokenId.UNARY_PLUS;
            }
            case 40: {
                return GroovyTokenId.UNUSED_CONST;
            }
            case 41: {
                return GroovyTokenId.UNUSED_DO;
            }
            case 39: {
                return GroovyTokenId.UNUSED_GOTO;
            }
            case 9: {
                return GroovyTokenId.VARIABLE_DEF;
            }
            case 46: {
                return GroovyTokenId.VARIABLE_PARAMETER_DEF;
            }
            case 212: {
                return GroovyTokenId.VOCAB;
            }
            case 73: {
                return GroovyTokenId.WILDCARD_TYPE;
            }
            case 201: {
                return GroovyTokenId.WHITESPACE;
            }
        }
        return GroovyTokenId.IDENTIFIER;
    }

    private static class State {
        private final int stringCtorState;
        private final ArrayList parenLevelStack;

        public State(int n, ArrayList arrayList) {
            this.stringCtorState = n;
            this.parenLevelStack = new ArrayList(arrayList);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            State state = (State)object;
            if (this.stringCtorState != state.stringCtorState) {
                return false;
            }
            return this.parenLevelStack != null && this.parenLevelStack.equals(state.parenLevelStack);
        }

        public int hashCode() {
            int n = 5;
            n = 67 * n + this.stringCtorState;
            n = 67 * n + (this.parenLevelStack != null ? this.parenLevelStack.hashCode() : 0);
            return n;
        }
    }

    private static class DelegateLexer
    extends org.codehaus.groovy.antlr.parser.GroovyLexer {
        public DelegateLexer(LexerSharedInputState lexerSharedInputState) {
            super(lexerSharedInputState);
        }

        public State getState() {
            if (this.stringCtorState > 0 || !this.parenLevelStack.isEmpty()) {
                return new State(this.stringCtorState, this.parenLevelStack);
            }
            return null;
        }

        public void setState(State state) {
            if (state != null) {
                this.stringCtorState = state.stringCtorState;
                this.parenLevelStack = new ArrayList(state.parenLevelStack);
            }
        }
    }

    private static class LexerInputReader
    extends Reader {
        private LexerInput input;

        LexerInputReader(LexerInput lexerInput) {
            this.input = lexerInput;
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            for (int i = 0; i < n2; ++i) {
                int n3 = this.input.read();
                if (n3 == -1) {
                    return -1;
                }
                cArray[i + n] = (char)n3;
            }
            return n2;
        }

        public void close() throws IOException {
        }
    }

    private static class MyCharQueue
    extends CharQueue {
        public MyCharQueue(int n) {
            super(n);
        }

        public int getNbrEntries() {
            return this.nbrEntries;
        }
    }

    private static class MyCharBuffer
    extends CharBuffer {
        public MyCharBuffer(Reader reader) {
            super(reader);
            this.queue = new MyCharQueue(1);
        }

        public int getExtraCharCount() {
            this.syncConsume();
            return ((MyCharQueue)this.queue).getNbrEntries();
        }
    }
}

