/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementDeclaration {
    private static Logger log = Logger.getLogger(ElementDeclaration.class.getName());

    private ElementDeclaration() {
    }

    public static DeclarationFinder.DeclarationLocation getDeclarationLocation(ClasspathInfo classpathInfo, Element element) {
        ElementHandle elementHandle = ElementHandle.create((Element)element);
        FileObject fileObject = SourceUtils.getFile((ElementHandle)elementHandle, (ClasspathInfo)classpathInfo);
        if (fileObject != null) {
            return ElementDeclaration.getDeclarationLocation(fileObject, (ElementHandle<? extends Element>)elementHandle);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private static DeclarationFinder.DeclarationLocation getDeclarationLocation(FileObject fileObject, ElementHandle<? extends Element> elementHandle) {
        assert (fileObject != null);
        try {
            int n = ElementDeclaration.getOffset(fileObject, elementHandle);
            return new DeclarationFinder.DeclarationLocation(fileObject, n);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return DeclarationFinder.DeclarationLocation.NONE;
        }
    }

    private static int getOffset(FileObject fileObject, final ElementHandle<? extends Element> elementHandle) throws IOException {
        if (IndexingManager.getDefault().isIndexing()) {
            log.info("Skipping location of element offset within file, Scannig in progress");
            return 0;
        }
        final int[] nArray = new int[]{-1};
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource != null) {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) {
                    try {
                        compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                    Element element = elementHandle.resolve((CompilationInfo)compilationController);
                    if (element == null) {
                        log.severe("Cannot resolve " + elementHandle + ". " + compilationController.getClasspathInfo());
                        return;
                    }
                    FindDeclarationVisitor findDeclarationVisitor = new FindDeclarationVisitor(element, (CompilationInfo)compilationController);
                    CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                    findDeclarationVisitor.scan(compilationUnitTree, null);
                    Tree tree = findDeclarationVisitor.declTree;
                    if (tree != null) {
                        nArray[0] = (int)compilationController.getTrees().getSourcePositions().getStartPosition(compilationUnitTree, tree);
                    }
                }
            }, true);
        }
        return nArray[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindDeclarationVisitor
    extends TreePathScanner<Void, Void> {
        private Element element;
        private Tree declTree;
        private CompilationInfo info;

        public FindDeclarationVisitor(Element element, CompilationInfo compilationInfo) {
            this.element = element;
            this.info = compilationInfo;
        }

        @Override
        public Void visitClass(ClassTree classTree, Void void_) {
            this.handleDeclaration();
            super.visitClass(classTree, void_);
            return null;
        }

        @Override
        public Void visitMethod(MethodTree methodTree, Void void_) {
            this.handleDeclaration();
            super.visitMethod(methodTree, void_);
            return null;
        }

        @Override
        public Void visitVariable(VariableTree variableTree, Void void_) {
            this.handleDeclaration();
            super.visitVariable(variableTree, void_);
            return null;
        }

        public void handleDeclaration() {
            Element element = this.info.getTrees().getElement(this.getCurrentPath());
            if (((Object)this.element).equals(element)) {
                this.declTree = this.getCurrentPath().getLeaf();
            }
        }
    }
}

