/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.java;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.netbeans.api.java.source.SourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utilities {
    private static final String CAPTURED_WILDCARD = "<captured wildcard>";
    private static final String UNKNOWN = "<unknown>";
    private static final Map<Character, String> NATIVE_TYPES = new HashMap<Character, String>();

    public static String translateClassLoaderTypeName(String string) {
        if (string.length() < 1) {
            return string;
        }
        char c = string.charAt(0);
        if ('L' == c && string.charAt(string.length() - 1) == ';') {
            return string.substring(1, string.length() - 1);
        }
        if ('[' == c) {
            if (string.length() < 2) {
                throw new IllegalArgumentException("Not a correct type: " + string);
            }
            return Utilities.translateClassLoaderTypeName(string.substring(1)) + "[]";
        }
        if (string.length() == 1) {
            String string2 = NATIVE_TYPES.get(Character.valueOf(c));
            if (string2 != null) {
                return string2;
            }
            return string;
        }
        return string;
    }

    public static Collection<javax.lang.model.element.Modifier> reflectionModifiersToModel(int n) {
        HashSet<javax.lang.model.element.Modifier> hashSet = new HashSet<javax.lang.model.element.Modifier>();
        if (Modifier.isAbstract(n)) {
            hashSet.add(javax.lang.model.element.Modifier.ABSTRACT);
        }
        if (Modifier.isFinal(n)) {
            hashSet.add(javax.lang.model.element.Modifier.FINAL);
        }
        if (Modifier.isNative(n)) {
            hashSet.add(javax.lang.model.element.Modifier.NATIVE);
        }
        if (Modifier.isStatic(n)) {
            hashSet.add(javax.lang.model.element.Modifier.STATIC);
        }
        if (Modifier.isStrict(n)) {
            hashSet.add(javax.lang.model.element.Modifier.STRICTFP);
        }
        if (Modifier.isSynchronized(n)) {
            hashSet.add(javax.lang.model.element.Modifier.SYNCHRONIZED);
        }
        if (Modifier.isTransient(n)) {
            hashSet.add(javax.lang.model.element.Modifier.TRANSIENT);
        }
        if (Modifier.isVolatile(n)) {
            hashSet.add(javax.lang.model.element.Modifier.VOLATILE);
        }
        if (Modifier.isPrivate(n)) {
            hashSet.add(javax.lang.model.element.Modifier.PRIVATE);
        } else if (Modifier.isProtected(n)) {
            hashSet.add(javax.lang.model.element.Modifier.PROTECTED);
        } else if (Modifier.isPublic(n)) {
            hashSet.add(javax.lang.model.element.Modifier.PUBLIC);
        }
        return hashSet;
    }

    public static Set<javax.lang.model.element.Modifier> gsfModifiersToModel(Set<org.netbeans.modules.csl.api.Modifier> set, javax.lang.model.element.Modifier modifier) {
        HashSet<javax.lang.model.element.Modifier> hashSet = new HashSet<javax.lang.model.element.Modifier>();
        if (set.contains(org.netbeans.modules.csl.api.Modifier.STATIC)) {
            hashSet.add(javax.lang.model.element.Modifier.STATIC);
        }
        if (set.contains(org.netbeans.modules.csl.api.Modifier.PRIVATE)) {
            hashSet.add(javax.lang.model.element.Modifier.PRIVATE);
        } else if (set.contains(org.netbeans.modules.csl.api.Modifier.PROTECTED)) {
            hashSet.add(javax.lang.model.element.Modifier.PROTECTED);
        } else if (set.contains(org.netbeans.modules.csl.api.Modifier.PUBLIC)) {
            hashSet.add(javax.lang.model.element.Modifier.PUBLIC);
        } else if (modifier != null) {
            hashSet.add(modifier);
        }
        return hashSet;
    }

    public static Set<org.netbeans.modules.csl.api.Modifier> modelModifiersToGsf(Set<javax.lang.model.element.Modifier> set) {
        LinkedHashSet<org.netbeans.modules.csl.api.Modifier> linkedHashSet = new LinkedHashSet<org.netbeans.modules.csl.api.Modifier>();
        if (set.contains((Object)javax.lang.model.element.Modifier.STATIC)) {
            linkedHashSet.add(org.netbeans.modules.csl.api.Modifier.STATIC);
        }
        if (set.contains((Object)javax.lang.model.element.Modifier.PRIVATE)) {
            linkedHashSet.add(org.netbeans.modules.csl.api.Modifier.PRIVATE);
        } else if (set.contains((Object)javax.lang.model.element.Modifier.PROTECTED)) {
            linkedHashSet.add(org.netbeans.modules.csl.api.Modifier.PROTECTED);
        } else if (set.contains((Object)javax.lang.model.element.Modifier.PUBLIC)) {
            linkedHashSet.add(org.netbeans.modules.csl.api.Modifier.PUBLIC);
        }
        return linkedHashSet;
    }

    public static CharSequence getTypeName(TypeMirror typeMirror, boolean bl) {
        return Utilities.getTypeName(typeMirror, bl, false);
    }

    public static CharSequence getClassName(TypeMirror typeMirror) {
        assert (typeMirror != null);
        return (CharSequence)new ClassNameVisitor().visit(typeMirror, null);
    }

    public static CharSequence getTypeName(TypeMirror typeMirror, boolean bl, boolean bl2) {
        if (typeMirror == null) {
            return "";
        }
        return (CharSequence)new TypeNameVisitor(bl2).visit(typeMirror, bl);
    }

    static {
        NATIVE_TYPES.put(Character.valueOf('B'), "byte");
        NATIVE_TYPES.put(Character.valueOf('C'), "char");
        NATIVE_TYPES.put(Character.valueOf('D'), "double");
        NATIVE_TYPES.put(Character.valueOf('F'), "float");
        NATIVE_TYPES.put(Character.valueOf('I'), "int");
        NATIVE_TYPES.put(Character.valueOf('J'), "long");
        NATIVE_TYPES.put(Character.valueOf('S'), "short");
        NATIVE_TYPES.put(Character.valueOf('Z'), "boolean");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassNameVisitor
    extends SimpleTypeVisitor6<StringBuilder, Void> {
        private ClassNameVisitor() {
            super(new StringBuilder());
        }

        @Override
        public StringBuilder defaultAction(TypeMirror typeMirror, Void void_) {
            return ((StringBuilder)this.DEFAULT_VALUE).append(typeMirror);
        }

        @Override
        public StringBuilder visitDeclared(DeclaredType declaredType, Void void_) {
            Element element = declaredType.asElement();
            if (element instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)element;
                return ((StringBuilder)this.DEFAULT_VALUE).append(typeElement.getQualifiedName().toString());
            }
            return ((StringBuilder)this.DEFAULT_VALUE).append(Utilities.UNKNOWN);
        }

        @Override
        public StringBuilder visitError(ErrorType errorType, Void void_) {
            Element element = errorType.asElement();
            if (element instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)element;
                return ((StringBuilder)this.DEFAULT_VALUE).append(typeElement.getQualifiedName().toString());
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeNameVisitor
    extends SimpleTypeVisitor6<StringBuilder, Boolean> {
        private boolean varArg;
        private boolean insideCapturedWildcard = false;

        private TypeNameVisitor(boolean bl) {
            super(new StringBuilder());
            this.varArg = bl;
        }

        @Override
        public StringBuilder defaultAction(TypeMirror typeMirror, Boolean bl) {
            return ((StringBuilder)this.DEFAULT_VALUE).append(typeMirror);
        }

        @Override
        public StringBuilder visitDeclared(DeclaredType declaredType, Boolean bl) {
            Element element = declaredType.asElement();
            if (element instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)element;
                ((StringBuilder)this.DEFAULT_VALUE).append((bl != false ? typeElement.getQualifiedName() : typeElement.getSimpleName()).toString());
                Iterator<? extends TypeMirror> iterator = declaredType.getTypeArguments().iterator();
                if (iterator.hasNext()) {
                    ((StringBuilder)this.DEFAULT_VALUE).append("<");
                    while (iterator.hasNext()) {
                        this.visit(iterator.next(), bl);
                        if (!iterator.hasNext()) continue;
                        ((StringBuilder)this.DEFAULT_VALUE).append(", ");
                    }
                    ((StringBuilder)this.DEFAULT_VALUE).append(">");
                }
                return (StringBuilder)this.DEFAULT_VALUE;
            }
            return ((StringBuilder)this.DEFAULT_VALUE).append(Utilities.UNKNOWN);
        }

        @Override
        public StringBuilder visitArray(ArrayType arrayType, Boolean bl) {
            boolean bl2 = this.varArg;
            this.varArg = false;
            this.visit(arrayType.getComponentType(), bl);
            return ((StringBuilder)this.DEFAULT_VALUE).append(bl2 ? "..." : "[]");
        }

        @Override
        public StringBuilder visitTypeVariable(TypeVariable typeVariable, Boolean bl) {
            Object object;
            Element element = typeVariable.asElement();
            if (element != null && !Utilities.CAPTURED_WILDCARD.equals(object = element.getSimpleName().toString())) {
                return ((StringBuilder)this.DEFAULT_VALUE).append((String)object);
            }
            ((StringBuilder)this.DEFAULT_VALUE).append("?");
            if (!this.insideCapturedWildcard) {
                this.insideCapturedWildcard = true;
                object = typeVariable.getLowerBound();
                if (object != null && object.getKind() != TypeKind.NULL) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" super ");
                    this.visit((TypeMirror)object, bl);
                } else {
                    object = typeVariable.getUpperBound();
                    if (object != null && object.getKind() != TypeKind.NULL) {
                        ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                        if (object.getKind() == TypeKind.TYPEVAR) {
                            object = ((TypeVariable)object).getLowerBound();
                        }
                        this.visit((TypeMirror)object, bl);
                    }
                }
                this.insideCapturedWildcard = false;
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }

        @Override
        public StringBuilder visitWildcard(WildcardType wildcardType, Boolean bl) {
            int n = ((StringBuilder)this.DEFAULT_VALUE).length();
            ((StringBuilder)this.DEFAULT_VALUE).append("?");
            TypeMirror typeMirror = wildcardType.getSuperBound();
            if (typeMirror == null) {
                typeMirror = wildcardType.getExtendsBound();
                if (typeMirror != null) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                    if (typeMirror.getKind() == TypeKind.WILDCARD) {
                        typeMirror = ((WildcardType)typeMirror).getSuperBound();
                    }
                    this.visit(typeMirror, bl);
                } else if (!(n != 0 || (typeMirror = SourceUtils.getBound((WildcardType)wildcardType)) == null || typeMirror.getKind() == TypeKind.DECLARED && ((TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName().contentEquals("java.lang.Object"))) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                    this.visit(typeMirror, bl);
                }
            } else {
                ((StringBuilder)this.DEFAULT_VALUE).append(" super ");
                this.visit(typeMirror, bl);
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }

        @Override
        public StringBuilder visitError(ErrorType errorType, Boolean bl) {
            Element element = errorType.asElement();
            if (element instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)element;
                return ((StringBuilder)this.DEFAULT_VALUE).append((bl != false ? typeElement.getQualifiedName() : typeElement.getSimpleName()).toString());
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }
    }
}

