/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.queue;

import org.netbeans.modules.cnd.repository.queue.KeyValueQueue;
import org.netbeans.modules.cnd.repository.queue.RepositoryQueue;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.testbench.Stats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TickingRepositoryQueue
extends RepositoryQueue {
    protected int currentTick = 0;
    protected final int tickShift;
    public static final int queueTickShift = Stats.getInteger("cnd.repository.queue.tickshift", 8);

    public TickingRepositoryQueue(int n) {
        this.tickShift = n;
    }

    public TickingRepositoryQueue() {
        this(queueTickShift);
    }

    @Override
    protected void doReplaceAddLast(Key key, Persistent persistent, KeyValueQueue.Entry<Key, Persistent> entry) {
        if (entry instanceof TickingEntry) {
            super.doReplaceAddLast(key, persistent, entry);
            this.queue.remove(entry);
            this.queue.addLast(entry);
            ((TickingEntry)entry).setTick(this.currentTick);
        }
    }

    @Override
    protected void doPostPoll(KeyValueQueue.Entry<Key, Persistent> entry) {
        super.doPostPoll(entry);
        if (this.queue.isEmpty()) {
            this.currentTick = 0;
        }
    }

    protected TickingEntry createEntry(Key key, Persistent persistent) {
        return new TickingEntry(key, persistent, this.currentTick);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReady() {
        Object object = this.lock;
        synchronized (object) {
            if (this.queue.isEmpty()) {
                return false;
            }
            TickingEntry tickingEntry = (TickingEntry)this.queue.peek();
            boolean bl = this.currentTick - tickingEntry.getTick() > queueTickShift;
            return bl;
        }
    }

    @Override
    public void onIdle() {
        ++this.currentTick;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TickingEntry
    extends KeyValueQueue.Entry<Key, Persistent> {
        private int tick;

        protected TickingEntry(Key key, Persistent persistent, int n) {
            super(key, persistent);
            this.tick = n;
        }

        public int getTick() {
            return this.tick;
        }

        public void setTick(int n) {
            this.tick = n;
        }
    }
}

