/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.io.IOException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;

public class CDCMainClassHelper
implements AntProjectListener,
FileChangeListener {
    private final AntProjectHelper helper;
    private String mainClass;
    private FileObject lastMain = null;

    public CDCMainClassHelper(AntProjectHelper antProjectHelper) {
        this.helper = antProjectHelper;
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        this.mainClass = editableProperties.getProperty("main.class");
        if (this.mainClass != null) {
            this.setUp(this.mainClass);
        }
        antProjectHelper.addAntProjectListener((AntProjectListener)this);
    }

    public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
    }

    public void propertiesChanged(AntProjectEvent antProjectEvent) {
        String string = this.helper.getProperties("nbproject/project.properties").getProperty("main.class");
        if (string != null && !string.equals(this.mainClass)) {
            this.setUp(string);
            this.mainClass = string;
        }
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
    }

    public void fileChanged(FileEvent fileEvent) {
    }

    public void fileDeleted(FileEvent fileEvent) {
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        FileObject fileObject = (FileObject)fileRenameEvent.getSource();
        this.mainClass = this.mainClass.substring(0, this.mainClass.lastIndexOf(46) + 1) + fileObject.getName();
        EditableProperties editableProperties = this.helper.getProperties("nbproject/project.properties");
        editableProperties.setProperty("main.class", this.mainClass);
        this.helper.putProperties("nbproject/project.properties", editableProperties);
        try {
            Project project = ProjectManager.getDefault().findProject(this.helper.getProjectDirectory());
            ProjectManager.getDefault().saveProject(project);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    private synchronized void setUp(final String string) {
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                FileObject fileObject = CDCMainClassHelper.this.helper.getProjectDirectory().getFileObject(CDCMainClassHelper.this.helper.getProperties("nbproject/project.properties").getProperty("src.dir"));
                if (fileObject != null) {
                    ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
                    ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
                    ClassPath classPath3 = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classPath, classPath2});
                    FileObject fileObject2 = classPath3.findResource(string.replace('.', '/') + ".java");
                    if (CDCMainClassHelper.this.lastMain != null) {
                        CDCMainClassHelper.this.lastMain.removeFileChangeListener((FileChangeListener)CDCMainClassHelper.this);
                    }
                    if (fileObject2 != null) {
                        fileObject2.addFileChangeListener((FileChangeListener)CDCMainClassHelper.this);
                    }
                    CDCMainClassHelper.this.lastMain = fileObject2;
                }
            }
        });
    }
}

