/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.mobility.project.MIDletsCacheListener;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.spi.mobility.project.support.DefaultPropertyParsers;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;

public class MIDletsCacheHelper
implements AntProjectListener {
    private final AntProjectHelper helper;
    private final ProjectConfigurationsHelper confs;
    protected final ArrayList<MIDletsCacheListener> list = new ArrayList();
    private HashSet<String> set = new HashSet();

    public MIDletsCacheHelper(AntProjectHelper antProjectHelper, ProjectConfigurationsHelper projectConfigurationsHelper) {
        this.helper = antProjectHelper;
        this.confs = projectConfigurationsHelper;
        this.refresh();
        antProjectHelper.addAntProjectListener((AntProjectListener)this);
        projectConfigurationsHelper.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("activeConfiguration".equals(propertyChangeEvent.getPropertyName())) {
                    MIDletsCacheHelper.this.refresh();
                }
            }
        });
    }

    public synchronized boolean contains(String string) {
        return this.set.contains(string);
    }

    public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
    }

    public void propertiesChanged(AntProjectEvent antProjectEvent) {
        this.refresh();
    }

    public final void refresh() {
        this.refreshCore();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                MIDletsCacheListener[] mIDletsCacheListenerArray;
                ArrayList<MIDletsCacheListener> arrayList = MIDletsCacheHelper.this.list;
                synchronized (arrayList) {
                    mIDletsCacheListenerArray = MIDletsCacheHelper.this.list.toArray(new MIDletsCacheListener[MIDletsCacheHelper.this.list.size()]);
                }
                for (int i = 0; i < mIDletsCacheListenerArray.length; ++i) {
                    mIDletsCacheListenerArray[i].cacheChanged();
                }
            }
        });
    }

    private void refreshCore() {
        ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                Object v;
                Object object;
                ProjectConfiguration projectConfiguration = MIDletsCacheHelper.this.confs.getActiveConfiguration();
                String string = projectConfiguration != null && projectConfiguration != MIDletsCacheHelper.this.confs.getDefaultConfiguration() ? projectConfiguration.getDisplayName() : null;
                MIDletsCacheHelper.this.set = new HashSet();
                String string2 = null;
                PropertyEvaluator propertyEvaluator = MIDletsCacheHelper.this.helper.getStandardPropertyEvaluator();
                if (string != null) {
                    object = VisualPropertySupport.prefixPropertyName(string, "manifest.midlets");
                    string2 = propertyEvaluator.getProperty((String)object);
                }
                if (string2 == null) {
                    string2 = propertyEvaluator.getProperty("manifest.midlets");
                }
                if (string2 == null) {
                    return null;
                }
                object = (HashMap)DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.decode(string2, null, null);
                if (object == null) {
                    return null;
                }
                int n = 1;
                while ((v = ((HashMap)object).get("MIDlet-" + n)) != null) {
                    String string3;
                    String[] stringArray;
                    ++n;
                    if (!(v instanceof String) || (stringArray = ((String)v).split(",", -1)).length < 2 || "".equals(string3 = stringArray[2].trim())) continue;
                    MIDletsCacheHelper.this.set.add(string3);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMIDletsCacheListener(MIDletsCacheListener mIDletsCacheListener) {
        ArrayList<MIDletsCacheListener> arrayList = this.list;
        synchronized (arrayList) {
            this.list.add(mIDletsCacheListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMIDletsCacheListener(MIDletsCacheListener mIDletsCacheListener) {
        ArrayList<MIDletsCacheListener> arrayList = this.list;
        synchronized (arrayList) {
            this.list.remove(mIDletsCacheListener);
        }
    }
}

