/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.io.CharConversionException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.project.ui.J2MEProjectRootNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;

class DecoratedNode
extends AbstractNode {
    static final String GRAY = "gray";
    static final String BOLD = "bold";
    static final String ERROR = "error";
    private final DisplayNameUpdater displayNameUpdater = new DisplayNameUpdater();
    private static final int INTERVAL = 200;
    private final BrokenStateUpdater brokenChecker = new BrokenStateUpdater();
    private final RequestProcessor rp;
    private final RequestProcessor.Task task;

    DecoratedNode(Children children, Lookup lookup) {
        super(children, lookup);
        Project project;
        RequestProcessor requestProcessor = (RequestProcessor)lookup.lookup(RequestProcessor.class);
        if (requestProcessor == null && (requestProcessor = (RequestProcessor)(project = (Project)lookup.lookup(Project.class)).getLookup().lookup(RequestProcessor.class)) == null) {
            requestProcessor = new RequestProcessor();
        }
        this.rp = requestProcessor;
        this.task = this.rp.create((Runnable)this.brokenChecker);
        this.task.schedule(400);
    }

    public DecoratedNode(Children children, Lookup lookup, String string, String string2, String string3) {
        this(children, lookup);
        this.setName(string);
        if (string2 != null) {
            this.setDisplayName(string2);
        }
        if (string3 != null) {
            this.setIconBaseWithExtension(string3);
        }
    }

    protected boolean isAlive() {
        for (DecoratedNode decoratedNode = this; decoratedNode != null; decoratedNode = decoratedNode.getParentNode()) {
            boolean bl = decoratedNode instanceof J2MEProjectRootNode;
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public final void setName(String string) {
        if (string.equals(this.getName())) {
            this.fireDisplayNameChange(null, null);
        } else {
            super.setName(string);
        }
    }

    public final void setValue(String string, Object object) {
        super.setValue(string, object);
        if (GRAY.equals(string) || BOLD.equals(string) || ERROR.equals(string)) {
            EventQueue.invokeLater(this.displayNameUpdater);
        }
    }

    public String getHtmlDisplayName() {
        String string = this.getDisplayName();
        try {
            string = XMLUtil.toElementContent((String)string);
        }
        catch (CharConversionException charConversionException) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = Boolean.TRUE.equals(this.getValue(BOLD));
        if (bl) {
            stringBuilder.append("<B>");
        }
        boolean bl2 = Boolean.TRUE.equals(this.getValue(ERROR));
        boolean bl3 = Boolean.TRUE.equals(this.getValue(GRAY));
        if (bl2) {
            stringBuilder.append("<font color=\"!nb.errorForeground\">");
        } else if (bl3) {
            stringBuilder.append("<font color=\"!controlShadow\">");
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public Image getIcon(int n) {
        Image image = super.getIcon(n);
        boolean bl = Boolean.TRUE.equals(this.getValue(ERROR));
        return bl ? ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/mobility/project/ui/resources/brokenProjectBadge.gif"), (int)8, (int)0) : image;
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    protected final void checkBroken() {
        if (this.getParentNode() != null) {
            this.task.schedule(200);
        }
    }

    protected boolean isBroken() {
        return false;
    }

    private final class BrokenStateUpdater
    implements Runnable {
        private BrokenStateUpdater() {
        }

        public void run() {
            DecoratedNode.this.setValue(DecoratedNode.ERROR, DecoratedNode.this.isBroken());
        }
    }

    private final class DisplayNameUpdater
    implements Runnable {
        private DisplayNameUpdater() {
        }

        public void run() {
            DecoratedNode.this.fireDisplayNameChange(null, null);
            DecoratedNode.this.fireIconChange();
            DecoratedNode.this.fireOpenedIconChange();
        }
    }
}

