/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.mobility.project.PropertyDescriptor;
import org.netbeans.api.mobility.project.ui.customizer.ProjectProperties;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.mobility.project.ui.customizer.CustomizerGeneral;
import org.netbeans.modules.mobility.project.ui.customizer.VisualClassPathItem;
import org.netbeans.spi.mobility.deployment.DeploymentPlugin;
import org.netbeans.spi.mobility.project.ProjectPropertiesDescriptor;
import org.netbeans.spi.mobility.project.PropertyParser;
import org.netbeans.spi.mobility.project.support.DefaultPropertyParsers;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2MEProjectProperties
implements ProjectProperties {
    public static final String J2ME_PROJECT_NAME = "j2me.project.name";
    public static final String PROP_CONFIGURATIONS = "configurations";
    public static final String CONFIG_PREFIX = "configs.";
    private static final String LIBS = "${libs.";
    private final Set<PropertyDescriptor> PROPERTY_DESCRIPTORS = new HashSet<PropertyDescriptor>();
    private Project project;
    protected ReferenceHelper refHelper;
    protected AntProjectHelper antProjectHelper;
    protected HashMap<String, PropertyInfo> properties;
    protected ProjectConfigurationsHelper configHelper;
    protected ProjectConfiguration[] devConfigs;

    private void initPropertyDescriptors() {
        Collection collection = Lookup.getDefault().lookupAll(ProjectPropertiesDescriptor.class);
        for (ProjectPropertiesDescriptor projectPropertiesDescriptor : collection) {
            try {
                this.PROPERTY_DESCRIPTORS.addAll(projectPropertiesDescriptor.getPropertyDescriptors());
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                Map.Entry entry = new ConcurrentModificationException("Property descriptor class " + projectPropertiesDescriptor.getClass().getName() + " should return a " + "defensive copy of its property descriptors - they have" + "been modified");
                Exceptions.printStackTrace((Throwable)((Object)entry));
            }
        }
        for (ProjectPropertiesDescriptor projectPropertiesDescriptor : Lookup.getDefault().lookup(new Lookup.Template(DeploymentPlugin.class)).allInstances()) {
            for (Map.Entry entry : projectPropertiesDescriptor.getProjectPropertyDefaultValues().entrySet()) {
                Object v = entry.getValue();
                PropertyParser propertyParser = v instanceof Boolean ? DefaultPropertyParsers.BOOLEAN_PARSER : (v instanceof Integer ? DefaultPropertyParsers.INTEGER_PARSER : (v instanceof String ? DefaultPropertyParsers.STRING_PARSER : (v instanceof File ? DefaultPropertyParsers.FILE_REFERENCE_PARSER : null)));
                if (propertyParser == null) continue;
                this.PROPERTY_DESCRIPTORS.add(new PropertyDescriptor((String)entry.getKey(), true, propertyParser, v.toString()));
            }
        }
    }

    public J2MEProjectProperties(Project project, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, ProjectConfigurationsHelper projectConfigurationsHelper) {
        this.project = project;
        this.properties = new HashMap();
        this.antProjectHelper = antProjectHelper;
        this.refHelper = referenceHelper;
        this.configHelper = projectConfigurationsHelper;
        this.initPropertyDescriptors();
        this.read();
    }

    public synchronized void setActiveConfiguration(ProjectConfiguration projectConfiguration) {
        this.put("config.active", (Object)(projectConfiguration == null || this.configHelper.getDefaultConfiguration().equals(projectConfiguration) ? "" : projectConfiguration.getDisplayName()));
    }

    public synchronized ProjectConfiguration getActiveConfiguration() {
        String string = (String)this.get("config.active");
        if (this.devConfigs == null || string == null || string.length() == 0) {
            return this.configHelper.getDefaultConfiguration();
        }
        for (int i = 0; i < this.devConfigs.length; ++i) {
            if (!string.equals(this.devConfigs[i].getDisplayName())) continue;
            return this.devConfigs[i];
        }
        return this.configHelper.getDefaultConfiguration();
    }

    static String getAntPropertyName(String string) {
        if (string != null && string.startsWith("${") && string.endsWith("}")) {
            return string.substring(2, string.length() - 1);
        }
        return string;
    }

    AntProjectHelper getHelper() {
        return this.antProjectHelper;
    }

    private PropertyDescriptor findPropertyDescriptor(String string) {
        for (PropertyDescriptor propertyDescriptor : this.PROPERTY_DESCRIPTORS) {
            if (!propertyDescriptor.getName().equals(string) && (!string.startsWith(CONFIG_PREFIX) || !string.endsWith('.' + propertyDescriptor.getName()))) continue;
            return propertyDescriptor;
        }
        return null;
    }

    @Override
    public Object put(String string, Object object) {
        Object object2;
        PropertyInfo propertyInfo = this.properties.get(string);
        if (propertyInfo == null) {
            object2 = this.findPropertyDescriptor(string);
            assert (object2 != null) : "Unknown property " + string;
            propertyInfo = new PropertyInfo(((PropertyDescriptor)object2).clone(string), null);
            this.properties.put(string, propertyInfo);
        }
        object2 = propertyInfo.getValue();
        propertyInfo.setValue(object);
        return object2;
    }

    void putPropertyRawValue(Object object, String string) {
        PropertyInfo propertyInfo = this.properties.get(object);
        if (propertyInfo == null) {
            PropertyDescriptor propertyDescriptor = this.findPropertyDescriptor((String)object);
            assert (propertyDescriptor != null) : "Unknown property " + object;
            propertyInfo = new PropertyInfo(propertyDescriptor.clone((String)object), null);
            this.properties.put((String)object, propertyInfo);
        }
        propertyInfo.setRawValue(string);
    }

    @Override
    public Object get(Object object) {
        PropertyInfo propertyInfo = this.properties.get(object);
        return propertyInfo == null ? null : propertyInfo.getValue();
    }

    public String getPropertyRawValue(Object object) {
        PropertyInfo propertyInfo = this.properties.get(object);
        return propertyInfo == null ? null : propertyInfo.getRawValue();
    }

    public boolean isModified(String string) {
        PropertyInfo propertyInfo = this.properties.get(string);
        assert (propertyInfo != null) : "Unknown property " + string;
        return propertyInfo.isModified();
    }

    @Override
    public ProjectConfiguration[] getConfigurations() {
        return this.devConfigs;
    }

    public final synchronized void setConfigurations(ProjectConfiguration[] projectConfigurationArray) {
        this.devConfigs = projectConfigurationArray;
    }

    public List<String> getAllIdentifiers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.devConfigs.length; ++i) {
            arrayList.add(this.devConfigs[i].getDisplayName());
            Map map = (Map)this.get(this.configHelper.getDefaultConfiguration().equals(this.devConfigs[i]) ? "abilities" : CONFIG_PREFIX + this.devConfigs[i].getDisplayName() + '.' + "abilities");
            if (map == null) continue;
            arrayList.addAll(map.keySet());
        }
        return arrayList;
    }

    @Override
    public FileObject getProjectDirectory() {
        return this.project.getProjectDirectory();
    }

    @Override
    public FileObject getSourceRoot() {
        return this.antProjectHelper.resolveFileObject(this.antProjectHelper.getStandardPropertyEvaluator().getProperty("src.dir"));
    }

    public String toString() {
        return super.toString() + "{project=" + this.project + " properties=" + this.properties + '}';
    }

    private void read() {
        EditableProperties editableProperties = this.antProjectHelper.getProperties("nbproject/project.properties");
        EditableProperties editableProperties2 = this.antProjectHelper.getProperties("nbproject/private/private.properties");
        ProjectConfiguration[] projectConfigurationArray = this.configHelper.getConfigurations().toArray(new ProjectConfiguration[0]);
        ProjectConfiguration[] projectConfigurationArray2 = new ProjectConfiguration[projectConfigurationArray.length];
        System.arraycopy(projectConfigurationArray, 0, projectConfigurationArray2, 0, projectConfigurationArray.length);
        this.setConfigurations(projectConfigurationArray2);
        this.properties.put(J2ME_PROJECT_NAME, new PropertyInfo(new PropertyDescriptor(J2ME_PROJECT_NAME, true, DefaultPropertyParsers.STRING_PARSER), ProjectUtils.getInformation((Project)this.project).getDisplayName()));
        for (PropertyDescriptor propertyDescriptor : this.PROPERTY_DESCRIPTORS) {
            EditableProperties editableProperties3 = propertyDescriptor.isShared() ? editableProperties : editableProperties2;
            String string = editableProperties3.getProperty(propertyDescriptor.getName());
            this.properties.put(propertyDescriptor.getName(), new PropertyInfo(propertyDescriptor, string == null ? propertyDescriptor.getDefaultValue() : string));
            for (int i = 0; i < this.devConfigs.length; ++i) {
                PropertyDescriptor propertyDescriptor2 = propertyDescriptor.clone(CONFIG_PREFIX + this.devConfigs[i].getDisplayName() + '.' + propertyDescriptor.getName());
                string = editableProperties3.getProperty(propertyDescriptor2.getName());
                if (string == null) continue;
                this.properties.put(propertyDescriptor2.getName(), new PropertyInfo(propertyDescriptor2, string));
            }
        }
    }

    public void store() {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Object>(){

                public Object run() {
                    ProjectConfiguration projectConfiguration2;
                    J2MEProjectProperties.this.resolveProjectDependencies();
                    for (PropertyInfo object22 : J2MEProjectProperties.this.properties.values()) {
                        object22.encode();
                    }
                    ProjectConfiguration[] projectConfigurationArray = J2MEProjectProperties.this.configHelper.getConfigurations().toArray(new ProjectConfiguration[0]);
                    HashSet<ProjectConfiguration> hashSet = new HashSet<ProjectConfiguration>(Arrays.asList(J2MEProjectProperties.this.devConfigs));
                    for (int editableProperties = 0; editableProperties < projectConfigurationArray.length; ++editableProperties) {
                        if (hashSet.remove(projectConfigurationArray[editableProperties])) continue;
                        J2MEProjectProperties.this.configHelper.removeConfiguration(projectConfigurationArray[editableProperties]);
                    }
                    for (ProjectConfiguration projectConfiguration2 : hashSet) {
                        J2MEProjectProperties.this.configHelper.addConfiguration(projectConfiguration2.getDisplayName());
                    }
                    EditableProperties editableProperties = J2MEProjectProperties.this.antProjectHelper.getProperties("nbproject/project.properties");
                    projectConfiguration2 = J2MEProjectProperties.this.antProjectHelper.getProperties("nbproject/private/private.properties");
                    for (PropertyInfo propertyInfo : J2MEProjectProperties.this.properties.values()) {
                        PropertyDescriptor propertyDescriptor = propertyInfo.getPropertyDescriptor();
                        if (propertyDescriptor == null || !propertyInfo.isModified()) continue;
                        String string = propertyInfo.getNewValueEncoded();
                        if (string != null) {
                            (propertyDescriptor.isShared() ? editableProperties : projectConfiguration2).setProperty(propertyDescriptor.getName(), string);
                            continue;
                        }
                        (propertyDescriptor.isShared() ? editableProperties : projectConfiguration2).remove((Object)propertyDescriptor.getName());
                    }
                    J2MEProjectProperties.this.antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                    J2MEProjectProperties.this.antProjectHelper.putProperties("nbproject/private/private.properties", (EditableProperties)projectConfiguration2);
                    CustomizerGeneral customizerGeneral = new CustomizerGeneral();
                    customizerGeneral.initValues(J2MEProjectProperties.this, null);
                    customizerGeneral.getSortedSubprojectsList();
                    String string = editableProperties.getProperty("javac.encoding");
                    if (string != null) {
                        FileEncodingQuery.setDefaultEncoding((Charset)Charset.forName(string));
                    }
                    try {
                        ProjectManager.getDefault().saveProject(J2MEProjectProperties.this.project);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            ErrorManager.getDefault().notify((Throwable)mutexException.getException());
        }
    }

    protected void resolveProjectDependencies() {
        Object object;
        Object bl;
        Object object2;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (PropertyInfo object52 : this.properties.values()) {
            if (object52 == null) continue;
            if (object52.getPropertyDescriptor().getPropertyParser() == DefaultPropertyParsers.PATH_PARSER) {
                object2 = (List)object52.getOldValue();
                if (object2 != null) {
                    bl = object2.iterator();
                    while (bl.hasNext()) {
                        hashSet.add(((VisualClassPathItem)bl.next()).getRawText());
                    }
                }
                if ((bl = (List)object52.getValue()) == null) continue;
                object = bl.iterator();
                while (object.hasNext()) {
                    hashSet2.add(((VisualClassPathItem)object.next()).getRawText());
                }
                continue;
            }
            if (object52.getPropertyDescriptor().getPropertyParser() != DefaultPropertyParsers.FILE_REFERENCE_PARSER) continue;
            hashSet.add(object52.getOldRawValue());
            hashSet2.add(object52.getRawValue());
        }
        HashSet hashSet3 = new HashSet(hashSet);
        hashSet3.removeAll(hashSet2);
        HashSet hashSet4 = new HashSet(hashSet2);
        hashSet4.removeAll(hashSet);
        object2 = hashSet3.iterator();
        while (object2.hasNext()) {
            bl = (String)object2.next();
            if (bl == null || ((String)bl).startsWith(LIBS)) continue;
            this.refHelper.destroyReference((String)bl);
        }
        object2 = this.antProjectHelper.getProperties("nbproject/project.properties");
        boolean bl2 = false;
        object = hashSet3.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (string == null || !string.startsWith(LIBS)) continue;
            object2.remove((Object)string.substring(2, string.length() - 1));
            bl2 = true;
        }
        object = FileUtil.toFile((FileObject)this.antProjectHelper.getProjectDirectory());
        for (String string : hashSet4) {
            String string2;
            if (string == null || !string.startsWith(LIBS) || (string2 = this.relativizeLibraryClasspath(string = string.substring(2, string.length() - 1), (File)object)) == null) continue;
            object2.setProperty(string, string2);
            object2.setComment(string, new String[]{NbBundle.getMessage(J2MEProjectProperties.class, (String)"DESC_J2MEProps_CommentLine1", (Object)string), NbBundle.getMessage(J2MEProjectProperties.class, (String)"DESC_J2MEProps_CommentLine2")}, false);
            bl2 = true;
        }
        if (bl2) {
            this.antProjectHelper.putProperties("nbproject/project.properties", (EditableProperties)object2);
        }
    }

    private String relativizeLibraryClasspath(String string, File file) {
        String string2 = PropertyUtils.getGlobalProperties().getProperty(string);
        if (string2 == null) {
            return null;
        }
        String[] stringArray = PropertyUtils.tokenizePath((String)string2);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = this.antProjectHelper.resolveFile(stringArray[i]);
            if (!CollocationQuery.areCollocated((File)file2, (File)file)) {
                return null;
            }
            stringBuffer.append(PropertyUtils.relativizeFile((File)file, (File)file2));
            if (i + 1 >= stringArray.length) continue;
            stringBuffer.append(File.pathSeparatorChar);
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.properties.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.properties.containsValue(object);
    }

    @Override
    public Set entrySet() {
        return Collections.unmodifiableSet(this.properties.entrySet());
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    @Override
    public void putAll(Map map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object object) {
        return this.containsKey(object) ? this.put((String)object, (Object)null) : null;
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public Collection values() {
        return Collections.unmodifiableCollection(this.properties.values());
    }

    private class PropertyInfo {
        protected final PropertyDescriptor propertyDesciptor;
        private final String rawValue;
        private final Object value;
        private Object newValue;
        private String newValueEncoded;
        private boolean modified;

        public PropertyInfo(PropertyDescriptor propertyDescriptor, String string) {
            this.propertyDesciptor = propertyDescriptor;
            this.rawValue = string;
            this.value = string == null ? null : propertyDescriptor.getPropertyParser().decode(string, J2MEProjectProperties.this.antProjectHelper, J2MEProjectProperties.this.refHelper);
            this.newValue = null;
        }

        public String toString() {
            return super.toString() + "[rawvalue=" + this.rawValue + ", value=" + this.value + ", newValue=" + this.newValue + ", newValueEncoded=" + this.newValueEncoded + " modified=" + this.modified + "]";
        }

        public PropertyDescriptor getPropertyDescriptor() {
            return this.propertyDesciptor;
        }

        public void encode() {
            this.newValueEncoded = this.isModified() && this.newValue != null ? this.propertyDesciptor.getPropertyParser().encode(this.newValue, J2MEProjectProperties.this.antProjectHelper, J2MEProjectProperties.this.refHelper) : null;
        }

        public Object getValue() {
            return this.isModified() ? this.newValue : this.value;
        }

        public String getRawValue() {
            this.encode();
            return this.isModified() ? this.newValueEncoded : this.rawValue;
        }

        public void setValue(Object object) {
            this.newValue = object;
            this.modified = true;
        }

        public void setRawValue(String string) {
            this.setValue(string == null ? null : this.propertyDesciptor.getPropertyParser().decode(string, J2MEProjectProperties.this.antProjectHelper, J2MEProjectProperties.this.refHelper));
        }

        public String getNewValueEncoded() {
            return this.newValueEncoded;
        }

        public boolean isModified() {
            return this.modified;
        }

        public Object getOldValue() {
            return this.value;
        }

        public String getOldRawValue() {
            return this.rawValue;
        }
    }
}

