/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.modules.mobility.project.ui.customizer.ErrorPanel;
import org.netbeans.modules.mobility.project.ui.wizard.ConfigurationsSelectionPanelGUI;
import org.netbeans.spi.mobility.cfgfactory.ProjectConfigurationFactory;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewConfigurationPanel
extends JPanel
implements DocumentListener,
PropertyChangeListener,
VetoableChangeListener,
ExplorerManager.Provider {
    private DialogDescriptor dialogDescriptor;
    private final Collection<String> allNames;
    private final ExplorerManager manager = new ExplorerManager();
    private final BeanTreeView treeView;
    private String oldName;
    public static final Image CLOSED_ICON = NewConfigurationPanel.findIcon("Nb.Explorer.Folder.icon", "Tree.closedIcon");
    public static final Image OPENED_ICON = NewConfigurationPanel.findIcon("Nb.Explorer.Folder.openedIcon", "Tree.openIcon");
    private ErrorPanel errorPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JTextField jTextFieldName;

    public NewConfigurationPanel(Collection<String> collection) {
        this.allNames = collection;
        this.initComponents();
        this.initAccessibility();
        this.treeView = new BeanTreeView();
        this.jLabel2.setLabelFor((Component)this.treeView);
        this.treeView.setPopupAllowed(false);
        this.treeView.setRootVisible(false);
        this.treeView.setDefaultActionAllowed(false);
        this.treeView.setSelectionMode(1);
        this.jPanel1.add((Component)this.treeView, "Center");
        AbstractNode abstractNode = new AbstractNode((Children)new Children.Keys<ProjectConfigurationFactory>(){
            {
                this.setKeys(Lookup.getDefault().lookupAll(ProjectConfigurationFactory.class));
            }

            protected Node[] createNodes(ProjectConfigurationFactory projectConfigurationFactory) {
                return new Node[]{projectConfigurationFactory instanceof ProjectConfigurationFactory.ConfigurationTemplateDescriptor ? new TemplateNode((ProjectConfigurationFactory.ConfigurationTemplateDescriptor)projectConfigurationFactory) : new CategoryNode(projectConfigurationFactory.getRootCategory())};
            }
        });
        abstractNode.setName(NbBundle.getMessage(ConfigurationsSelectionPanelGUI.class, (String)"LBL_CfgSelectionPanel_Templates"));
        this.manager.setRootContext((Node)abstractNode);
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        try {
            this.manager.setSelectedNodes(new Node[]{(Node)abstractNode.getChildren().nodes().nextElement()});
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private static Image findIcon(String string, String string2) {
        Image image = NewConfigurationPanel.icon2image(string);
        return image == null ? NewConfigurationPanel.icon2image(string2) : image;
    }

    private static Image icon2image(String string) {
        Object object = UIManager.get(string);
        if (object instanceof Image) {
            return (Image)object;
        }
        if (object instanceof Icon) {
            Icon icon = (Icon)object;
            return ImageUtilities.icon2Image((Icon)icon);
        }
        return null;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    @Override
    public String getName() {
        return this.jTextFieldName == null ? "" : this.jTextFieldName.getText();
    }

    public ProjectConfigurationFactory.ConfigurationTemplateDescriptor getTemplate() {
        Node[] nodeArray = this.manager.getSelectedNodes();
        if (nodeArray.length != 1) {
            return null;
        }
        return (ProjectConfigurationFactory.ConfigurationTemplateDescriptor)nodeArray[0].getLookup().lookup(ProjectConfigurationFactory.ConfigurationTemplateDescriptor.class);
    }

    public void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        assert (this.dialogDescriptor == null) : "Set the dialog descriptor only once!";
        this.dialogDescriptor = dialogDescriptor;
        dialogDescriptor.setHelpCtx(new HelpCtx(NewConfigurationPanel.class));
        this.jTextFieldName.getDocument().addDocumentListener(this);
        this.changedUpdate(null);
        this.oldName = "";
    }

    public boolean isStateValid() {
        String string = this.jTextFieldName.getText();
        if (J2MEProjectUtils.ILEGAL_CONFIGURATION_NAMES.contains(string)) {
            this.errorPanel.setErrorBundleMessage("ERR_AddCfg_ReservedWord");
            return false;
        }
        if (!Utilities.isJavaIdentifier((String)string)) {
            this.errorPanel.setErrorBundleMessage("ERR_AddCfg_MustBeJavaIdentifier");
            return false;
        }
        if (this.allNames.contains(string)) {
            this.errorPanel.setErrorBundleMessage("ERR_AddCfg_NameExists");
            return false;
        }
        if (this.getTemplate() == null) {
            this.errorPanel.setErrorBundleMessage("ERR_AddCfg_SelectTmp");
            return false;
        }
        this.errorPanel.setErrorBundleMessage(null);
        return true;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.dialogDescriptor != null) {
            this.dialogDescriptor.setValid(this.isStateValid());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.changedUpdate(null);
        String string = this.jTextFieldName.getText();
        if (string.length() == 0 || string.equals(this.oldName)) {
            Node[] nodeArray = this.manager.getSelectedNodes();
            if (nodeArray.length != 1) {
                return;
            }
            ProjectConfigurationFactory.ConfigurationTemplateDescriptor configurationTemplateDescriptor = (ProjectConfigurationFactory.ConfigurationTemplateDescriptor)nodeArray[0].getLookup().lookup(ProjectConfigurationFactory.ConfigurationTemplateDescriptor.class);
            if (configurationTemplateDescriptor == null) {
                return;
            }
            this.jTextFieldName.setText(configurationTemplateDescriptor.getCfgName());
            this.oldName = this.jTextFieldName.getText();
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (propertyChangeEvent.getNewValue() instanceof Node[]) {
            Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
            if (nodeArray.length > 1) {
                throw new PropertyVetoException("Mutiselection is not alloved", propertyChangeEvent);
            }
            if (nodeArray.length == 0) {
                return;
            }
            if (nodeArray[0].getLookup().lookup(ProjectConfigurationFactory.ConfigurationTemplateDescriptor.class) == null) {
                throw new PropertyVetoException("Only configuration templates selection allowed", propertyChangeEvent);
            }
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.jTextFieldName.requestFocus();
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.errorPanel = new ErrorPanel();
        this.setMinimumSize(new Dimension(450, 200));
        this.setPreferredSize(new Dimension(480, 350));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(NewConfigurationPanel.class, (String)"LBL_NewConfigPanel_ConfigTemplate"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 5, 12);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanel1.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel1.setLabelFor(this.jTextFieldName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(NewConfigurationPanel.class, (String)"LBL_NewConfigPanel_ConfigurationName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 5, 0, 12);
        this.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jTextFieldName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConfigurationPanel.class, (String)"ACSD_NewCfg_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        this.add((Component)this.errorPanel, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConfigurationPanel.class, (String)"ACSN_NewConfigPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConfigurationPanel.class, (String)"ACSD_NewConfigPanel"));
    }

    private class TemplateNode
    extends AbstractNode {
        private ProjectConfigurationFactory.ConfigurationTemplateDescriptor cfgTmp;

        public TemplateNode(ProjectConfigurationFactory.ConfigurationTemplateDescriptor configurationTemplateDescriptor) {
            super(Children.LEAF, Lookups.singleton((Object)configurationTemplateDescriptor));
            this.cfgTmp = configurationTemplateDescriptor;
            this.setDisplayName(configurationTemplateDescriptor.getDisplayName().equals(configurationTemplateDescriptor.getCfgName()) || configurationTemplateDescriptor.getCfgName().length() == 0 ? configurationTemplateDescriptor.getDisplayName() : NbBundle.getMessage(ConfigurationsSelectionPanelGUI.class, (String)"LBL_CfgSlePanel_TemplateNodePattern", (Object)configurationTemplateDescriptor.getDisplayName(), (Object)configurationTemplateDescriptor.getCfgName()));
        }
    }

    private class CategoryNode
    extends AbstractNode {
        public CategoryNode(final ProjectConfigurationFactory.CategoryDescriptor categoryDescriptor) {
            super((Children)new Children.Keys<ProjectConfigurationFactory.Descriptor>(){
                {
                    this.setKeys(categoryDescriptor.getChildren());
                }

                protected Node[] createNodes(ProjectConfigurationFactory.Descriptor descriptor) {
                    Node[] nodeArray;
                    AbstractNode abstractNode;
                    AbstractNode abstractNode2 = descriptor instanceof ProjectConfigurationFactory.CategoryDescriptor ? new CategoryNode((ProjectConfigurationFactory.CategoryDescriptor)descriptor) : (abstractNode = descriptor instanceof ProjectConfigurationFactory.ConfigurationTemplateDescriptor ? new TemplateNode((ProjectConfigurationFactory.ConfigurationTemplateDescriptor)descriptor) : null);
                    if (abstractNode == null) {
                        nodeArray = null;
                    } else {
                        Node[] nodeArray2 = new Node[1];
                        nodeArray = nodeArray2;
                        nodeArray2[0] = abstractNode;
                    }
                    return nodeArray;
                }
            });
            this.setDisplayName(categoryDescriptor.getDisplayName());
        }

        public Image getIcon(int n) {
            return CLOSED_ICON == null ? super.getIcon(n) : CLOSED_ICON;
        }

        public Image getOpenedIcon(int n) {
            return OPENED_ICON == null ? super.getOpenedIcon(n) : OPENED_ICON;
        }
    }
}

