/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.project.ui.wizard.MIDPTargetChooserPanelGUI;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class MIDPTargetChooserPanel
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    public static final String MIDLET_NAME = "MidletName";
    public static final String MIDLET_CLASSNAME = "MidletClassName";
    public static final String MIDLET_ICON = "MidletIcon";
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private MIDPTargetChooserPanelGUI gui;
    private TemplateWizard templateWizard = null;

    MIDPTargetChooserPanel() {
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new MIDPTargetChooserPanelGUI();
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(MIDPTargetChooserPanel.class);
    }

    public boolean isValid() {
        String string = null;
        if (this.gui == null) {
            string = "ERR_File_NoGUI";
        } else if (this.gui.getTargetName() == null || "".equals(this.gui.getTargetName())) {
            string = "ERR_File_NoTargetName";
        } else if (this.gui.getCreatedFile() != null && new File(this.gui.getCreatedFile()).exists()) {
            string = "ERR_File_AlreadyExists";
        } else if (!Utilities.isJavaIdentifier((String)this.gui.getClassName())) {
            string = "ERR_File_InvalidClassName";
        } else if (!MIDPTargetChooserPanel.isValidJavaFolderName(this.gui.getPackageFileName())) {
            string = "ERR_File_InvalidPackageName";
        }
        if (this.templateWizard != null) {
            this.templateWizard.putProperty("WizardPanel_errorMessage", string != null ? NbBundle.getMessage(MIDPTargetChooserPanel.class, (String)string) : null);
        }
        return string == null;
    }

    private static boolean isValidJavaFolderName(String string) {
        if (string == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (Utilities.isJavaIdentifier((String)string2)) continue;
            return false;
        }
        return true;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public void readSettings(Object object) {
        this.templateWizard = (TemplateWizard)object;
        if (this.getComponent() != null) {
            Project project = Templates.getProject((WizardDescriptor)this.templateWizard);
            FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)this.templateWizard);
            this.gui.initValues(project, Templates.getTemplate((WizardDescriptor)this.templateWizard), fileObject);
        }
    }

    public void storeSettings(Object object) {
        this.templateWizard = (TemplateWizard)object;
        if (this.isValid()) {
            String string;
            FileObject fileObject = this.gui.getRootFolder();
            FileObject fileObject2 = fileObject.getFileObject(string = this.gui.getPackageFileName());
            if (fileObject2 == null) {
                try {
                    fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)string);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    return;
                }
            }
            Templates.setTargetFolder((WizardDescriptor)this.templateWizard, (FileObject)fileObject2);
            Templates.setTargetName((WizardDescriptor)this.templateWizard, (String)this.gui.getTargetName());
            if (this.gui.isMIDletTemplate()) {
                this.templateWizard.putProperty(MIDLET_NAME, (Object)this.gui.getMIDletName());
                this.templateWizard.putProperty(MIDLET_ICON, (Object)this.gui.getMIDletIcon());
                ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/source");
                String string2 = null;
                if (classPath != null) {
                    string2 = classPath.getResourceName(fileObject2, '.', false);
                }
                string2 = string2 != null && !"".equals(string2) ? string2 + "." + this.gui.getClassName() : this.gui.getClassName();
                ((WizardDescriptor)object).putProperty(MIDLET_CLASSNAME, (Object)string2);
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.templateWizard != null) {
            this.templateWizard.setValid(this.isValid());
        }
        this.fireChange();
    }

    public boolean isFinishPanel() {
        return true;
    }
}

