/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.InsufficientDataException;
import org.limewire.collection.Buffer;

public class BandwidthTrackerImpl {
    private static final int HISTORY_SIZE = 10;
    private final Buffer<Float> snapShots = new Buffer(10);
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private float cachedBandwidth = 0.0f;
    private long lastTime;
    private float measuredBandwidth;
    private long lastAmountRead64;

    public synchronized void measureBandwidth(long amountRead) {
        long currentTime = System.currentTimeMillis();
        if (this.lastAmountRead64 == 0L || currentTime == this.lastTime) {
            this.measuredBandwidth = 0.0f;
        } else {
            this.measuredBandwidth = (float)(amountRead - this.lastAmountRead64) / (float)(currentTime - this.lastTime);
            this.measuredBandwidth = Math.max(this.measuredBandwidth, 0.0f);
        }
        this.lastTime = currentTime;
        this.lastAmountRead64 = amountRead;
        this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + this.measuredBandwidth) / (float)(++this.numMeasures);
        this.snapShots.add(new Float(this.measuredBandwidth));
        this.cachedBandwidth = 0.0f;
    }

    public synchronized float getMeasuredBandwidth() throws InsufficientDataException {
        if (this.cachedBandwidth != 0.0f) {
            return this.cachedBandwidth;
        }
        int size = this.snapShots.getSize();
        if (size < 3) {
            throw new InsufficientDataException();
        }
        float total = 0.0f;
        for (Float f : this.snapShots) {
            total += f.floatValue();
        }
        this.cachedBandwidth = total / (float)size;
        return this.cachedBandwidth;
    }

    public synchronized float getAverageBandwidth() {
        if (this.snapShots.getSize() < 3) {
            return 0.0f;
        }
        return this.averageBandwidth;
    }
}

