/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.core.settings.ConnectionSettings;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;

@EagerSingleton
public final class ConnectionWatchdog
implements Service {
    private static final Log LOG = LogFactory.getLog(ConnectionWatchdog.class);
    private static final int EVALUATE_TIME = 30000;
    private static final int REEVALUATE_TIME = 15000;
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<MessageRouter> messageRouter;
    private final Provider<ConnectionManager> connectionManager;
    private final ConnectionServices connectionServices;
    private final PingRequestFactory pingRequestFactory;
    @InspectablePrimitive(value="old kill count")
    private volatile int oldKillCount;

    @Inject
    public ConnectionWatchdog(@Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<MessageRouter> messageRouter, Provider<ConnectionManager> connectionManager, ConnectionServices connectionServices, PingRequestFactory pingRequestFactory) {
        this.backgroundExecutor = backgroundExecutor;
        this.messageRouter = messageRouter;
        this.connectionManager = connectionManager;
        this.connectionServices = connectionServices;
        this.pingRequestFactory = pingRequestFactory;
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("Stale Connection Management");
    }

    @Override
    public void initialize() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void start() {
        this.findDuds();
    }

    private void findDuds() {
        HashMap<RoutedConnection, ConnectionState> snapshot = new HashMap<RoutedConnection, ConnectionState>();
        for (RoutedConnection c : this.allConnections()) {
            if (!c.isKillable()) continue;
            snapshot.put(c, new ConnectionState(c));
        }
        this.backgroundExecutor.schedule(new DudChecker(snapshot, false), 30000L, TimeUnit.MILLISECONDS);
    }

    private void killIfStillDud(List<? extends RoutedConnection> connections) {
        HashMap<RoutedConnection, ConnectionState> snapshot = new HashMap<RoutedConnection, ConnectionState>();
        for (RoutedConnection routedConnection : connections) {
            if (!routedConnection.isKillable()) continue;
            snapshot.put(routedConnection, new ConnectionState(routedConnection));
            PingRequest ping = this.pingRequestFactory.createPingRequest((byte)1);
            this.messageRouter.get().sendPingRequest(ping, routedConnection);
        }
        this.backgroundExecutor.schedule(new DudChecker(snapshot, true), 15000L, TimeUnit.MILLISECONDS);
    }

    private Iterable<RoutedConnection> allConnections() {
        List<RoutedConnection> normal = this.connectionManager.get().getInitializedConnections();
        List<RoutedConnection> leaves = this.connectionManager.get().getInitializedClientConnections();
        ArrayList<RoutedConnection> buf = new ArrayList<RoutedConnection>(normal.size() + leaves.size());
        buf.addAll(normal);
        buf.addAll(leaves);
        return buf;
    }

    private class DudChecker
    implements Runnable {
        private Map<RoutedConnection, ConnectionState> snapshots;
        private boolean kill;

        DudChecker(Map<RoutedConnection, ConnectionState> snapshots, boolean kill) {
            this.snapshots = snapshots;
            this.kill = kill;
        }

        @Override
        public void run() {
            List potentials = this.kill ? Collections.emptyList() : new ArrayList();
            for (RoutedConnection c : ConnectionWatchdog.this.allConnections()) {
                ConnectionState currentState;
                ConnectionState oldState;
                if (!c.isKillable() || (oldState = this.snapshots.get(c)) == null || !(currentState = new ConnectionState(c)).notProgressedSince(oldState)) continue;
                if (this.kill) {
                    if (!ConnectionSettings.WATCHDOG_ACTIVE.getValue()) continue;
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Killing connection: " + c);
                    }
                    ConnectionWatchdog.this.connectionServices.removeConnection(c);
                    continue;
                }
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Potential dud: " + c);
                }
                potentials.add(c);
            }
            if (potentials.isEmpty()) {
                ConnectionWatchdog.this.findDuds();
            } else {
                ConnectionWatchdog.this.killIfStillDud(potentials);
            }
        }
    }

    private class ConnectionState {
        final long sentDropped;
        final long sent;
        final long received;
        private long bytesReceived;
        private long bytesSent;

        ConnectionState(RoutedConnection c) {
            this.sentDropped = c.getConnectionMessageStatistics().getNumSentMessagesDropped();
            this.sent = c.getConnectionMessageStatistics().getNumMessagesSent();
            this.received = c.getConnectionMessageStatistics().getNumMessagesReceived();
            this.bytesReceived = c.getConnectionBandwidthStatistics().getBytesReceived();
            this.bytesSent = c.getConnectionBandwidthStatistics().getBytesSent();
        }

        boolean notProgressedSince(ConnectionState old) {
            long numSent = this.sent - old.sent;
            long numSentDropped = this.sentDropped - old.sentDropped;
            long numReceived = this.received - old.received;
            long numBytesReceived = this.bytesReceived - old.bytesReceived;
            long numBytesSent = this.bytesSent - old.bytesSent;
            if (numSent == numSentDropped && numSent != 0L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(numBytesSent + " all sent messages dropped");
                }
                if (numBytesSent < (long)ConnectionSettings.MIN_BYTES_SENT.getValue()) {
                    return true;
                }
                ++ConnectionWatchdog.this.oldKillCount;
                return false;
            }
            if (numReceived == 0L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(numBytesReceived + " no messages received");
                }
                if (numBytesReceived < (long)ConnectionSettings.MIN_BYTES_RECEIVED.getValue()) {
                    return true;
                }
                ++ConnectionWatchdog.this.oldKillCount;
                return false;
            }
            return false;
        }

        public String toString() {
            return "{sent: " + this.sent + ", sdropped: " + this.sentDropped + "}";
        }
    }
}

