/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.UDPPingerImpl;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequestFactory;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;

@Singleton
public class UniqueHostPinger
extends UDPPingerImpl {
    private final Set<IpPort> _recent = new IpPortSet();

    @Inject
    public UniqueHostPinger(Provider<MessageRouter> messageRouter, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<UDPService> udpService, PingRequestFactory pingRequestFactory) {
        super(messageRouter, backgroundExecutor, udpService, pingRequestFactory);
    }

    @Override
    protected void sendSingleMessage(IpPort host, Message m) {
        if (this._recent.contains(host)) {
            return;
        }
        this._recent.add(host);
        super.sendSingleMessage(host, m);
    }

    void resetData() {
        QUEUE.execute(new Runnable(){

            @Override
            public void run() {
                UniqueHostPinger.this._recent.clear();
            }
        });
    }
}

