/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.http.HTTPUtils;
import java.io.IOException;
import java.util.StringTokenizer;
import org.limewire.collection.BitNumbers;
import org.limewire.collection.Function;

public class AltLocUtils {
    private AltLocUtils() {
    }

    public static void parseAlternateLocations(URN sha1, String locations, boolean allowTLS, AlternateLocationFactory alternateLocationFactory, Function<AlternateLocation, Void> function) {
        AltLocUtils.parseAlternateLocations(sha1, locations, allowTLS, alternateLocationFactory, function, false);
    }

    public static void parseAlternateLocations(URN sha1, String locations, boolean allowTLS, AlternateLocationFactory alternateLocationFactory, Function<AlternateLocation, Void> function, boolean allowMe) {
        if (locations == null) {
            return;
        }
        if (sha1 == null) {
            return;
        }
        BitNumbers tlsIdx = null;
        StringTokenizer st = new StringTokenizer(locations, ",");
        int idx = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (allowTLS && tlsIdx == null && token.startsWith("tls=")) {
                tlsIdx = BitNumbers.EMPTY_BN;
                try {
                    String value = HTTPUtils.parseValue(token);
                    if (value == null) continue;
                    try {
                        tlsIdx = new BitNumbers(value);
                    }
                    catch (IllegalArgumentException ignored) {
                    }
                }
                catch (IOException invalid) {}
                continue;
            }
            if (tlsIdx == null) {
                tlsIdx = BitNumbers.EMPTY_BN;
            }
            try {
                AlternateLocation al = alternateLocationFactory.create(token, sha1, tlsIdx.isSet(idx));
                ++idx;
                assert (al.getSHA1Urn().equals(sha1)) : "sha1 mismatch!";
                if (al.isMe() && !allowMe) continue;
                function.apply(al);
            }
            catch (IOException e) {
                tlsIdx = BitNumbers.EMPTY_BN;
            }
        }
    }
}

