/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.downloader.DownloadStatsTracker;
import com.limegroup.gnutella.downloader.DownloadWorker;
import com.limegroup.gnutella.downloader.DownloadWorkerFactory;
import com.limegroup.gnutella.downloader.DownloadWorkerSupport;
import com.limegroup.gnutella.downloader.HTTPDownloaderFactory;
import com.limegroup.gnutella.downloader.PushDownloadManager;
import com.limegroup.gnutella.downloader.RemoteFileDescContext;
import com.limegroup.gnutella.downloader.VerifyingFile;
import java.util.concurrent.ScheduledExecutorService;
import org.limewire.core.api.network.BandwidthCollector;
import org.limewire.inspection.InspectionPoint;
import org.limewire.net.SocketsManager;
import org.limewire.net.TLSManager;

@Singleton
class DownloadWorkerFactoryImpl
implements DownloadWorkerFactory {
    private final HTTPDownloaderFactory httpDownloaderFactory;
    private final ScheduledExecutorService backgroundExecutor;
    private final ScheduledExecutorService nioExecutor;
    private final Provider<PushDownloadManager> pushDownloadManager;
    private final SocketsManager socketsManager;
    @InspectionPoint(value="download connection stats")
    private final DownloadStatsTracker statsTracker;
    private final TLSManager TLSManager;
    private final BandwidthCollector bandwidthCollector;

    @Inject
    public DownloadWorkerFactoryImpl(HTTPDownloaderFactory httpDownloaderFactory, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, @Named(value="nioExecutor") ScheduledExecutorService nioExecutor, Provider<PushDownloadManager> pushDownloadManager, SocketsManager socketsManager, DownloadStatsTracker statsTracker, TLSManager TLSManager2, BandwidthCollector bandwidthCollector) {
        this.httpDownloaderFactory = httpDownloaderFactory;
        this.backgroundExecutor = backgroundExecutor;
        this.nioExecutor = nioExecutor;
        this.pushDownloadManager = pushDownloadManager;
        this.socketsManager = socketsManager;
        this.statsTracker = statsTracker;
        this.TLSManager = TLSManager2;
        this.bandwidthCollector = bandwidthCollector;
    }

    @Override
    public DownloadWorker create(DownloadWorkerSupport manager, RemoteFileDescContext rfdContext, VerifyingFile vf) {
        return new DownloadWorker(manager, rfdContext, vf, this.httpDownloaderFactory, this.backgroundExecutor, this.nioExecutor, this.pushDownloadManager, this.socketsManager, this.statsTracker, this.TLSManager, this.bandwidthCollector);
    }
}

