/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.DownloadCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.DiskController;
import com.limegroup.gnutella.downloader.DownloadWorkerFactory;
import com.limegroup.gnutella.downloader.DownloaderType;
import com.limegroup.gnutella.downloader.InNetworkDownloader;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.LegacyRanker;
import com.limegroup.gnutella.downloader.ManagedDownloaderImpl;
import com.limegroup.gnutella.downloader.PushList;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.downloader.RequeryManagerFactory;
import com.limegroup.gnutella.downloader.SourceRanker;
import com.limegroup.gnutella.downloader.SourceRankerFactory;
import com.limegroup.gnutella.downloader.VerifyingFileFactory;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.gnutella.downloader.serial.InNetworkDownloadMemento;
import com.limegroup.gnutella.downloader.serial.InNetworkDownloadMementoImpl;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.library.FileCollection;
import com.limegroup.gnutella.library.GnutellaFiles;
import com.limegroup.gnutella.library.Library;
import com.limegroup.gnutella.library.LibraryUtils;
import com.limegroup.gnutella.library.UrnCache;
import com.limegroup.gnutella.malware.DangerousFileChecker;
import com.limegroup.gnutella.malware.VirusScanner;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.spam.SpamManager;
import com.limegroup.gnutella.tigertree.HashTreeCache;
import com.limegroup.gnutella.version.DownloadInformation;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import org.limewire.activation.api.ActivationManager;
import org.limewire.concurrent.ListeningExecutorService;
import org.limewire.core.api.download.DownloadException;
import org.limewire.core.api.download.SaveLocationManager;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.api.network.BandwidthCollector;
import org.limewire.io.InvalidDataException;
import org.limewire.net.SocketsManager;

class InNetworkDownloaderImpl
extends ManagedDownloaderImpl
implements InNetworkDownloader {
    private String tigerTreeRoot;
    private long startTime;
    private int downloadAttempts;

    @Inject
    InNetworkDownloaderImpl(SaveLocationManager saveLocationManager, DownloadManager downloadManager, @GnutellaFiles FileCollection gnutellaFileCollection, IncompleteFileManager incompleteFileManager, DownloadCallback downloadCallback, NetworkManager networkManager, AlternateLocationFactory alternateLocationFactory, RequeryManagerFactory requeryManagerFactory, QueryRequestFactory queryRequestFactory, OnDemandUnicaster onDemandUnicaster, DownloadWorkerFactory downloadWorkerFactory, AltLocManager altLocManager, ContentManager contentManager, SourceRankerFactory sourceRankerFactory, UrnCache urnCache, VerifyingFileFactory verifyingFileFactory, DiskController diskController, IPFilter ipFilter, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<MessageRouter> messageRouter, Provider<HashTreeCache> tigerTreeCache, ApplicationServices applicationServices, RemoteFileDescFactory remoteFileDescFactory, Provider<PushList> pushListProvider, SocketsManager socketsManager, @Named(value="downloadStateProcessingQueue") ListeningExecutorService downloadStateProcessingQueue, DangerousFileChecker dangerousFileChecker, VirusScanner virusScanner, SpamManager spamManager, Library library, CategoryManager categoryManager, BandwidthCollector bandwidthCollector, ActivationManager activationManager) throws DownloadException {
        super(saveLocationManager, downloadManager, gnutellaFileCollection, incompleteFileManager, downloadCallback, networkManager, alternateLocationFactory, requeryManagerFactory, queryRequestFactory, onDemandUnicaster, downloadWorkerFactory, altLocManager, contentManager, sourceRankerFactory, urnCache, verifyingFileFactory, diskController, ipFilter, backgroundExecutor, messageRouter, tigerTreeCache, applicationServices, remoteFileDescFactory, pushListProvider, socketsManager, downloadStateProcessingQueue, dangerousFileChecker, virusScanner, spamManager, library, categoryManager, bandwidthCollector, activationManager);
    }

    @Override
    public void initDownloadInformation(DownloadInformation downloadInformation, long startTime) {
        if (downloadInformation.getSize() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size too big for now.");
        }
        this.setContentLength(downloadInformation.getSize());
        if (downloadInformation.getUpdateURN() != null) {
            this.setSha1Urn(downloadInformation.getUpdateURN());
        }
        this.setTigerTreeRoot(downloadInformation.getTTRoot());
        this.setStartTime(startTime);
        this.setDownloadAttempts(0);
    }

    protected synchronized void setDownloadAttempts(int i) {
        this.downloadAttempts = i;
    }

    protected synchronized void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    protected synchronized void setTigerTreeRoot(String tigerTreeRoot) {
        this.tigerTreeRoot = tigerTreeRoot;
    }

    @Override
    protected File getIncompleteFile(String name, URN urn, long length) throws IOException {
        return this.incompleteFileManager.getFile(name, urn, length, new File(LibraryUtils.PREFERENCE_SHARE, "Incomplete"));
    }

    @Override
    protected SourceRanker getSourceRanker(SourceRanker oldRanker) {
        if (oldRanker != null) {
            return oldRanker;
        }
        return new LegacyRanker();
    }

    @Override
    public synchronized void startDownload() {
        this.incrementDownloadAttempts();
        super.startDownload();
    }

    private synchronized void incrementDownloadAttempts() {
        ++this.downloadAttempts;
    }

    @Override
    protected boolean shouldValidate() {
        return false;
    }

    @Override
    protected void initializeVerifyingFile() throws IOException {
        super.initializeVerifyingFile();
        if (this.commonOutFile != null) {
            this.commonOutFile.setExpectedHashTreeRoot(this.getTigerTreeRoot());
        }
    }

    protected synchronized String getTigerTreeRoot() {
        return this.tigerTreeRoot;
    }

    @Override
    public synchronized QueryRequest newRequery() throws CantResumeException {
        QueryRequest qr = super.newRequery();
        qr.setTTL((byte)2);
        return qr;
    }

    @Override
    public synchronized int getDownloadAttempts() {
        return this.downloadAttempts;
    }

    @Override
    public synchronized long getStartTime() {
        return this.startTime;
    }

    @Override
    public DownloaderType getDownloadType() {
        return DownloaderType.INNETWORK;
    }

    @Override
    protected void fillInMemento(DownloadMemento memento) {
        super.fillInMemento(memento);
        InNetworkDownloadMemento imem = (InNetworkDownloadMemento)memento;
        imem.setTigerTreeRoot(this.getTigerTreeRoot());
        imem.setStartTime(this.getStartTime());
        imem.setDownloadAttempts(this.getDownloadAttempts());
    }

    @Override
    protected DownloadMemento createMemento() {
        return new InNetworkDownloadMementoImpl();
    }

    @Override
    public synchronized void initFromMemento(DownloadMemento memento) throws InvalidDataException {
        super.initFromMemento(memento);
        InNetworkDownloadMemento imem = (InNetworkDownloadMemento)memento;
        this.setTigerTreeRoot(imem.getTigerTreeRoot());
        this.setStartTime(imem.getStartTime());
        this.setDownloadAttempts(imem.getDownloadAttempts());
    }
}

