/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.DownloadCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.DiskController;
import com.limegroup.gnutella.downloader.DownloadWorkerFactory;
import com.limegroup.gnutella.downloader.DownloaderType;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.ManagedDownloaderImpl;
import com.limegroup.gnutella.downloader.PushList;
import com.limegroup.gnutella.downloader.RemoteFileDescContext;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.downloader.RequeryManagerFactory;
import com.limegroup.gnutella.downloader.SourceRanker;
import com.limegroup.gnutella.downloader.SourceRankerFactory;
import com.limegroup.gnutella.downloader.StoreDownloader;
import com.limegroup.gnutella.downloader.VerifyingFileFactory;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.library.FileCollection;
import com.limegroup.gnutella.library.GnutellaFiles;
import com.limegroup.gnutella.library.Library;
import com.limegroup.gnutella.library.UrnCache;
import com.limegroup.gnutella.malware.DangerousFileChecker;
import com.limegroup.gnutella.malware.VirusScanner;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.metadata.MetaDataFactory;
import com.limegroup.gnutella.metadata.audio.AudioMetaData;
import com.limegroup.gnutella.spam.SpamManager;
import com.limegroup.gnutella.templates.StoreFileNameTemplateProcessor;
import com.limegroup.gnutella.templates.StoreSubDirectoryTemplateProcessor;
import com.limegroup.gnutella.templates.StoreTemplateProcessor;
import com.limegroup.gnutella.tigertree.HashTreeCache;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.limewire.activation.api.ActivationManager;
import org.limewire.concurrent.ListeningExecutorService;
import org.limewire.core.api.Category;
import org.limewire.core.api.download.SaveLocationManager;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.api.network.BandwidthCollector;
import org.limewire.core.settings.SharingSettings;
import org.limewire.net.SocketsManager;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.Visitor;

class StoreDownloaderImpl
extends ManagedDownloaderImpl
implements StoreDownloader {
    private final Provider<MetaDataFactory> metaDataFactory;
    private final CategoryManager categoryManager;

    @Inject
    public StoreDownloaderImpl(SaveLocationManager saveLocationManager, DownloadManager downloadManager, @GnutellaFiles FileCollection gnutellaFileCollection, IncompleteFileManager incompleteFileManager, DownloadCallback downloadCallback, NetworkManager networkManager, AlternateLocationFactory alternateLocationFactory, RequeryManagerFactory requeryManagerFactory, QueryRequestFactory queryRequestFactory, OnDemandUnicaster onDemandUnicaster, DownloadWorkerFactory downloadWorkerFactory, AltLocManager altLocManager, ContentManager contentManager, SourceRankerFactory sourceRankerFactory, UrnCache urnCache, VerifyingFileFactory verifyingFileFactory, DiskController diskController, IPFilter ipFilter, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<MessageRouter> messageRouter, Provider<HashTreeCache> tigerTreeCache, ApplicationServices applicationServices, RemoteFileDescFactory remoteFileDescFactory, Provider<PushList> pushListProvider, SocketsManager socketsManager, Provider<MetaDataFactory> metaDataFactory, @Named(value="downloadStateProcessingQueue") ListeningExecutorService downloadStateProcessingQueue, DangerousFileChecker dangerousFileChecker, VirusScanner virusScanner, SpamManager spamManager, Library library, CategoryManager categoryManager, BandwidthCollector bandwidthCollector, ActivationManager activationManager) {
        super(saveLocationManager, downloadManager, gnutellaFileCollection, incompleteFileManager, downloadCallback, networkManager, alternateLocationFactory, requeryManagerFactory, queryRequestFactory, onDemandUnicaster, downloadWorkerFactory, altLocManager, contentManager, sourceRankerFactory, urnCache, verifyingFileFactory, diskController, ipFilter, backgroundExecutor, messageRouter, tigerTreeCache, applicationServices, remoteFileDescFactory, pushListProvider, socketsManager, downloadStateProcessingQueue, dangerousFileChecker, virusScanner, spamManager, library, categoryManager, bandwidthCollector, activationManager);
        this.metaDataFactory = metaDataFactory;
        this.categoryManager = categoryManager;
    }

    @Override
    protected synchronized void initializeRanker(SourceRanker ranker) {
        super.initializeRanker(ranker);
        ranker.setRfdVisitor(new Visitor<RemoteFileDescContext>(){

            @Override
            public boolean visit(RemoteFileDescContext context) {
                int code = context.getLastHttpCode();
                return code < 400 || code > 499;
            }
        });
    }

    @Override
    public QueryRequest newRequery() throws CantResumeException {
        return null;
    }

    @Override
    public boolean allowAddition(RemoteFileDesc other) {
        return false;
    }

    @Override
    public boolean canSendRequeryNow() {
        return false;
    }

    @Override
    protected void initializeIncompleteFile() throws IOException {
        if (this.getContentLength() != -1L) {
            super.initializeIncompleteFile();
        }
    }

    @Override
    public int getNumberOfAlternateLocations() {
        return 0;
    }

    @Override
    protected File getSuggestedSaveLocation(File defaultSaveFile, File newDownloadFile) throws IOException {
        if (!newDownloadFile.getName().toLowerCase(Locale.US).endsWith("mp3")) {
            return defaultSaveFile;
        }
        AudioMetaData metaData = null;
        try {
            metaData = (AudioMetaData)this.metaDataFactory.get().parse(newDownloadFile);
        }
        catch (IOException e) {
            return defaultSaveFile;
        }
        if (metaData == null) {
            return defaultSaveFile;
        }
        HashMap<String, String> subs = new HashMap<String, String>();
        if (!this.createSubstitutes(subs, metaData)) {
            return defaultSaveFile;
        }
        Category category = this.categoryManager.getCategoryForFile(defaultSaveFile);
        File realOutputDir = this.getLWSDirectory(SharingSettings.getSaveDirectory(category), subs);
        if (!FileUtils.setWriteable(realOutputDir)) {
            return defaultSaveFile;
        }
        String fileName = this.getLWSFileName(defaultSaveFile, subs);
        try {
            File f = new File(realOutputDir, CommonUtils.convertFileName(realOutputDir, fileName));
            return f;
        }
        catch (IOException e) {
            return defaultSaveFile;
        }
    }

    @Override
    public boolean isRelocatable() {
        return super.isRelocatable() || this.getState() == Downloader.DownloadState.SAVING;
    }

    private File getLWSDirectory(File directory, Map<String, String> subs) {
        String template = SharingSettings.getSubDirectoryLWSTemplate();
        if (template == null || template.length() == 0) {
            return directory;
        }
        File outDir = null;
        try {
            outDir = new StoreSubDirectoryTemplateProcessor().getOutputDirectory(template, subs, directory);
        }
        catch (StoreTemplateProcessor.IllegalTemplateException e) {
            return directory;
        }
        if (outDir == null) {
            return directory;
        }
        outDir.mkdirs();
        FileUtils.setWriteable(outDir);
        if (!(outDir.isDirectory() && outDir.canRead() && FileUtils.canWrite(outDir))) {
            return directory;
        }
        return outDir;
    }

    private String getLWSFileName(File defaultSaveFile, Map<String, String> subs) {
        String currentFileName = defaultSaveFile.getName();
        String template = SharingSettings.getFileNameLWSTemplate();
        try {
            currentFileName = new StoreFileNameTemplateProcessor().getFileName(template, subs);
            if (currentFileName == null || currentFileName.length() == 0) {
                return defaultSaveFile.getName();
            }
        }
        catch (StoreTemplateProcessor.IllegalTemplateException e) {
            return defaultSaveFile.getName();
        }
        String ext = FileUtils.getFileExtension(defaultSaveFile);
        if (!ext.isEmpty()) {
            return currentFileName + "." + ext;
        }
        return defaultSaveFile.getName();
    }

    private boolean createSubstitutes(Map<String, String> subs, AudioMetaData metaData) {
        String artist = metaData.getArtist();
        String album = metaData.getAlbum();
        String track = metaData.getTrack();
        String title = metaData.getTitle();
        if (artist == null || album == null || title == null || track == null) {
            return false;
        }
        try {
            artist = CommonUtils.sanitizeFolderName(artist);
            album = CommonUtils.sanitizeFolderName(album);
            track = StoreDownloaderImpl.sanitizeTrack(track);
            title = CommonUtils.sanitizeFolderName(title);
        }
        catch (IOException e) {
            return false;
        }
        subs.put("artist", artist);
        subs.put("album", album);
        subs.put("title", title);
        subs.put("track", track);
        return true;
    }

    private static String sanitizeTrack(String track) {
        String[] subStrings = track.split("/");
        String trackNumber = subStrings[0].trim();
        if (trackNumber.length() == 1) {
            trackNumber = 0 + trackNumber;
        }
        return trackNumber;
    }

    @Override
    protected URN saveTreeHash(URN fileHash) {
        return null;
    }

    @Override
    protected void shareSavedFile(File saveFile) {
        this.library.add(saveFile);
    }

    @Override
    public DownloaderType getDownloadType() {
        return DownloaderType.STORE;
    }

    @Override
    protected boolean shouldPublishIFD() {
        return false;
    }
}

