/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.lws.server;

import com.google.inject.Inject;
import com.limegroup.gnutella.http.HttpExecutor;
import com.limegroup.gnutella.lws.server.LWSManager;
import com.limegroup.gnutella.lws.server.LWSManagerCommandResponseHandler;
import com.limegroup.gnutella.lws.server.LWSManagerCommandResponseHandlerWithCallback;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.nio.protocol.NHttpRequestHandler;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.limewire.core.settings.LWSSettings;
import org.limewire.inject.EagerSingleton;
import org.limewire.lws.server.AbstractReceivesCommandsFromDispatcher;
import org.limewire.lws.server.LWSConnectionListener;
import org.limewire.lws.server.LWSDispatcher;
import org.limewire.lws.server.LWSDispatcherFactory;
import org.limewire.lws.server.LWSDispatcherFactoryImpl;
import org.limewire.lws.server.LWSSenderOfMessagesToServer;
import org.limewire.lws.server.StringCallback;
import org.limewire.util.EncodingUtils;

@EagerSingleton
public final class LWSManagerImpl
implements LWSManager,
LWSSenderOfMessagesToServer {
    private static final Log LOG = LogFactory.getLog(LWSManagerImpl.class);
    static final String COMMAND_PAGE_WITH_LEADING_AND_TRAILING_SLASHES = "/store/app/pages/client/ClientCom/command/";
    private final LWSDispatcher dispatcher;
    private final Map<String, LWSManagerCommandResponseHandler> commands2handlers = new HashMap<String, LWSManagerCommandResponseHandler>();
    private final String hostNameAndPort;
    private final HttpExecutor exe;
    private boolean isConnected;

    @Inject
    public LWSManagerImpl(HttpExecutor exe) {
        this(exe, new LWSDispatcherFactoryImpl());
    }

    public LWSManagerImpl(HttpExecutor exe, LWSDispatcherFactory lwsDispatcherFactory) {
        this(exe, LWSSettings.LWS_AUTHENTICATION_HOSTNAME.get(), LWSSettings.LWS_AUTHENTICATION_PORT.getValue(), lwsDispatcherFactory);
    }

    public LWSManagerImpl(HttpExecutor exe, String host, int port, LWSDispatcherFactory lwsDispatcherFactory) {
        this.exe = exe;
        this.dispatcher = lwsDispatcherFactory.createDispatcher(this, new AbstractReceivesCommandsFromDispatcher(){

            @Override
            public String receiveCommand(String cmd, Map<String, String> args) {
                return LWSManagerImpl.this.dispatch(cmd, args);
            }
        });
        StringBuilder hostNameAndPortBuffer = new StringBuilder(host);
        if (port > 0) {
            hostNameAndPortBuffer.append(":").append(port);
        }
        this.hostNameAndPort = hostNameAndPortBuffer.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("hostname and port: " + this.hostNameAndPort);
        }
        this.dispatcher.addConnectionListener(new LWSConnectionListener(){

            @Override
            public void connectionChanged(boolean isConnected) {
                LWSManagerImpl.this.isConnected = isConnected;
            }
        });
        this.registerHandler("IsConnected", new LWSManagerCommandResponseHandlerWithCallback("IsConnected"){

            @Override
            protected String handleRest(Map<String, String> args) {
                return "ok";
            }
        });
    }

    @Override
    public final boolean addConnectionListener(LWSConnectionListener lis) {
        return this.dispatcher.addConnectionListener(lis);
    }

    @Override
    public final boolean removeConnectionListener(LWSConnectionListener lis) {
        return this.dispatcher.removeConnectionListener(lis);
    }

    @Override
    public final NHttpRequestHandler getHandler() {
        return this.dispatcher;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public final boolean registerHandler(String cmd, LWSManagerCommandResponseHandler lis) {
        if (lis == null) {
            throw new NullPointerException("Handlers can't be null");
        }
        String hash = this.hash(cmd);
        this.commands2handlers.put(hash, lis);
        return true;
    }

    @Override
    public final boolean unregisterHandler(String cmd) {
        String hash = this.hash(cmd);
        return this.commands2handlers.remove(hash) != null;
    }

    @Override
    public final void clearHandlers() {
        this.commands2handlers.clear();
    }

    @Override
    public final void sendMessageToServer(String msg, Map<String, String> args, StringCallback cb) throws IOException {
        HttpGet get;
        String url = this.constructURL(msg, args);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sending URL " + url);
        }
        if ((get = new HttpGet(url)).getURI().getHost() == null) {
            LOG.error("null host!");
            throw new IOException("null host!");
        }
        get.addHeader("User-Agent", LimeWireUtils.getHttpServer());
        cb.process("ok");
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(params, 1000);
        HttpConnectionParams.setSoTimeout(params, 1000);
        this.exe.execute(get, params);
    }

    private String constructURL(String msg, Map<String, String> args) {
        StringBuilder url = new StringBuilder("http");
        if (LWSSettings.LWS_USE_SSL.getValue()) {
            url.append("s");
        }
        url.append("://").append(this.hostNameAndPort).append(COMMAND_PAGE_WITH_LEADING_AND_TRAILING_SLASHES);
        url.append(msg);
        for (Map.Entry<String, String> e : args.entrySet()) {
            url.append("/");
            url.append(e.getKey()).append("/").append(EncodingUtils.encode(e.getValue()));
        }
        return url.toString();
    }

    private String hash(String cmd) {
        return cmd.toLowerCase(Locale.US);
    }

    private String dispatch(String command, Map<String, String> arguments) {
        String hash = this.hash(command);
        String result = null;
        LWSManagerCommandResponseHandler handler = this.commands2handlers.get(hash);
        if (handler != null && (result = handler.handle(arguments)) == null) {
            result = "OK";
        }
        return result;
    }
}

