/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.malware;

import com.limegroup.gnutella.malware.DangerousFileType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.limewire.bittorrent.bencoding.Token;
import org.limewire.io.IOUtils;
import org.limewire.util.BEncoder;
import org.limewire.util.Base32;
import org.limewire.util.StringUtils;

class FileExtensionEncoder {
    FileExtensionEncoder() {
    }

    public static void main(String[] args) {
        try {
            String setting = FileExtensionEncoder.encodeSetting(DangerousFileType.getKnownTypes());
            FileExtensionEncoder.decodeSetting(setting);
            System.out.println(setting);
        }
        catch (IOException e) {
            System.err.println("Setting could not be encoded: " + e);
            System.exit(1);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Setting could not be decoded: " + e);
            System.exit(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String encodeSetting(DangerousFileType[] types) throws IOException {
        ArrayList<String> mime = new ArrayList<String>();
        ArrayList<List<String>> ext = new ArrayList<List<String>>();
        HashMap<String, ArrayList<Object>> payload = new HashMap<String, ArrayList<Object>>();
        payload.put("m", mime);
        payload.put("e", ext);
        for (DangerousFileType d : types) {
            mime.add(d.mimeType);
            ext.add(Arrays.asList(d.extensions));
        }
        ByteArrayOutputStream zipped = new ByteArrayOutputStream();
        DeflaterOutputStream zip = new DeflaterOutputStream(zipped);
        try {
            BEncoder.getEncoder(zip, true, false, "UTF-8").encodeDict(payload);
            zip.flush();
        }
        finally {
            IOUtils.close(zip);
        }
        return Base32.encode(zipped.toByteArray());
    }

    protected static DangerousFileType[] decodeSetting(String setting) throws IllegalArgumentException {
        DangerousFileType[] dangerousFileTypeArray;
        InflaterInputStream unzip = null;
        ReadableByteChannel byteChannel = null;
        try {
            ByteArrayInputStream zipped = new ByteArrayInputStream(Base32.decode(setting));
            unzip = new InflaterInputStream(zipped);
            byteChannel = Channels.newChannel(unzip);
            Object bencoded = Token.parse(byteChannel, "UTF-8");
            Map map = (Map)bencoded;
            List m = (List)map.get("m");
            List e = (List)map.get("e");
            DangerousFileType[] types = new DangerousFileType[m.size()];
            for (int i = 0; i < types.length; ++i) {
                String mime = StringUtils.getUTF8String((byte[])m.get(i));
                List extList = (List)e.get(i);
                String[] ext = new String[extList.size()];
                for (int j = 0; j < ext.length; ++j) {
                    ext[j] = StringUtils.getUTF8String((byte[])extList.get(j));
                }
                types[i] = new DangerousFileType(mime, ext);
            }
            dangerousFileTypeArray = types;
        }
        catch (Throwable t) {
            try {
                throw new IllegalArgumentException(t);
            }
            catch (Throwable throwable) {
                IOUtils.close(byteChannel);
                IOUtils.close(unzip);
                throw throwable;
            }
        }
        IOUtils.close(byteChannel);
        IOUtils.close(unzip);
        return dangerousFileTypeArray;
    }
}

