/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.messages.PingRequestImpl;
import java.util.LinkedList;
import java.util.List;
import org.limewire.core.settings.ConnectionSettings;
import org.limewire.io.GUID;
import org.limewire.util.NameValue;

@Singleton
public class PingRequestFactoryImpl
implements PingRequestFactory {
    public final NetworkManager networkManager;
    private final ConnectionServices connectionServices;

    @Inject
    public PingRequestFactoryImpl(NetworkManager networkManager, ConnectionServices connectionServices) {
        this.networkManager = networkManager;
        this.connectionServices = connectionServices;
    }

    @Override
    public PingRequest createPingRequest(byte[] guid, byte ttl, byte hops) {
        return new PingRequestImpl(guid, ttl, hops);
    }

    @Override
    public PingRequest createFromNetwork(byte[] guid, byte ttl, byte hops, byte[] payload, Message.Network network) {
        return new PingRequestImpl(guid, ttl, hops, payload);
    }

    @Override
    public PingRequest createPingRequest(byte ttl) {
        return new PingRequestImpl(ttl);
    }

    @Override
    public PingRequest createPingRequest(byte[] guid, byte ttl) {
        return new PingRequestImpl(guid, ttl);
    }

    @Override
    public PingRequest createQueryKeyRequest() {
        LinkedList l = new LinkedList();
        l.add(new NameValue("QK"));
        return new PingRequestImpl(GUID.makeGuid(), 1, l);
    }

    @Override
    public PingRequest createUDPPing() {
        LinkedList l = new LinkedList();
        return new PingRequestImpl(this.populateUDPGGEPList(l).bytes(), 1, l);
    }

    @Override
    public PingRequest createUDPingWithDHTIPPRequest() {
        LinkedList l = new LinkedList();
        GUID guid = new GUID();
        l.add(new NameValue("DHTIPP"));
        return new PingRequestImpl(guid.bytes(), 1, l);
    }

    @Override
    public PingRequest createUHCPing() {
        LinkedList ggeps = new LinkedList();
        GUID guid = this.populateUDPGGEPList(ggeps);
        ggeps.add(new NameValue("UDPHC"));
        return new PingRequestImpl(guid.bytes(), 1, ggeps);
    }

    @Override
    public PingRequest createMulticastPing() {
        GUID guid = new GUID();
        LinkedList l = new LinkedList();
        l.add(new NameValue<byte[]>("SCP", this.getSCPData()));
        return new PingRequestImpl(guid.bytes(), 1, l);
    }

    private GUID populateUDPGGEPList(List<NameValue<?>> l) {
        GUID guid;
        if (ConnectionSettings.EVER_ACCEPTED_INCOMING.getValue()) {
            guid = PingRequest.UDP_GUID;
        } else {
            l.add(new NameValue("IP"));
            guid = this.networkManager.getSolicitedGUID();
        }
        l.add(new NameValue<byte[]>("SCP", this.getSCPData()));
        return guid;
    }

    byte[] getSCPData() {
        byte[] data = new byte[]{this.connectionServices.isSupernode() ? (byte)1 : 0};
        if (this.networkManager.isIncomingTLSEnabled()) {
            data[0] = (byte)(data[0] | 2);
        }
        return data;
    }
}

