/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil;

import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeTypeHashSet;
import eu.medsea.mimeutil.detector.MimeDetector;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class MimeUtilMimeDetectorRegistry {
    private static Log log = LogFactory.getLog(MimeUtilMimeDetectorRegistry.class);
    private Map mimeDetectors = new TreeMap();

    MimeUtilMimeDetectorRegistry() {
    }

    MimeDetector addMimeDetector(MimeDetector mimeDetector) {
        if (this.mimeDetectors.containsKey(mimeDetector.getName())) {
            log.error("MimeDetector [" + mimeDetector.getName() + "] will not be registered as a MimeDetector with this name is already registered.");
            return (MimeDetector)this.mimeDetectors.get(mimeDetector.getName());
        }
        if (log.isDebugEnabled()) {
            log.debug("Registering MimeDetect with name [" + mimeDetector.getName() + "] and description [" + mimeDetector.getDescription() + "]");
        }
        return this.mimeDetectors.put(mimeDetector.getName(), mimeDetector);
    }

    MimeDetector getMimeDetector(String string) {
        return (MimeDetector)this.mimeDetectors.get(string);
    }

    Collection getMimeTypes(byte[] byArray, MimeType mimeType) throws MimeException {
        MimeTypeHashSet mimeTypeHashSet = new MimeTypeHashSet();
        if (byArray != null) {
            Iterator iterator = this.mimeDetectors.values().iterator();
            while (iterator.hasNext()) {
                try {
                    MimeDetector mimeDetector = (MimeDetector)iterator.next();
                    mimeTypeHashSet.addAll(mimeDetector.getMimeTypes(byArray));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
                catch (Exception exception) {
                    log.error(exception, exception);
                }
            }
        }
        if (mimeTypeHashSet.isEmpty()) {
            mimeTypeHashSet.add(mimeType);
        }
        if (log.isDebugEnabled()) {
            log.debug("Retrieved mime types [" + ((Object)mimeTypeHashSet).toString() + "]");
        }
        return mimeTypeHashSet;
    }

    Collection getMimeTypes(File file, MimeType mimeType) throws MimeException {
        MimeTypeHashSet mimeTypeHashSet = new MimeTypeHashSet();
        Iterator iterator = this.mimeDetectors.values().iterator();
        while (iterator.hasNext()) {
            try {
                MimeDetector mimeDetector = (MimeDetector)iterator.next();
                mimeTypeHashSet.addAll(mimeDetector.getMimeTypes(file));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (Exception exception) {
                log.error(exception, exception);
            }
        }
        if (mimeTypeHashSet.isEmpty()) {
            mimeTypeHashSet.add(mimeType);
        }
        if (log.isDebugEnabled()) {
            log.debug("Retrieved mime types [" + ((Object)mimeTypeHashSet).toString() + "]");
        }
        return mimeTypeHashSet;
    }

    Collection getMimeTypes(InputStream inputStream, MimeType mimeType) throws MimeException {
        MimeTypeHashSet mimeTypeHashSet = new MimeTypeHashSet();
        Iterator iterator = this.mimeDetectors.values().iterator();
        while (iterator.hasNext()) {
            try {
                MimeDetector mimeDetector = (MimeDetector)iterator.next();
                mimeTypeHashSet.addAll(mimeDetector.getMimeTypes(inputStream));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (Exception exception) {
                log.error(exception, exception);
            }
        }
        if (mimeTypeHashSet.isEmpty()) {
            mimeTypeHashSet.add(mimeType);
        }
        if (log.isDebugEnabled()) {
            log.debug("Retrieved mime types [" + ((Object)mimeTypeHashSet).toString() + "]");
        }
        return mimeTypeHashSet;
    }

    Collection getMimeTypes(String string, MimeType mimeType) throws MimeException {
        MimeTypeHashSet mimeTypeHashSet = new MimeTypeHashSet();
        Iterator iterator = this.mimeDetectors.values().iterator();
        while (iterator.hasNext()) {
            try {
                MimeDetector mimeDetector = (MimeDetector)iterator.next();
                mimeTypeHashSet.addAll(mimeDetector.getMimeTypes(string));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (Exception exception) {
                log.error(exception, exception);
            }
        }
        if (mimeTypeHashSet.isEmpty()) {
            mimeTypeHashSet.add(mimeType);
        }
        if (log.isDebugEnabled()) {
            log.debug("Retrieved mime types [" + ((Object)mimeTypeHashSet).toString() + "]");
        }
        return mimeTypeHashSet;
    }

    MimeDetector removeMimeDetector(MimeDetector mimeDetector) {
        if (mimeDetector == null) {
            log.error("Cannot remove NULL from MimeDetector registry.");
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Removing MimeDetector [" + mimeDetector.getName() + "] from registry.");
        }
        return (MimeDetector)this.mimeDetectors.remove(mimeDetector.getName());
    }
}

