/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil.detector;

import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import eu.medsea.mimeutil.detector.InvalidMagicMimeEntryException;
import eu.medsea.mimeutil.detector.MagicMimeEntry;
import eu.medsea.mimeutil.detector.MimeDetector;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MagicMimeMimeDetector
extends MimeDetector {
    private static Log log = LogFactory.getLog(MagicMimeMimeDetector.class);
    private static ArrayList mMagicMimeEntries = new ArrayList();

    @Override
    public String getDescription() {
        return "Get the mime types of files or streams using the Unix file(5) magic.mime files";
    }

    @Override
    public Collection getMimeTypesByteArray(byte[] byArray) throws MimeException {
        HashSet<MimeType> hashSet = new HashSet<MimeType>();
        int n = mMagicMimeEntries.size();
        try {
            for (int i = 0; i < n; ++i) {
                MagicMimeEntry magicMimeEntry = (MagicMimeEntry)mMagicMimeEntries.get(i);
                MagicMimeEntry magicMimeEntry2 = magicMimeEntry.getMatch(byArray);
                if (magicMimeEntry2 == null) continue;
                hashSet.add(magicMimeEntry2.getMimeType());
            }
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), exception);
        }
        return hashSet;
    }

    @Override
    public Collection getMimeTypesInputStream(InputStream inputStream) throws MimeException {
        HashSet<MimeType> hashSet = new HashSet<MimeType>();
        int n = mMagicMimeEntries.size();
        try {
            for (int i = 0; i < n; ++i) {
                MagicMimeEntry magicMimeEntry = (MagicMimeEntry)mMagicMimeEntries.get(i);
                MagicMimeEntry magicMimeEntry2 = magicMimeEntry.getMatch(inputStream);
                if (magicMimeEntry2 == null) continue;
                hashSet.add(magicMimeEntry2.getMimeType());
            }
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), exception);
        }
        return hashSet;
    }

    @Override
    public Collection getMimeTypesFile(File file) throws MimeException {
        HashSet<MimeType> hashSet = new HashSet<MimeType>();
        if (!file.exists()) {
            return hashSet;
        }
        if (file.isDirectory()) {
            hashSet.add(MimeUtil.DIRECTORY_MIME_TYPE);
            return hashSet;
        }
        int n = mMagicMimeEntries.size();
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            for (int i = 0; i < n; ++i) {
                MagicMimeEntry magicMimeEntry = (MagicMimeEntry)mMagicMimeEntries.get(i);
                MagicMimeEntry magicMimeEntry2 = magicMimeEntry.getMatch(randomAccessFile);
                if (magicMimeEntry2 == null) continue;
                hashSet.add(magicMimeEntry2.getMimeType());
            }
        }
        catch (Exception exception) {
            throw new MimeException("Error parsing file [" + file.getAbsolutePath() + "]", exception);
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {
                    log.error("Error closing file.", exception);
                }
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initMagicRules() {
        InputStream inputStream = null;
        try {
            String string = "eu/medsea/mimeutil/magic.mime";
            inputStream = MimeUtil.class.getClassLoader().getResourceAsStream(string);
            MagicMimeMimeDetector.parse("resource:" + string, new InputStreamReader(inputStream));
        }
        catch (Exception exception) {
            log.error("Failed to process internal magic.mime file.", exception);
        }
        finally {
            if (inputStream != null) {
                block13: {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        if (!log.isDebugEnabled()) break block13;
                        log.debug(exception.getMessage(), exception);
                    }
                }
                inputStream = null;
            }
        }
    }

    private static void parse(String string, Reader reader) throws IOException {
        long l = System.currentTimeMillis();
        BufferedReader bufferedReader = new BufferedReader(reader);
        ArrayList<String> arrayList = new ArrayList<String>();
        long l2 = 0L;
        String string2 = bufferedReader.readLine();
        if (string2 != null) {
            ++l2;
        }
        block0: while (string2 != null) {
            if ((string2 = string2.trim()).length() == 0 || string2.charAt(0) == '#') {
                string2 = bufferedReader.readLine();
                if (string2 == null) continue;
                ++l2;
                continue;
            }
            arrayList.add(string2);
            while (true) {
                if ((string2 = bufferedReader.readLine()) != null) {
                    ++l2;
                }
                if (string2 == null) {
                    MagicMimeMimeDetector.addEntry(string, l2, arrayList);
                    arrayList.clear();
                    continue block0;
                }
                if ((string2 = string2.trim()).length() == 0 || string2.charAt(0) == '#') continue;
                if (string2.charAt(0) != '>') {
                    MagicMimeMimeDetector.addEntry(string, l2, arrayList);
                    arrayList.clear();
                    continue block0;
                }
                arrayList.add(string2);
            }
        }
        if (!arrayList.isEmpty()) {
            MagicMimeMimeDetector.addEntry(string, l2, arrayList);
        }
        if (log.isDebugEnabled()) {
            log.debug("Parsing \"" + string + "\" took " + (System.currentTimeMillis() - l) + " msec.");
        }
    }

    private static void addEntry(String string, long l, ArrayList arrayList) {
        try {
            MagicMimeEntry magicMimeEntry = new MagicMimeEntry(arrayList);
            mMagicMimeEntries.add(magicMimeEntry);
            if (magicMimeEntry.getMimeType() != null) {
                MimeUtil.addKnownMimeType(magicMimeEntry.getMimeType());
            }
        }
        catch (InvalidMagicMimeEntryException invalidMagicMimeEntryException) {
            log.warn(invalidMagicMimeEntryException.getClass().getName() + ": " + invalidMagicMimeEntryException.getMessage() + ": file \"" + string + "\": before or at line " + l, invalidMagicMimeEntryException);
        }
    }

    static {
        MagicMimeMimeDetector.initMagicRules();
        MimeUtil.addMimeDetector(new MagicMimeMimeDetector());
    }
}

